CREATE TABLE [CameraPoint] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[ParentId] BIGINT  NULL,
[Name] VARCHAR(128)  NOT NULL,
[Direction] FLOAT DEFAULT '0' NULL,
[Ratio] INT NULL,
[Company] VARCHAR(200) NULL,
[BelongTo] VARCHAR(200) NULL,
[Address] VARCHAR(1000) NULL,
[View] INT DEFAULT 90 NULL,
[GisX] DOUBLE DEFAULT '0' NULL,
[GisY] DOUBLE DEFAULT '0' NULL,
[DeviceType] INT NULL,
[PlatformType] INT NULL,
[ManagementType] INT NULL,
[Keyword] VARCHAR(1000) NULL,
[Notes] VARCHAR(1024)  NULL
);

CREATE TABLE [CameraPointAccess] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[UserId] BIGINT  NOT NULL,
[CameraPointId] BIGINT  NOT NULL,
[Action] INTEGER DEFAULT '0' NOT NULL
);

CREATE TABLE [CameraPointAuthorize] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[UserId] BIGINT  NOT NULL,
[CameraPointId] BIGINT  NOT NULL,
[Power] INTEGER DEFAULT '0' NULL
);

CREATE TABLE [CameraPointVideo] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[Name] VARCHAR(128)  NULL,
[CameraPointId] BIGINT  NULL,
[IsSliced] INTEGER DEFAULT '0' NULL
);

CREATE TABLE [CasePartAccess] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[UserId] BIGINT  NOT NULL,
[Action] INTEGER  NULL
);

CREATE TABLE [CasePartAuthorize] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[UserId] BIGINT  NOT NULL,
[Power] INTEGER  NULL
);




CREATE TABLE [GraphicType] (
[Id] INTEGER PRIMARY KEY,
[Name] VARCHAR(128)  NOT NULL
);
CREATE TABLE [GraphicDrawTool] (
[Id]   INTEGER PRIMARY KEY,
[TypeID] INTEGER  NOT NULL,
[Name] NVARCHAR(128) NULL,
[Text] TEXT DEFAULT '' NULL
);

CREATE TABLE [GraphicPoint] (
[Id]  INTEGER PRIMARY KEY,
[GraphicID] INTEGER  NOT NULL,
[GisX] DOUBLE DEFAULT 0 NULL,
[GisY] DOUBLE DEFAULT 0 NULL,
[Image] TEXT  DEFAULT '' NULL
);
CREATE TABLE [GraphicPen] (
[Id] INTEGER PRIMARY KEY,
[GraphicID] INTEGER  NOT NULL,
[Red] INT DEFAULT 0 NULL,
[Green] INT DEFAULT 0 NULL,
[Blue] INT DEFAULT 0 NULL,
[Width] INT DEFAULT 1 NULL,
[LineType] INT DEFAULT 0 NULL,
[Alpha] INT DEFAULT 255 NULL
);
CREATE TABLE [GraphicBrush] (
[Id] INTEGER PRIMARY KEY,
[GraphicID] INTEGER  NOT NULL,
[Red] INT DEFAULT 0 NULL,
[Green] INT DEFAULT 0 NULL,
[Blue] INT DEFAULT 0 NULL,
[Width] INT DEFAULT 1 NULL,
[FillType] INT DEFAULT 1 NULL,
[Alpha] INT DEFAULT 255 NULL
);
CREATE TABLE [GraphicFont] (
[Id] INTEGER PRIMARY KEY,
[GraphicID] INTEGER  NOT NULL,
[Red] INT DEFAULT 0 NULL,
[Green] INT DEFAULT 0 NULL,
[Blue] INT DEFAULT 0 NULL,
[Size] INT DEFAULT 10 NULL,
[Type] INT DEFAULT 1 NULL
);
CREATE TABLE [Param] (
[Id] BIGINT  NOT NULL PRIMARY KEY,
[Name] VARCHAR(128)  NOT NULL,
[Value] VARCHAR(128)  NULL
);

CREATE TABLE [TrailCatalog] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[ParentId] BIGINT DEFAULT '0' NULL,
[Name] VARCHAR(128)  NOT NULL,
[Creator] VARCHAR(128)  NULL,
[BeginTime] DATETIME  NULL,
[EndTime] DATETIME  NULL,
[Location] VARCHAR(128)  NULL,
[SuspectObject] VARCHAR(128)  NULL,
[Description] VARCHAR(128)  NULL,
[Keyword] VARCHAR(50)  NULL
);

CREATE TABLE [TrailContent] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[TrailId] BIGINT  NOT NULL,
[Name] VARCHAR(128)  NOT NULL,
[Description] VARCHAR(128)  NULL,
[Type] INTEGER  NULL,
[Data] TEXT  NULL,
[Link] VARCHAR(255)  NULL
);

CREATE TABLE [Trails] (
[Id] BIGINT  PRIMARY KEY NOT NULL,
[ParentId] BIGINT  NOT NULL,
[Name] VARCHAR(128)  NOT NULL,
[CreatorId] BIGINT  NULL,
[Creator] VARCHAR(128)  NULL,
[Time] DATETIME  NULL,
[Target] VARCHAR(128)  NULL,
[GisX] DOUBLE DEFAULT '0' NULL,
[GisY] DOUBLE DEFAULT '0' NULL,
[Place] VARCHAR(128)  NULL,
[Keyword] VARCHAR(128)  NULL,
[Description] VARCHAR(128)  NULL
);

CREATE TABLE [User] (
[Id] BIGINT  NOT NULL PRIMARY KEY,
[Name] VARCHAR(128)  NOT NULL,
[Password] VARCHAR(128)  NULL
);

