/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.util;

import java.util.ArrayList;
import java.util.Arrays;

public class StringUtil {
    public static String collapsePathDots(String path) {
        String[] stringParts = path.split("/");
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(stringParts));
        int i = 0;
        while (i < parts.size() - 1) {
            String currentDir = (String)parts.get(i);
            if (currentDir.length() == 0 || currentDir.equals(".")) {
                parts.remove(i);
                --i;
            } else if (currentDir.equals("..")) {
                parts.remove(i - 1);
                parts.remove(i - 1);
                i -= 2;
            }
            ++i;
        }
        StringBuilder result = new StringBuilder();
        if (path.startsWith("/")) {
            result.append('/');
        }
        int i2 = 0;
        while (i2 < parts.size()) {
            result.append((String)parts.get(i2));
            if (i2 < parts.size() - 1) {
                result.append('/');
            }
            ++i2;
        }
        return result.toString();
    }

    public static boolean isNotBlank(String text) {
        return !StringUtil.isBlank(text);
    }

    public static boolean isBlank(String text) {
        if (StringUtil.isEmpty(text)) {
            return true;
        }
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static boolean endsWithIgnoreCase(String source, String suffix) {
        if (StringUtil.isEmpty(suffix)) {
            return true;
        }
        if (StringUtil.isEmpty(source)) {
            return false;
        }
        if (suffix.length() > source.length()) {
            return false;
        }
        return source.substring(source.length() - suffix.length()).toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static String defaultIfNull(String text) {
        return StringUtil.defaultIfNull(text, "");
    }

    public static String defaultIfNull(String text, String defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        return text;
    }

    public static boolean equals(String text1, String text2) {
        if (text1 == null) {
            return text2 == null;
        }
        return text1.equals(text2);
    }

    public static String toString(Object ... keyValues) {
        StringBuilder result = new StringBuilder();
        result.append('[');
        int i = 0;
        while (i < keyValues.length) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(keyValues[i]);
            result.append(": ");
            Object value = null;
            if (i + 1 < keyValues.length) {
                value = keyValues[i + 1];
            }
            if (value == null) {
                result.append("<null>");
            } else {
                result.append('\'');
                result.append(value);
                result.append('\'');
            }
            i += 2;
        }
        result.append(']');
        return result.toString();
    }

    public static int hashCode(String ... values) {
        int result = 31;
        int i = 0;
        while (i < values.length) {
            result ^= String.valueOf(values[i]).hashCode();
            ++i;
        }
        return result;
    }

    public static String substringBefore(String text, char separator) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        int sepPos = text.indexOf(separator);
        if (sepPos < 0) {
            return text;
        }
        return text.substring(0, sepPos);
    }

    public static String substringBeforeLast(String text, char separator) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        int cPos = text.lastIndexOf(separator);
        if (cPos < 0) {
            return text;
        }
        return text.substring(0, cPos);
    }

    public static String substringAfterLast(String text, char separator) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        int cPos = text.lastIndexOf(separator);
        if (cPos < 0) {
            return "";
        }
        return text.substring(cPos + 1);
    }

    public static String substringAfter(String text, char c) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        int cPos = text.indexOf(c);
        if (cPos < 0) {
            return "";
        }
        return text.substring(cPos + 1);
    }
}

