/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.xml.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class StringUtil {
    public static String replace(String src, String olds, String news) {
        int index = src.indexOf(olds);
        if (index < 0) {
            return src;
        }
        StringBuffer sb = new StringBuffer(src.substring(0, index));
        int olen = olds.length();
        while (true) {
            sb.append(news);
            int newIndex = src.indexOf(olds, index += olen);
            if (newIndex < 0) break;
            sb.append(src.substring(index, newIndex));
            index = newIndex;
        }
        sb.append(src.substring(index));
        String result = sb.toString();
        return result;
    }

    public static String dateToW3CDTF(Date date) {
        SimpleDateFormat w3cdtf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String s = w3cdtf.format(date);
        int index = s.length() - 2;
        return String.valueOf(s.substring(0, index)) + ":" + s.substring(index);
    }

    public static int parseRoman(String roman) {
        int acc = 0;
        int lastDigit = 0;
        int len = roman.length();
        int i = 0;
        while (i < len) {
            char c = roman.charAt(i);
            int digit = 0;
            switch (c) {
                case 'i': {
                    digit = 1;
                    break;
                }
                case 'v': {
                    digit = 5;
                    break;
                }
                case 'x': {
                    digit = 10;
                    break;
                }
                case 'l': {
                    digit = 50;
                    break;
                }
                case 'c': {
                    digit = 100;
                    break;
                }
                case 'd': {
                    digit = 500;
                    break;
                }
                case 'm': {
                    digit = 1000;
                    break;
                }
                default: {
                    return 0;
                }
            }
            acc = lastDigit >= digit ? (acc += lastDigit) : (acc -= lastDigit);
            lastDigit = digit;
            ++i;
        }
        return acc += lastDigit;
    }

    public static String printRoman(int n) {
        switch (n) {
            case 1: {
                return "i";
            }
            case 2: {
                return "ii";
            }
            case 3: {
                return "iii";
            }
            case 4: {
                return "iv";
            }
            case 5: {
                return "v";
            }
            case 9: {
                return "ix";
            }
            case 10: {
                return "x";
            }
            case 40: {
                return "xl";
            }
            case 50: {
                return "l";
            }
            case 90: {
                return "xc";
            }
            case 100: {
                return "c";
            }
            case 400: {
                return "cd";
            }
            case 500: {
                return "d";
            }
            case 900: {
                return "cm";
            }
            case 1000: {
                return "m";
            }
        }
        if (5 < n && n <= 8) {
            return "v" + StringUtil.printRoman(n - 5);
        }
        if (10 < n && n <= 20) {
            return "x" + StringUtil.printRoman(n - 10);
        }
        if (20 < n && n <= 30) {
            return "xx" + StringUtil.printRoman(n - 20);
        }
        if (30 < n && n <= 39) {
            return "xxx" + StringUtil.printRoman(n - 30);
        }
        if (40 < n && n <= 49) {
            return "xl" + StringUtil.printRoman(n - 40);
        }
        if (50 < n && n <= 89) {
            return "l" + StringUtil.printRoman(n - 50);
        }
        if (90 < n && n <= 99) {
            return "xc" + StringUtil.printRoman(n - 90);
        }
        if (100 < n && n <= 200) {
            return "c" + StringUtil.printRoman(n - 100);
        }
        if (200 < n && n <= 300) {
            return "cc" + StringUtil.printRoman(n - 200);
        }
        if (300 < n && n < 400) {
            return "ccc" + StringUtil.printRoman(n - 300);
        }
        if (400 < n && n < 500) {
            return "cd" + StringUtil.printRoman(n - 400);
        }
        if (500 < n && n < 900) {
            return "d" + StringUtil.printRoman(n - 500);
        }
        if (900 < n && n < 1000) {
            return "cm" + StringUtil.printRoman(n - 900);
        }
        if (1000 < n && n <= 2000) {
            return "m" + StringUtil.printRoman(n - 1000);
        }
        if (2000 < n && n <= 3000) {
            return "mm" + StringUtil.printRoman(n - 2000);
        }
        if (3000 < n && n < 4000) {
            return "mmm" + StringUtil.printRoman(n - 3000);
        }
        return null;
    }
}

