/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.otf;

import com.adobe.dp.otf.FileFontInputStream;
import com.adobe.dp.otf.FontInputStream;
import com.adobe.dp.otf.FontPropertyConstants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class OpenTypeFont
implements FontPropertyConstants {
    FontInputStream font;
    FileHeader header;
    byte[] buffer = new byte[256];
    int currentOffset;
    boolean trueTypeGlyphs;
    GlyphData[] glyphs;
    short fsType;
    int maxGlyphSize;
    int newGlyphCount;
    int variableWidthCount;
    int newVariableWidthCount;
    String familyName;
    int weight;
    int width;
    int style;
    NameEntry[] names;
    Hashtable characters = new Hashtable();
    private static int CFF_STD_STRING_COUNT = 391;
    String fontID;
    String nameCFF;
    Hashtable dictCFF;
    Hashtable privateDictCFF;
    StringCFF[] stringsCFF;
    Object[] globalSubrsCFF;
    Object[] privateSubrsCFF;
    static final long baseTime = 2082758400L;
    static final int[] sidIndicesCFF;
    private static final int CFF_INDEX_NAMES = 0;
    private static final int CFF_INDEX_DICTS = 1;
    private static final int CFF_INDEX_BINARY = 2;
    private static final int CFF_INDEX_BINARY_RANGE = 3;
    private static boolean noUnicodeBigUnmarked;

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 256;
        nArray[6] = 277;
        nArray[7] = 278;
        nArray[8] = 286;
        nArray[9] = 294;
        sidIndicesCFF = nArray;
        noUnicodeBigUnmarked = false;
    }

    public OpenTypeFont(FontInputStream font) throws IOException {
        this(font, false);
    }

    public OpenTypeFont(FontInputStream font, boolean queryOnly) throws IOException {
        this.font = font;
        this.readFileHeader();
        this.readOS2();
        this.readNames();
        if (!queryOnly) {
            this.readCMap();
            this.readGlyphData();
            this.readMetrics();
        }
    }

    private void readBuffer(int size) throws IOException {
        int len = this.font.read(this.buffer, 0, size);
        if (len != size) {
            throw new IOException("could not read " + size + " bytes");
        }
        this.currentOffset += size;
    }

    private void readBuffer(byte[] buf, int size) throws IOException {
        int len = this.font.read(buf, 0, size);
        if (len != size) {
            throw new IOException("could not read " + size + " bytes");
        }
        this.currentOffset += size;
    }

    private short[] readShorts(int size) throws IOException {
        if (size < 0) {
            System.err.println("Bug!");
        }
        short[] arr = new short[size];
        int offset = 0;
        while (size > 0) {
            int count = size;
            if (count > this.buffer.length / 2) {
                count = this.buffer.length / 2;
            }
            this.readBuffer(2 * count);
            int i = 0;
            while (i < count) {
                arr[offset++] = OpenTypeFont.getShort(this.buffer, 2 * i);
                ++i;
            }
            size -= count;
        }
        return arr;
    }

    private void seek(int offset) throws IOException {
        this.font.seek(offset);
        this.currentOffset = offset;
    }

    private static int getInt(byte[] buf, int offset) {
        return buf[offset] << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    private static short getShort(byte[] buf, int offset) {
        return (short)((buf[offset] & 0xFF) << 8 | buf[offset + 1] & 0xFF);
    }

    private TableDirectoryEntry findTable(String identifier) {
        return (TableDirectoryEntry)this.header.tableMap.get(identifier);
    }

    private int readGlyphCountTT() throws IOException {
        TableDirectoryEntry maxp = this.findTable("maxp");
        this.seek(maxp.offset + 4);
        this.readBuffer(2);
        return OpenTypeFont.getShort(this.buffer, 0) & 0xFFFF;
    }

    private int readIndexToLocFormatTT() throws IOException {
        TableDirectoryEntry h = this.findTable("head");
        this.seek(h.offset + 50);
        this.readBuffer(2);
        return OpenTypeFont.getShort(this.buffer, 0);
    }

    private void readGlyphDataTT() throws IOException {
        int entrySize;
        int glyphCount = this.readGlyphCountTT();
        int indexToLocFormat = this.readIndexToLocFormatTT();
        TableDirectoryEntry glyf = this.findTable("glyf");
        TableDirectoryEntry locations = this.findTable("loca");
        int n = entrySize = indexToLocFormat == 0 ? 2 : 4;
        if (locations.length != (glyphCount + 1) * entrySize) {
            throw new IOException("bad 'loca' table size");
        }
        byte[] buf = new byte[locations.length];
        this.seek(locations.offset);
        this.font.read(buf, 0, buf.length);
        GlyphData[] data = new GlyphData[glyphCount];
        int offset = 0;
        int i = 0;
        while (i <= glyphCount) {
            int glyphOffset = (indexToLocFormat == 0 ? (OpenTypeFont.getShort(buf, offset) & 0xFFFF) * 2 : OpenTypeFont.getInt(buf, offset)) + glyf.offset;
            offset += entrySize;
            if (i > 0) {
                int len = glyphOffset - data[i - 1].offset;
                if (len < 0) {
                    throw new IOException("negative glyph length");
                }
                if (this.maxGlyphSize < len) {
                    this.maxGlyphSize = len;
                }
                data[i - 1].length = len;
            }
            if (i != glyphCount) {
                data[i] = new GlyphData();
                data[i].offset = glyphOffset;
            }
            ++i;
        }
        this.glyphs = data;
    }

    private boolean decodeNibbleCFF(StringBuffer sb, int nibble) throws IOException {
        switch (nibble &= 0xF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                sb.append((char)(nibble + 48));
                break;
            }
            case 10: {
                sb.append(".");
                break;
            }
            case 11: {
                sb.append("E");
                break;
            }
            case 12: {
                sb.append("E-");
                break;
            }
            case 14: {
                sb.append("-");
                break;
            }
            case 15: {
                return true;
            }
            default: {
                throw new IOException("could not read CFF float");
            }
        }
        return false;
    }

    private Object readObjectCFF() throws IOException {
        this.readBuffer(1);
        int b0 = this.buffer[0] & 0xFF;
        if (b0 == 30) {
            byte n;
            StringBuffer sb = new StringBuffer();
            do {
                this.readBuffer(1);
            } while (!this.decodeNibbleCFF(sb, (n = this.buffer[0]) >> 4) && !this.decodeNibbleCFF(sb, n));
            return new Double(sb.toString());
        }
        if (b0 <= 21) {
            if (b0 == 12) {
                this.readBuffer(1);
                int b1 = this.buffer[0] & 0xFF;
                return new KeyCFF(b1 | 0x100);
            }
            return new KeyCFF(b0);
        }
        if (32 <= b0 && b0 <= 246) {
            return new Integer(b0 - 139);
        }
        if (247 <= b0 && b0 <= 254) {
            this.readBuffer(1);
            int b1 = this.buffer[0] & 0xFF;
            if (b0 <= 250) {
                return new Integer((b0 - 247) * 256 + b1 + 108);
            }
            return new Integer(-(b0 - 251) * 256 - b1 - 108);
        }
        if (b0 == 28) {
            this.readBuffer(2);
            int b1 = this.buffer[0] & 0xFF;
            int b2 = this.buffer[1] & 0xFF;
            return new Integer((short)(b1 << 8 | b2));
        }
        if (b0 == 29) {
            this.readBuffer(4);
            int b1 = this.buffer[0] & 0xFF;
            int b2 = this.buffer[1] & 0xFF;
            int b3 = this.buffer[2] & 0xFF;
            int b4 = this.buffer[3] & 0xFF;
            return new Integer(b1 << 24 | b2 << 16 | b3 << 8 | b4);
        }
        throw new IOException("error reading CFF object");
    }

    String valToStr(Object val) {
        if (val instanceof Object[]) {
            Object[] arr = (Object[])val;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < arr.length) {
                if (i != 0) {
                    sb.append(' ');
                }
                sb.append(arr[i]);
                ++i;
            }
            return sb.toString();
        }
        return val.toString();
    }

    private Hashtable readDictCFF(int last) throws IOException {
        Hashtable<Object, Object[]> table = new Hashtable<Object, Object[]>();
        Vector<Object> acc = new Vector<Object>();
        while (this.currentOffset < last) {
            Object[] value;
            while (!((value = this.readObjectCFF()) instanceof KeyCFF)) {
                acc.add(value);
            }
            Object[] key = value;
            if (acc.size() == 1) {
                value = acc.elementAt(0);
            } else {
                Object[] vals = new Number[acc.size()];
                acc.copyInto(vals);
                value = vals;
            }
            acc.setSize(0);
            table.put(key, value);
        }
        return table;
    }

    private Object[] readIndexCFF(int kind) throws IOException {
        this.readBuffer(2);
        int count = OpenTypeFont.getShort(this.buffer, 0) & 0xFFFF;
        if (count == 0) {
            return new Object[0];
        }
        this.readBuffer(1);
        byte offSize = this.buffer[0];
        if (offSize > 4 || offSize <= 0) {
            throw new IOException("invalid CFF index offSize");
        }
        int[] offsets = new int[count + 1];
        int i = 0;
        while (i <= count) {
            int off;
            this.readBuffer(offSize);
            switch (offSize) {
                case 1: {
                    off = this.buffer[0] & 0xFF;
                    break;
                }
                case 2: {
                    off = OpenTypeFont.getShort(this.buffer, 0) & 0xFFFF;
                    break;
                }
                case 3: {
                    off = OpenTypeFont.getInt(this.buffer, 0) >> 8 & 0xFFFFFF;
                    break;
                }
                default: {
                    off = OpenTypeFont.getInt(this.buffer, 0);
                }
            }
            offsets[i] = off;
            ++i;
        }
        int offset = this.currentOffset - 1;
        int i2 = 0;
        while (i2 <= count) {
            int n = i2++;
            offsets[n] = offsets[n] + offset;
        }
        Object[] arr = new Object[count];
        this.seek(offsets[0]);
        int i3 = 0;
        while (i3 < count) {
            switch (kind) {
                case 0: {
                    int len = offsets[i3 + 1] - offsets[i3];
                    byte[] b = len > this.buffer.length ? new byte[len] : this.buffer;
                    this.readBuffer(b, len);
                    int strlen = 0;
                    while (strlen < len && b[strlen] != 0) {
                        ++strlen;
                    }
                    arr[i3] = new String(b, 0, strlen, "ISO-8859-1");
                    break;
                }
                case 1: {
                    int last = offsets[i3 + 1];
                    arr[i3] = this.readDictCFF(last);
                    this.seek(last);
                    break;
                }
                case 2: {
                    int len = offsets[i3 + 1] - offsets[i3];
                    byte[] b = new byte[len];
                    this.readBuffer(b, len);
                    arr[i3] = b;
                    break;
                }
                case 3: {
                    int len = offsets[i3 + 1] - offsets[i3];
                    arr[i3] = new Range(offsets[i3], len);
                }
            }
            ++i3;
        }
        this.seek(offsets[count]);
        return arr;
    }

    private void readCharsetFormat2CFF() throws IOException {
        int glyphIndex = 0;
        while (glyphIndex < this.glyphs.length) {
            this.readBuffer(4);
            int sid = OpenTypeFont.getShort(this.buffer, 0);
            int len = OpenTypeFont.getShort(this.buffer, 2);
            int i = 0;
            while (i <= len && glyphIndex < this.glyphs.length) {
                this.glyphs[glyphIndex++].namesidCFF = sid++;
                ++i;
            }
        }
    }

    private void readCFF() throws IOException {
        Object[] privatedict;
        TableDirectoryEntry cff = this.findTable("CFF ");
        this.seek(cff.offset);
        this.readBuffer(4);
        byte offSize = this.buffer[3];
        if (offSize > 4 || offSize <= 0) {
            throw new IOException("invalid CFF index offSize");
        }
        this.seek(cff.offset + (this.buffer[2] & 0xFF));
        Object[] names = this.readIndexCFF(0);
        if (names.length > 1) {
            throw new IOException("CFF data contains multiple fonts");
        }
        this.nameCFF = names[0].toString();
        Object[] dicts = this.readIndexCFF(1);
        if (names.length > 1) {
            throw new IOException("CFF data contains multiple font dicts");
        }
        this.dictCFF = (Hashtable)dicts[0];
        Object[] strings = this.readIndexCFF(0);
        this.stringsCFF = new StringCFF[strings.length];
        int i = 0;
        while (i < this.stringsCFF.length) {
            StringCFF s;
            this.stringsCFF[i] = s = new StringCFF();
            s.value = (String)strings[i];
            ++i;
        }
        this.globalSubrsCFF = this.readIndexCFF(3);
        Integer charstrings = (Integer)this.dictCFF.get(new KeyCFF(17));
        if (charstrings == null) {
            throw new IOException("Invalid CFF data: no charstrings");
        }
        this.seek(cff.offset + charstrings);
        Object[] glyphRanges = this.readIndexCFF(3);
        this.glyphs = new GlyphData[glyphRanges.length];
        int i2 = 0;
        while (i2 < this.glyphs.length) {
            Range range = (Range)glyphRanges[i2];
            GlyphData glyph = new GlyphData();
            glyph.length = range.length;
            glyph.offset = range.offset;
            this.glyphs[i2] = glyph;
            ++i2;
        }
        Integer charset = (Integer)this.dictCFF.get(new KeyCFF(15));
        if (charset != null && charset != 0) {
            this.seek(cff.offset + charset);
            this.readBuffer(1);
            int format = this.buffer[0] & 0xFF;
            switch (format) {
                case 2: {
                    this.readCharsetFormat2CFF();
                }
            }
        }
        if ((privatedict = (Object[])this.dictCFF.get(new KeyCFF(18))) != null) {
            int size = (Integer)privatedict[0];
            int offset = (Integer)privatedict[1];
            this.seek(cff.offset + offset);
            this.privateDictCFF = this.readDictCFF(cff.offset + offset + size);
            this.seek(cff.offset + offset + size);
            this.privateSubrsCFF = this.readIndexCFF(3);
        }
    }

    private void readGlyphData() throws IOException {
        if (this.findTable("glyf") != null) {
            this.trueTypeGlyphs = true;
            this.readGlyphDataTT();
        } else {
            this.readCFF();
        }
    }

    private void readFileHeader() throws IOException {
        FileHeader h = new FileHeader();
        this.readBuffer(12);
        int version = OpenTypeFont.getInt(this.buffer, 0);
        switch (version) {
            case 1953784678: {
                this.readBuffer(4);
                this.seek(OpenTypeFont.getInt(this.buffer, 0));
                this.readBuffer(12);
                version = OpenTypeFont.getInt(this.buffer, 0);
                break;
            }
            case 65536: {
                break;
            }
            case 0x4F54544F: {
                break;
            }
            default: {
                throw new IOException("Invalid OpenType file");
            }
        }
        h.version = version;
        h.numTables = OpenTypeFont.getShort(this.buffer, 4);
        h.searchRange = OpenTypeFont.getShort(this.buffer, 6);
        h.entrySelector = OpenTypeFont.getShort(this.buffer, 8);
        h.rangeShift = OpenTypeFont.getShort(this.buffer, 10);
        h.tableDirectory = new TableDirectoryEntry[h.numTables];
        int i = 0;
        while (i < h.numTables) {
            TableDirectoryEntry entry = new TableDirectoryEntry();
            this.readBuffer(16);
            char[] arr = new char[]{(char)(this.buffer[0] & 0xFF), (char)(this.buffer[1] & 0xFF), (char)(this.buffer[2] & 0xFF), (char)(this.buffer[3] & 0xFF)};
            int len = this.buffer[0] == 0 ? 0 : (this.buffer[1] == 0 ? 1 : (this.buffer[2] == 0 ? 2 : (this.buffer[3] == 0 ? 3 : 4)));
            entry.identifier = new String(arr, 0, len);
            entry.checkSum = OpenTypeFont.getInt(this.buffer, 4);
            entry.offset = OpenTypeFont.getInt(this.buffer, 8);
            entry.length = OpenTypeFont.getInt(this.buffer, 12);
            h.tableDirectory[i] = entry;
            h.tableMap.put(entry.identifier, entry);
            ++i;
        }
        this.header = h;
    }

    private void readCMap() throws IOException {
        EncodingRecord er;
        TableDirectoryEntry cmap = this.findTable("cmap");
        this.seek(cmap.offset);
        this.readBuffer(4);
        if (OpenTypeFont.getShort(this.buffer, 0) != 0) {
            throw new IOException("unknown cmap version");
        }
        int encCount = OpenTypeFont.getShort(this.buffer, 2);
        EncodingRecord[] encs = new EncodingRecord[encCount];
        int i = 0;
        while (i < encCount) {
            encs[i] = er = new EncodingRecord();
            this.readBuffer(8);
            er.platformID = OpenTypeFont.getShort(this.buffer, 0);
            er.encodingID = OpenTypeFont.getShort(this.buffer, 2);
            er.offset = OpenTypeFont.getInt(this.buffer, 4) + cmap.offset;
            ++i;
        }
        i = 0;
        while (i < encCount) {
            er = encs[i];
            this.seek(er.offset);
            this.readBuffer(6);
            er.format = OpenTypeFont.getShort(this.buffer, 0);
            er.length = OpenTypeFont.getShort(this.buffer, 2) & 0xFFFF;
            er.language = OpenTypeFont.getShort(this.buffer, 4);
            if (er.platformID == 3 && er.encodingID == 1 && er.format == 4) {
                this.readFormat4CMap(er);
            }
            ++i;
        }
    }

    private void readFormat4CMap(EncodingRecord er) throws IOException {
        this.readBuffer(8);
        int segCount = (OpenTypeFont.getShort(this.buffer, 0) & 0xFFFF) / 2;
        short[] endCount = this.readShorts(segCount);
        this.readBuffer(2);
        short[] startCount = this.readShorts(segCount);
        short[] idDelta = this.readShorts(segCount);
        short[] idRangeOffset = this.readShorts(segCount);
        int lengthRemains = er.length - 16 - 8 * segCount;
        short[] glyphIds = this.readShorts(lengthRemains);
        int i = 0;
        while (i < segCount) {
            int start = startCount[i] & 0xFFFF;
            int end = endCount[i] & 0xFFFF;
            short rangeOffset = (short)(idRangeOffset[i] / 2);
            short delta = idDelta[i];
            int ch = start;
            while (ch <= end) {
                CharacterData data = new CharacterData();
                if (rangeOffset == 0) {
                    data.glyphIndex = (short)(ch + delta);
                } else {
                    int index = ch - start + rangeOffset - (segCount - i);
                    int glyphIndex = glyphIds[index];
                    if (glyphIndex != 0) {
                        glyphIndex += delta;
                    }
                    data.glyphIndex = (short)glyphIndex;
                }
                this.characters.put(new Integer(ch), data);
                ++ch;
            }
            ++i;
        }
    }

    private static String decodeUnicode(byte[] unicode, int offset, int length) {
        try {
            if (!noUnicodeBigUnmarked) {
                return new String(unicode, offset, length, "UnicodeBigUnmarked");
            }
        }
        catch (UnsupportedEncodingException e) {
            noUnicodeBigUnmarked = true;
        }
        char[] buf = new char[length / 2];
        int i = 0;
        while (i < buf.length) {
            buf[i] = (char)((unicode[2 * i] & 0xFF) << 8 | unicode[2 * i + 1] & 0xFF);
            ++i;
        }
        return new String(buf);
    }

    private static byte[] encodeUnicode(String str) {
        try {
            if (!noUnicodeBigUnmarked) {
                return str.getBytes("UnicodeBigUnmarked");
            }
        }
        catch (UnsupportedEncodingException e) {
            noUnicodeBigUnmarked = true;
        }
        int len = str.length();
        byte[] buf = new byte[len * 2];
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            buf[2 * i] = (byte)(c >> 8);
            buf[2 * i + 1] = (byte)c;
            ++i;
        }
        return buf;
    }

    private void readNames() throws IOException {
        NameEntry entry;
        TableDirectoryEntry table = this.findTable("name");
        this.seek(table.offset);
        this.readBuffer(6);
        if (OpenTypeFont.getShort(this.buffer, 0) != 0) {
            throw new IOException("unknown cmap version");
        }
        int count = OpenTypeFont.getShort(this.buffer, 2) & 0xFFFF;
        int offset = (OpenTypeFont.getShort(this.buffer, 4) & 0xFFFF) + table.offset;
        this.names = new NameEntry[count];
        int i = 0;
        while (i < count) {
            this.names[i] = entry = new NameEntry();
            this.readBuffer(12);
            entry.platformID = OpenTypeFont.getShort(this.buffer, 0);
            entry.encodingID = OpenTypeFont.getShort(this.buffer, 2);
            entry.languageID = OpenTypeFont.getShort(this.buffer, 4);
            entry.nameID = OpenTypeFont.getShort(this.buffer, 6);
            entry.length = OpenTypeFont.getShort(this.buffer, 8);
            entry.offset = (OpenTypeFont.getShort(this.buffer, 10) & 0xFFFF) + offset;
            ++i;
        }
        i = 0;
        while (i < count) {
            entry = this.names[i];
            if ((entry.nameID == 1 || entry.nameID == 16) && this.isEnUnicode(entry)) {
                this.seek(entry.offset);
                this.readBuffer(entry.length);
                this.familyName = OpenTypeFont.decodeUnicode(this.buffer, 0, entry.length);
                if (entry.nameID == 16) break;
            }
            ++i;
        }
    }

    private void readMetrics() throws IOException {
        TableDirectoryEntry hhea = this.findTable("hhea");
        this.seek(hhea.offset + 34);
        this.readBuffer(2);
        this.variableWidthCount = OpenTypeFont.getShort(this.buffer, 0) & 0xFFFF;
        TableDirectoryEntry hmtx = this.findTable("hmtx");
        if (hmtx.length != this.variableWidthCount * 2 + this.glyphs.length * 2) {
            throw new IOException("bad hmtx table length");
        }
        this.seek(hmtx.offset);
        short advance = 0;
        int i = 0;
        while (i < this.variableWidthCount) {
            this.readBuffer(4);
            this.glyphs[i].advance = advance = OpenTypeFont.getShort(this.buffer, 0);
            this.glyphs[i].lsb = OpenTypeFont.getShort(this.buffer, 2);
            ++i;
        }
        i = this.variableWidthCount;
        while (i < this.glyphs.length) {
            this.readBuffer(2);
            this.glyphs[i].advance = advance;
            this.glyphs[i].lsb = OpenTypeFont.getShort(this.buffer, 2);
            ++i;
        }
    }

    public void play(char[] text, int offset, int len) {
        int i = 0;
        while (i < len) {
            int ch = text[i] & 0xFFFF;
            this.play((char)ch);
            ++i;
        }
    }

    public final boolean play(char ch) {
        CharacterData chData = (CharacterData)this.characters.get(new Integer(ch));
        if (chData != null) {
            chData.need = true;
            if (chData.glyphIndex >= 0 && chData.glyphIndex < this.glyphs.length) {
                GlyphData glyph = this.glyphs[chData.glyphIndex];
                glyph.need = true;
                return true;
            }
        }
        return false;
    }

    private void reindexGlyphs() {
        int index = 0;
        int n = 65536;
        int i = 0;
        while (i < this.glyphs.length) {
            if (i < 2) {
                this.glyphs[i].need = true;
            }
            if (this.glyphs[i].need) {
                int sid;
                short s;
                this.glyphs[i].newIndex = index++;
                if (this.glyphs[i].advance != s) {
                    s = this.glyphs[i].advance;
                    this.newVariableWidthCount = index;
                }
                if (this.stringsCFF != null && (sid = this.glyphs[i].namesidCFF) >= CFF_STD_STRING_COUNT) {
                    this.stringsCFF[sid - OpenTypeFont.CFF_STD_STRING_COUNT].needed = true;
                }
            }
            ++i;
        }
        this.newGlyphCount = index;
    }

    private int getCompositeGlyphArgSize(int flags) {
        int argSize = 0;
        argSize = (flags & 1) != 0 ? 4 : 2;
        if ((flags & 8) != 0) {
            argSize += 2;
        } else if ((flags & 0x40) != 0) {
            argSize += 4;
        } else if ((flags & 0x80) != 0) {
            argSize += 8;
        }
        return argSize;
    }

    private void resolveCompositeGlyphsTT() throws IOException {
        int i = 0;
        while (i < this.glyphs.length) {
            if (this.glyphs[i].need) {
                this.seek(this.glyphs[i].offset);
                this.readBuffer(10);
                short numberOfContours = OpenTypeFont.getShort(this.buffer, 0);
                if (numberOfContours < 0) {
                    this.glyphs[i].compositeTT = true;
                    int remains = this.glyphs[i].length - 10;
                    while (remains > 0) {
                        this.readBuffer(4);
                        remains -= 4;
                        short flags = OpenTypeFont.getShort(this.buffer, 0);
                        int glyphIndex = OpenTypeFont.getShort(this.buffer, 2) & 0xFFFF;
                        this.glyphs[glyphIndex].need = true;
                        if ((flags & 0x20) == 0) break;
                        int argSize = this.getCompositeGlyphArgSize(flags);
                        this.readBuffer(argSize);
                        remains -= argSize;
                    }
                }
            }
            ++i;
        }
    }

    private String[] reindexStringsCFF() {
        int i = 0;
        while (i < this.stringsCFF.length) {
            this.stringsCFF[i].needed = true;
            ++i;
        }
        int index = 0;
        int i2 = 0;
        while (i2 < this.stringsCFF.length) {
            if (this.stringsCFF[i2].needed) {
                this.stringsCFF[i2].newIndex = CFF_STD_STRING_COUNT + index++;
            }
            ++i2;
        }
        String[] newArr = new String[index];
        index = 0;
        int i3 = 0;
        while (i3 < this.stringsCFF.length) {
            if (this.stringsCFF[i3].needed) {
                newArr[index++] = this.stringsCFF[i3].value;
            }
            ++i3;
        }
        return newArr;
    }

    private void writeShort(ByteArrayOutputStream out, int n) {
        out.write((byte)(n >> 8));
        out.write((byte)n);
    }

    private void writeInt(ByteArrayOutputStream out, int n) {
        out.write((byte)(n >> 24));
        out.write((byte)(n >> 16));
        out.write((byte)(n >> 8));
        out.write((byte)n);
    }

    private static int floorPowerOf2(int n) {
        int i = 1;
        while (i < 32) {
            int p = 1 << i;
            if (n < p) {
                return i - 1;
            }
            ++i;
        }
        throw new RuntimeException("out of range");
    }

    private byte[] buildCMap() {
        int log;
        BitSet charMask = new BitSet();
        Enumeration chars = this.characters.keys();
        int maxChar = 0;
        while (chars.hasMoreElements()) {
            Integer code = (Integer)chars.nextElement();
            CharacterData data = (CharacterData)this.characters.get(code);
            if (!data.need) continue;
            int ic = code;
            charMask.set(ic);
            if (ic <= maxChar) continue;
            maxChar = ic;
        }
        Vector<EncodingSegment> segments = new Vector<EncodingSegment>();
        EncodingSegment segment = null;
        int ch = 1;
        while (ch <= maxChar) {
            if (charMask.get(ch)) {
                if (segment == null) {
                    segment = new EncodingSegment();
                    segments.add(segment);
                    segment.start = ch;
                }
            } else if (segment != null) {
                segment.end = ch - 1;
                segment = null;
            }
            ++ch;
        }
        if (segment != null) {
            segment.end = maxChar;
        }
        if (maxChar < 65535) {
            segment = new EncodingSegment();
            segments.add(segment);
            segment.start = 65535;
            segment.end = 65535;
        }
        int segCount = segments.size();
        int sectionLength = 16 + 8 * segCount;
        int glyphsBefore = 0;
        int i = 0;
        while (i < segCount) {
            segment = (EncodingSegment)segments.elementAt(i);
            int segLen = segment.end - segment.start + 1;
            short[] glyphIds = new short[segLen];
            segment.glyphIds = glyphIds;
            int delta = 0;
            int k = 0;
            while (k < segLen) {
                short glyphIndex;
                int ch2 = k + segment.start;
                CharacterData data = (CharacterData)this.characters.get(new Integer(ch2));
                short s = glyphIndex = data == null ? (short)0 : data.glyphIndex;
                if (glyphIndex != 0) {
                    GlyphData glyph = this.glyphs[glyphIndex];
                    glyphIndex = (short)glyph.newIndex;
                }
                int d = glyphIndex - ch2;
                if (k == 0) {
                    delta = d;
                    segment.constDelta = true;
                } else if (delta != d) {
                    segment.constDelta = false;
                }
                glyphIds[k] = glyphIndex;
                ++k;
            }
            if (!segment.constDelta) {
                segment.glyphsBefore = glyphsBefore;
                sectionLength += 2 * segment.glyphIds.length;
                glyphsBefore += segment.glyphIds.length;
            }
            ++i;
        }
        if (sectionLength > 65535) {
            throw new RuntimeException("cmap too long");
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.writeShort(result, 0);
        this.writeShort(result, 2);
        this.writeShort(result, 0);
        this.writeShort(result, 3);
        this.writeInt(result, 20);
        this.writeShort(result, 3);
        this.writeShort(result, 1);
        this.writeInt(result, 20);
        this.writeShort(result, 4);
        this.writeShort(result, (short)sectionLength);
        this.writeShort(result, 0);
        this.writeShort(result, (short)(segCount * 2));
        int entrySelector = log = OpenTypeFont.floorPowerOf2(segCount & 0xFFFF);
        int searchRange = 1 << log + 1;
        int rangeShift = segCount * 2 - searchRange;
        this.writeShort(result, (short)searchRange);
        this.writeShort(result, (short)entrySelector);
        this.writeShort(result, (short)rangeShift);
        int i2 = 0;
        while (i2 < segCount) {
            segment = (EncodingSegment)segments.elementAt(i2);
            this.writeShort(result, segment.end);
            ++i2;
        }
        this.writeShort(result, 0);
        i2 = 0;
        while (i2 < segCount) {
            segment = (EncodingSegment)segments.elementAt(i2);
            this.writeShort(result, segment.start);
            ++i2;
        }
        i2 = 0;
        while (i2 < segCount) {
            segment = (EncodingSegment)segments.elementAt(i2);
            if (segment.constDelta) {
                this.writeShort(result, (short)(segment.glyphIds[0] - segment.start));
            } else {
                this.writeShort(result, 0);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < segCount) {
            segment = (EncodingSegment)segments.elementAt(i2);
            if (segment.constDelta) {
                this.writeShort(result, 0);
            } else {
                int rangeOffset = 2 * (segCount - i2 + segment.glyphsBefore);
                this.writeShort(result, (short)rangeOffset);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < segCount) {
            segment = (EncodingSegment)segments.elementAt(i2);
            if (!segment.constDelta) {
                int k = 0;
                while (k < segment.glyphIds.length) {
                    this.writeShort(result, segment.glyphIds[k]);
                    ++k;
                }
            }
            ++i2;
        }
        byte[] arr = result.toByteArray();
        if (arr.length != sectionLength + 20) {
            throw new RuntimeException("inconsistent cmap");
        }
        return arr;
    }

    private boolean isEnUnicode(NameEntry en) {
        if (en.platformID == 0) {
            return true;
        }
        if (en.platformID == 0 && en.encodingID == 3) {
            return true;
        }
        return en.platformID == 3 && (en.encodingID == 1 || en.encodingID == 10) && (en.languageID & 0x3FF) == 9;
    }

    private String getFontID() {
        if (this.fontID == null) {
            this.fontID = "Subset:" + Long.toHexString(System.currentTimeMillis());
        }
        return this.fontID;
    }

    private byte[] buildNames() throws IOException {
        int offset = 0;
        int count = 0;
        int i = 0;
        while (i < this.names.length) {
            NameEntry entry = this.names[i];
            switch (entry.nameID) {
                case 0: {
                    entry.needed = true;
                    break;
                }
                case 1: 
                case 4: 
                case 16: 
                case 17: {
                    entry.needed = true;
                    this.seek(entry.offset);
                    this.readBuffer(entry.length);
                    if (this.isEnUnicode(entry)) {
                        String name = OpenTypeFont.decodeUnicode(this.buffer, 0, entry.length);
                        name = "Subset-" + name;
                        entry.newContent = OpenTypeFont.encodeUnicode(name);
                        break;
                    }
                    String name = new String(this.buffer, 0, entry.length, "ISO8859_1");
                    name = "Subset-" + name;
                    entry.newContent = name.getBytes("ISO8859_1");
                    break;
                }
                case 2: {
                    entry.needed = true;
                    break;
                }
                case 7: {
                    entry.needed = true;
                    break;
                }
                case 8: {
                    entry.needed = true;
                    break;
                }
                case 3: {
                    entry.needed = true;
                    entry.newContent = this.isEnUnicode(entry) ? OpenTypeFont.encodeUnicode(this.getFontID()) : this.getFontID().getBytes("ISO8859_1");
                }
            }
            if (entry.needed) {
                entry.newRelativeOffset = offset;
                int len = entry.newContent != null ? entry.newContent.length : entry.length;
                offset += len;
                ++count;
            }
            ++i;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeShort(out, 0);
        this.writeShort(out, (short)count);
        this.writeShort(out, (short)(count * 12 + 6));
        int i2 = 0;
        while (i2 < this.names.length) {
            NameEntry entry = this.names[i2];
            if (entry.needed) {
                this.writeShort(out, entry.platformID);
                this.writeShort(out, entry.encodingID);
                this.writeShort(out, entry.languageID);
                this.writeShort(out, entry.nameID);
                int len = entry.newContent != null ? entry.newContent.length : entry.length;
                this.writeShort(out, (short)len);
                this.writeShort(out, (short)entry.newRelativeOffset);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.names.length) {
            NameEntry entry = this.names[i2];
            if (entry.needed) {
                if (entry.newContent != null) {
                    out.write(entry.newContent);
                } else {
                    this.copyBytes(out, entry.offset, entry.length);
                }
            }
            ++i2;
        }
        return out.toByteArray();
    }

    private byte[] buildGlyphsTT() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < this.glyphs.length) {
            GlyphData glyph = this.glyphs[i];
            if (glyph.need) {
                if (glyph.compositeTT) {
                    byte[] arr = glyph.length > this.buffer.length ? new byte[glyph.length] : this.buffer;
                    this.seek(glyph.offset);
                    this.readBuffer(arr, glyph.length);
                    int index = 10;
                    while (index <= glyph.length - 4) {
                        short flags = OpenTypeFont.getShort(arr, index);
                        int glyphID = OpenTypeFont.getShort(arr, index + 2) & 0xFFFF;
                        this.stuffShort(arr, index + 2, (short)this.glyphs[glyphID].newIndex);
                        if ((flags & 0x20) == 0) break;
                        index += 4 + this.getCompositeGlyphArgSize(flags);
                    }
                    out.write(arr, 0, glyph.length);
                } else {
                    this.copyBytes(out, glyph.offset, glyph.length);
                }
                int padCount = 4 - glyph.length & 3;
                while (padCount > 0) {
                    --padCount;
                    out.write(0);
                }
            }
            ++i;
        }
        return out.toByteArray();
    }

    private byte[] buildGlyphLocations(boolean asShorts) throws IOException {
        int offset = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (asShorts) {
            this.writeShort(out, 0);
        } else {
            this.writeInt(out, 0);
        }
        int i = 0;
        while (i < this.glyphs.length) {
            GlyphData glyph = this.glyphs[i];
            if (glyph.need) {
                int paddedLength = glyph.length + 3 & 0xFFFFFFFC;
                offset += paddedLength;
                if (asShorts) {
                    this.writeShort(out, offset / 2);
                } else {
                    this.writeInt(out, offset);
                }
            }
            ++i;
        }
        return out.toByteArray();
    }

    private void stuffLong(byte[] arr, int index, long n) {
        arr[index] = (byte)(n >> 56);
        arr[index + 1] = (byte)(n >> 48);
        arr[index + 2] = (byte)(n >> 40);
        arr[index + 3] = (byte)(n >> 32);
        arr[index + 4] = (byte)(n >> 24);
        arr[index + 5] = (byte)(n >> 16);
        arr[index + 6] = (byte)(n >> 8);
        arr[index + 7] = (byte)n;
    }

    private void stuffShort(byte[] arr, int index, short n) {
        arr[index] = (byte)(n >> 8);
        arr[index + 1] = (byte)n;
    }

    private byte[] buildHead(TableDirectoryEntry head, boolean shortOffsets) throws IOException {
        byte[] buf = new byte[head.length];
        this.seek(head.offset);
        this.readBuffer(buf, head.length);
        buf[8] = 0;
        buf[9] = 0;
        buf[10] = 0;
        buf[11] = 0;
        this.stuffLong(buf, 28, new Date().getTime() / 1000L + 2082758400L);
        buf[50] = 0;
        buf[51] = (byte)(!shortOffsets ? 1 : 0);
        return buf;
    }

    private byte[] buildHHea(TableDirectoryEntry hhea) throws IOException {
        byte[] buf = new byte[hhea.length];
        this.seek(hhea.offset);
        this.readBuffer(buf, hhea.length);
        buf[34] = (byte)(this.newVariableWidthCount >> 8);
        buf[35] = (byte)this.newVariableWidthCount;
        return buf;
    }

    private byte[] buildHMtx() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < this.glyphs.length) {
            GlyphData glyph = this.glyphs[i];
            if (glyph.need) {
                if (glyph.newIndex < this.newVariableWidthCount) {
                    this.writeShort(out, glyph.advance);
                }
                this.writeShort(out, glyph.lsb);
            }
            ++i;
        }
        return out.toByteArray();
    }

    private byte[] buildMaxP(TableDirectoryEntry maxp) throws IOException {
        byte[] buf = new byte[maxp.length];
        this.seek(maxp.offset);
        this.readBuffer(buf, maxp.length);
        buf[4] = (byte)(this.newGlyphCount >> 8);
        buf[5] = (byte)this.newGlyphCount;
        return buf;
    }

    private void writeOffsetCFF(ByteArrayOutputStream out, int offSize, int offset) throws IOException {
        switch (offSize) {
            case 1: {
                out.write(offset);
                break;
            }
            case 2: {
                this.writeShort(out, offset);
                break;
            }
            case 3: {
                out.write(offset >> 16);
                this.writeShort(out, offset);
                break;
            }
            case 4: {
                this.writeInt(out, offset);
            }
        }
    }

    private void writeIntCFF(ByteArrayOutputStream out, int val) {
        if (-107 <= val && val <= 107) {
            out.write(val + 139);
        } else if (108 <= val && val <= 1131) {
            out.write(((val -= 108) >> 8) + 247);
            out.write(val);
        } else if (-1131 <= val && val <= -108) {
            val = -val - 108;
            out.write((val >> 8) + 251);
            out.write(val);
        } else if (Short.MIN_VALUE <= val && val <= Short.MAX_VALUE) {
            out.write(28);
            this.writeShort(out, val);
        } else {
            out.write(29);
            this.writeInt(out, val);
        }
    }

    private void writeObjectCFF(ByteArrayOutputStream out, Object obj) throws IOException {
        block30: {
            if (obj instanceof KeyCFF) {
                int key = ((KeyCFF)obj).keyID;
                if (key < 255) {
                    out.write(key);
                } else {
                    out.write(12);
                    out.write(key);
                }
            } else if (obj instanceof Integer) {
                int val = (Integer)obj;
                this.writeIntCFF(out, val);
            } else if (obj instanceof StringCFF) {
                int val = ((StringCFF)obj).newIndex;
                this.writeIntCFF(out, val);
            } else {
                if (obj instanceof Double) {
                    String s = obj.toString();
                    out.write(30);
                    int b = 0;
                    int i = 0;
                    int len = s.length();
                    boolean first = true;
                    while (true) {
                        int n;
                        if (i >= len) {
                            n = 15;
                        } else {
                            char c = s.charAt(i);
                            if ('0' <= c && c <= '9') {
                                n = c - 48;
                            } else if (c == '-') {
                                n = 14;
                            } else if (c == '.') {
                                n = 10;
                            } else if (c == 'E' || c == 'e') {
                                c = s.charAt(i + 1);
                                if (c == '-') {
                                    ++i;
                                    n = 11;
                                } else {
                                    n = 12;
                                }
                            } else {
                                throw new IOException("Bad number: " + s);
                            }
                        }
                        if (first) {
                            b = n;
                        } else {
                            b = b << 4 | n;
                            out.write(b);
                            if (i >= len) break block30;
                        }
                        first = !first;
                        ++i;
                    }
                }
                if (obj instanceof IntPlaceholderCFF) {
                    out.write(29);
                    ((IntPlaceholderCFF)obj).offset = out.size();
                    this.writeInt(out, 0);
                } else if (obj instanceof Object[]) {
                    Object[] arr = (Object[])obj;
                    int i = 0;
                    while (i < arr.length) {
                        this.writeObjectCFF(out, arr[i]);
                        ++i;
                    }
                } else {
                    throw new IOException("unknown object");
                }
            }
        }
    }

    private void writeDictCFF(ByteArrayOutputStream out, Hashtable dict) throws IOException {
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val = dict.get(key);
            this.writeObjectCFF(out, val);
            this.writeObjectCFF(out, key);
        }
    }

    private void adjustOffsetObjectCFF(Object obj, int offsetAdj) {
        if (obj instanceof IntPlaceholderCFF) {
            ((IntPlaceholderCFF)obj).offset += offsetAdj;
        } else if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            int i = 0;
            while (i < arr.length) {
                this.adjustOffsetObjectCFF(arr[i], offsetAdj);
                ++i;
            }
        }
    }

    private void adjustOffsetDictCFF(Hashtable dict, int offsetAdj) {
        Enumeration elements = dict.elements();
        while (elements.hasMoreElements()) {
            Object val = elements.nextElement();
            this.adjustOffsetObjectCFF(val, offsetAdj);
        }
    }

    private void writeIndexCFF(ByteArrayOutputStream out, Object[] index) throws IOException {
        this.writeShort(out, index.length);
        if (index.length == 0) {
            return;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        int[] offsets = new int[index.length + 1];
        offsets[0] = 1;
        boolean adjustOffsets = false;
        int i = 0;
        while (i < index.length) {
            Object r;
            Object item = index[i];
            if (item instanceof String) {
                byte[] sb = ((String)item).getBytes("ISO-8859-1");
                data.write(sb);
            } else if (item instanceof Hashtable) {
                this.writeDictCFF(data, (Hashtable)item);
                adjustOffsets = true;
            } else if (item instanceof Range) {
                r = (Range)item;
                this.copyBytes(data, ((Range)r).offset, ((Range)r).length);
            } else if (item instanceof GlyphData) {
                r = (GlyphData)item;
                this.copyBytes(data, ((GlyphData)r).offset, ((GlyphData)r).length);
            } else {
                throw new IOException("unknown index type");
            }
            offsets[i + 1] = data.size() + 1;
            ++i;
        }
        int offset = offsets[index.length];
        int offSize = offset <= 255 ? 1 : (offset <= 65535 ? 2 : (offset <= 0xFFFFFF ? 3 : 4));
        out.write(offSize);
        int i2 = 0;
        while (i2 <= index.length) {
            this.writeOffsetCFF(out, offSize, offsets[i2]);
            ++i2;
        }
        if (adjustOffsets) {
            int offsetAdj = out.size();
            int i3 = 0;
            while (i3 < index.length) {
                Object item = index[i3];
                if (item instanceof Hashtable) {
                    this.adjustOffsetDictCFF((Hashtable)item, offsetAdj);
                }
                ++i3;
            }
        }
        data.writeTo(out);
    }

    private void writeCharsetCFF(ByteArrayOutputStream out) {
        int i = 0;
        int count = 0;
        int prevsid = -1;
        out.write(2);
        do {
            GlyphData glyph = this.glyphs[i++];
            if (!glyph.need) continue;
            int sid = glyph.namesidCFF;
            if (sid >= CFF_STD_STRING_COUNT) {
                sid = this.stringsCFF[sid - OpenTypeFont.CFF_STD_STRING_COUNT].newIndex;
            }
            if (prevsid == -1) {
                this.writeShort(out, sid);
                count = 0;
            } else if (prevsid != sid - 1) {
                this.writeShort(out, count);
                this.writeShort(out, sid);
                count = 0;
            } else {
                ++count;
            }
            prevsid = sid;
        } while (i < this.glyphs.length);
        this.writeShort(out, count);
    }

    private Object[] makeGlyphArrayCFF() {
        Object[] subset = new Object[this.newGlyphCount];
        int index = 0;
        int i = 0;
        while (i < this.glyphs.length) {
            if (this.glyphs[i].need) {
                subset[index++] = this.glyphs[i];
            }
            ++i;
        }
        return subset;
    }

    private void sweepDictCFF(Hashtable dict) throws IOException {
        int i = 0;
        while (i < sidIndicesCFF.length) {
            KeyCFF key = new KeyCFF(sidIndicesCFF[i]);
            Object val = dict.get(key);
            if (val != null) {
                if (val instanceof Integer) {
                    int sid = (Integer)val;
                    if (sid >= CFF_STD_STRING_COUNT) {
                        StringCFF string = this.stringsCFF[sid - CFF_STD_STRING_COUNT];
                        string.needed = true;
                        dict.put(key, string);
                    }
                } else {
                    throw new IOException("unsupported value for SID key");
                }
            }
            ++i;
        }
    }

    private byte[] buildCFF() throws IOException {
        Hashtable dict = (Hashtable)this.dictCFF.clone();
        this.sweepDictCFF(dict);
        Object[] newStrings = this.reindexStringsCFF();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(1);
        out.write(0);
        out.write(4);
        out.write(3);
        Object[] names = new String[]{"Subset-" + this.nameCFF};
        this.writeIndexCFF(out, names);
        Object[] origprivatedict = (Object[])dict.get(new KeyCFF(18));
        int origPrivateDictLen = ((Number)origprivatedict[0]).intValue();
        IntPlaceholderCFF charset = new IntPlaceholderCFF();
        IntPlaceholderCFF charstrings = new IntPlaceholderCFF();
        IntPlaceholderCFF privatedict = new IntPlaceholderCFF();
        Object[] pd = (Object[])dict.get(new KeyCFF(18));
        Object[] privateval = new Object[]{pd[0], privatedict};
        dict.put(new KeyCFF(15), charset);
        dict.put(new KeyCFF(17), charstrings);
        dict.put(new KeyCFF(18), privateval);
        dict.remove(new KeyCFF(16));
        Object[] dicts = new Hashtable[]{dict};
        this.writeIndexCFF(out, dicts);
        this.writeIndexCFF(out, newStrings);
        this.writeIndexCFF(out, this.globalSubrsCFF);
        int charsetOffset = out.size();
        this.writeCharsetCFF(out);
        int charstringsOffset = out.size();
        this.writeIndexCFF(out, this.makeGlyphArrayCFF());
        int privatedictOffset = out.size();
        this.writeDictCFF(out, this.privateDictCFF);
        int privatesubrOffset = out.size();
        if (privatesubrOffset - privatedictOffset != origPrivateDictLen) {
            throw new IOException("private dict writing error");
        }
        this.writeIndexCFF(out, this.privateSubrsCFF);
        byte[] result = out.toByteArray();
        this.setIntAtIndex(result, charset.offset, charsetOffset);
        this.setIntAtIndex(result, charstrings.offset, charstringsOffset);
        this.setIntAtIndex(result, privatedict.offset, privatedictOffset);
        return result;
    }

    private void sweepTables() throws IOException {
        byte[] cffSection;
        byte[] glyfSection;
        if (this.trueTypeGlyphs) {
            glyfSection = this.buildGlyphsTT();
            cffSection = null;
        } else {
            glyfSection = null;
            cffSection = this.buildCFF();
        }
        int offset = 0;
        int i = 0;
        while (i < this.header.numTables) {
            TableDirectoryEntry entry = this.header.tableDirectory[i];
            if (entry.identifier.equals("cmap")) {
                entry.newContent = this.buildCMap();
                entry.need = true;
            } else if (entry.identifier.equals("head")) {
                entry.need = true;
                entry.newContent = this.buildHead(entry, glyfSection != null && glyfSection.length <= 131071);
            } else if (entry.identifier.equals("hhea")) {
                entry.need = true;
                entry.newContent = this.buildHHea(entry);
            } else if (entry.identifier.equals("hmtx")) {
                entry.need = true;
                entry.newContent = this.buildHMtx();
            } else if (entry.identifier.equals("maxp")) {
                entry.need = true;
                entry.newContent = this.buildMaxP(entry);
            } else if (entry.identifier.equals("name")) {
                entry.need = true;
                entry.newContent = this.buildNames();
            } else if (entry.identifier.equals("OS/2")) {
                entry.need = true;
            } else if (entry.identifier.equals("post")) {
                entry.need = true;
            } else if (entry.identifier.equals("cvt ")) {
                entry.need = true;
            } else if (entry.identifier.equals("fpgm")) {
                entry.need = true;
            } else if (entry.identifier.equals("glyf")) {
                entry.need = true;
                entry.newContent = glyfSection;
            } else if (entry.identifier.equals("loca")) {
                entry.need = true;
                entry.newContent = this.buildGlyphLocations(glyfSection.length <= 131071);
            } else if (entry.identifier.equals("CFF ")) {
                entry.need = true;
                entry.newContent = cffSection;
            } else if (entry.identifier.equals("prep")) {
                entry.need = true;
            } else if (entry.identifier.equals("fpgm")) {
                entry.need = true;
            } else if (entry.identifier.equals("gasp")) {
                entry.need = true;
            }
            if (entry.need) {
                entry.newRelativeOffset = offset;
                int len = entry.newContent != null ? entry.newContent.length : entry.length;
                offset += len + 3 & 0xFFFFFFFC;
            }
            ++i;
        }
    }

    private int calculateTableCheckSum(byte[] content) {
        int result = 0;
        int wordCount = content.length / 4;
        int i = 0;
        while (i < wordCount) {
            result += OpenTypeFont.getInt(content, i * 4);
            ++i;
        }
        int offset = 24;
        int i2 = wordCount * 4;
        while (i2 < content.length) {
            result += (content[i2] & 0xFF) << offset;
            offset -= 8;
            ++i2;
        }
        return result;
    }

    private void copyBytes(OutputStream out, int offset, int len) throws IOException {
        this.seek(offset);
        while (len > 0) {
            int r = len;
            if (r > this.buffer.length) {
                r = this.buffer.length;
            }
            this.readBuffer(r);
            out.write(this.buffer, 0, r);
            len -= r;
        }
    }

    private void setIntAtIndex(byte[] arr, int index, int value) {
        arr[index++] = (byte)(value >> 24);
        arr[index++] = (byte)(value >> 16);
        arr[index++] = (byte)(value >> 8);
        arr[index++] = (byte)value;
    }

    private byte[] writeTables() throws IOException {
        TableDirectoryEntry entry;
        int log;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int numTables = 0;
        int i = 0;
        while (i < this.header.numTables) {
            TableDirectoryEntry entry2 = this.header.tableDirectory[i];
            if (entry2.need) {
                ++numTables;
            }
            ++i;
        }
        if (this.trueTypeGlyphs) {
            this.writeInt(out, 65536);
        } else {
            out.write(79);
            out.write(84);
            out.write(84);
            out.write(79);
        }
        this.writeShort(out, (short)numTables);
        int entrySelector = log = OpenTypeFont.floorPowerOf2(numTables);
        int searchRange = 1 << log + 4;
        int rangeShift = numTables * 16 - searchRange;
        this.writeShort(out, (short)searchRange);
        this.writeShort(out, (short)entrySelector);
        this.writeShort(out, (short)rangeShift);
        int baseOffset = numTables * 16 + 12;
        int i2 = 0;
        while (i2 < this.header.numTables) {
            entry = this.header.tableDirectory[i2];
            if (entry.need) {
                byte[] tag = entry.identifier.getBytes();
                out.write(tag);
                int k = tag.length;
                while (k < 4) {
                    out.write(0);
                    ++k;
                }
                if (entry.newContent == null) {
                    this.writeInt(out, entry.checkSum);
                    this.writeInt(out, entry.newRelativeOffset + baseOffset);
                    this.writeInt(out, entry.length);
                } else {
                    int checkSum = this.calculateTableCheckSum(entry.newContent);
                    this.writeInt(out, checkSum);
                    this.writeInt(out, entry.newRelativeOffset + baseOffset);
                    this.writeInt(out, entry.newContent.length);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.header.numTables) {
            entry = this.header.tableDirectory[i2];
            if (entry.need) {
                if (entry.newContent != null) {
                    out.write(entry.newContent);
                    int len = entry.newContent.length;
                    int padCount = 4 - len & 3;
                    while (padCount > 0) {
                        out.write(0);
                        --padCount;
                    }
                } else {
                    this.copyBytes(out, entry.offset, entry.length + 3 & 0xFFFFFFFC);
                }
            }
            ++i2;
        }
        TableDirectoryEntry head = this.findTable("head");
        byte[] result = out.toByteArray();
        int checkSum = this.calculateTableCheckSum(result);
        int checkSumAdjustment = -1313820742 - checkSum;
        int index = head.newRelativeOffset + baseOffset + 8;
        this.setIntAtIndex(result, index, checkSumAdjustment);
        return result;
    }

    private void readOS2() throws IOException {
        TableDirectoryEntry os2 = this.findTable("OS/2");
        if (os2 == null) {
            throw new IOException("No OS/2 table found");
        }
        this.seek(os2.offset);
        this.readBuffer(10);
        this.weight = OpenTypeFont.getShort(this.buffer, 4);
        this.width = OpenTypeFont.getShort(this.buffer, 6);
        this.fsType = OpenTypeFont.getShort(this.buffer, 8);
        this.seek(os2.offset + 62);
        this.readBuffer(2);
        short fsSelection = OpenTypeFont.getShort(this.buffer, 0);
        if ((fsSelection & 1) != 0) {
            this.style = 1;
        }
    }

    public boolean canSubset() throws IOException {
        if ((this.fsType & 0xF) == 2) {
            return false;
        }
        return (this.fsType & 0x100) == 0;
    }

    public boolean canEmbedForReading() throws IOException {
        if ((this.fsType & 0xF) == 2) {
            return false;
        }
        return (this.fsType & 0x200) == 0;
    }

    public boolean canEmbedForEditing() throws IOException {
        switch (this.fsType & 0xF) {
            case 2: 
            case 4: {
                return false;
            }
        }
        return (this.fsType & 0x200) == 0;
    }

    public byte[] getSubsettedFont() throws IOException {
        if (!this.canSubset()) {
            throw new IOException("subsetting not allowed for this font");
        }
        if (this.trueTypeGlyphs) {
            this.resolveCompositeGlyphsTT();
        }
        this.reindexGlyphs();
        this.sweepTables();
        return this.writeTables();
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getStyle() {
        return this.style;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getWidth() {
        return this.width;
    }

    public static void main(String[] args) {
        try {
            FileFontInputStream font = new FileFontInputStream(new File(args[0]));
            OpenTypeFont s = new OpenTypeFont(font);
            char[] text = "Hello".toCharArray();
            s.play(text, 0, text.length);
            byte[] result = s.getSubsettedFont();
            FileOutputStream out = new FileOutputStream(new File(args[1]));
            ((OutputStream)out).write(result);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class CharacterData {
        short glyphIndex;
        boolean need;

        CharacterData() {
        }
    }

    static class EncodingRecord {
        short platformID;
        short encodingID;
        int offset;
        short format;
        int length;
        short language;

        EncodingRecord() {
        }
    }

    static class EncodingSegment {
        int start;
        int end;
        short[] glyphIds;
        boolean constDelta;
        int glyphsBefore;

        EncodingSegment() {
        }
    }

    static class FileHeader {
        int version;
        short numTables;
        short searchRange;
        short entrySelector;
        short rangeShift;
        TableDirectoryEntry[] tableDirectory;
        Hashtable tableMap = new Hashtable();

        FileHeader() {
        }
    }

    static class GlyphData {
        boolean need;
        boolean compositeTT;
        int offset;
        int length;
        short advance;
        short lsb;
        int newIndex;
        int namesidCFF;

        GlyphData() {
        }
    }

    static class IntPlaceholderCFF {
        int offset;

        IntPlaceholderCFF() {
        }
    }

    static class KeyCFF {
        static final int ENCODING = 16;
        static final int CHARSET = 15;
        static final int CHARSTRINGS = 17;
        static final int PRIVATE = 18;
        int keyID;

        KeyCFF(int keyID) {
            this.keyID = keyID;
        }

        public int hashCode() {
            return this.keyID;
        }

        public boolean equals(Object o) {
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return this.keyID == ((KeyCFF)o).keyID;
        }
    }

    static class NameEntry {
        short platformID;
        short encodingID;
        short languageID;
        short nameID;
        int offset;
        int length;
        boolean needed;
        byte[] newContent;
        int newRelativeOffset;

        NameEntry() {
        }
    }

    static class Range {
        int offset;
        int length;

        Range(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }

    static class StringCFF {
        String value;
        int newIndex;
        boolean needed;

        StringCFF() {
        }
    }

    static class TableDirectoryEntry {
        String identifier;
        int checkSum;
        int offset;
        int length;
        boolean need;
        byte[] newContent;
        int newRelativeOffset;

        TableDirectoryEntry() {
        }
    }
}

