/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.word;

import com.adobe.dp.office.word.NumberingDefinitionInstance;
import com.adobe.dp.office.word.NumberingLabel;
import com.adobe.dp.office.word.NumberingLevelDefinition;
import com.adobe.dp.xml.util.StringUtil;
import java.util.Iterator;

public class NumberingLabelIterator
implements Iterator {
    NumberingDefinitionInstance instance;
    NumberingLevelDefinition level;
    int count;
    boolean first;

    NumberingLabelIterator(NumberingDefinitionInstance instance, NumberingLevelDefinition level) {
        this.instance = instance;
        this.level = level;
        this.reset();
    }

    void reset() {
        this.first = true;
        this.count = this.level.start;
    }

    public boolean hasNext() {
        return true;
    }

    public String latin(int n) {
        StringBuffer r = new StringBuffer();
        char c = (char)(97 + --n % 26);
        int cc = n / 26 + 1;
        int i = 0;
        while (i < cc) {
            r.append(c);
            ++i;
        }
        return r.toString();
    }

    String getNumberStr() {
        String fmt = this.level.numFmt;
        if (fmt.equals("decimal")) {
            return Integer.toString(this.count);
        }
        if (fmt.equals("upperLetter")) {
            return this.latin(this.count).toUpperCase();
        }
        if (fmt.equals("lowerLetter")) {
            return this.latin(this.count);
        }
        if (fmt.equals("upperRoman")) {
            return StringUtil.printRoman(this.count).toUpperCase();
        }
        if (fmt.equals("lowerRoman")) {
            return StringUtil.printRoman(this.count);
        }
        return "";
    }

    public Object next() {
        if (this.first) {
            this.first = false;
        } else {
            ++this.count;
        }
        String txt = this.instance.formatText(this.level.lvlText, this.level.lvl);
        this.instance.resetLevels(this.level.lvl);
        return new NumberingLabel(this.instance, this.level, txt);
    }

    public void remove() {
        throw new RuntimeException("not supported");
    }
}

