/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.word;

import com.adobe.dp.office.word.AbstractNumberingDefinition;
import com.adobe.dp.office.word.NumberingLabelIterator;
import com.adobe.dp.office.word.NumberingLevelDefinition;
import com.adobe.dp.office.word.WordDocument;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class NumberingDefinitionInstance {
    private AbstractNumberingDefinition abstractNumbering;
    Hashtable startOverrides = new Hashtable();
    int numId;
    boolean instantiated;
    Hashtable numberingLevelDefinitions = new Hashtable();
    WordDocument doc;

    NumberingDefinitionInstance(WordDocument doc, int numId) {
        this.doc = doc;
        this.numId = numId;
    }

    static void fillDefsFrom(Hashtable to, Hashtable from) {
        Enumeration keys = from.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            if (to.get(key) != null) continue;
            NumberingLevelDefinition levelDef = (NumberingLevelDefinition)from.get(key);
            to.put(key, levelDef.cloneLevel());
        }
    }

    Hashtable getNumberingLevelDefinitions() {
        if (!this.instantiated) {
            this.instantiated = true;
            Hashtable defs = this.abstractNumbering.getNumberingLevelDefinitions(this.doc);
            NumberingDefinitionInstance.fillDefsFrom(this.numberingLevelDefinitions, defs);
        }
        return this.numberingLevelDefinitions;
    }

    public Iterator iteratorForLevel(int lvl) {
        Integer key = new Integer(lvl);
        Hashtable defs = this.getNumberingLevelDefinitions();
        NumberingLevelDefinition levelDef = (NumberingLevelDefinition)defs.get(key);
        if (levelDef == null) {
            return null;
        }
        if (levelDef.iterator == null) {
            levelDef.iterator = new NumberingLabelIterator(this, levelDef);
        }
        return levelDef.iterator;
    }

    void resetLevels(int lvl) {
        Enumeration keys = this.numberingLevelDefinitions.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            NumberingLevelDefinition def = (NumberingLevelDefinition)this.numberingLevelDefinitions.get(key);
            if (def == null) continue;
            if (key <= lvl) {
                if (def.iterator == null) {
                    def.iterator = new NumberingLabelIterator(this, def);
                }
                def.iterator.first = false;
                continue;
            }
            if (def.lvlRestart != lvl || def.iterator == null) continue;
            def.iterator.reset();
        }
    }

    String formatText(String text, int maxLevel) {
        int index = text.indexOf(37);
        if (index < 0) {
            return text;
        }
        StringBuffer res = new StringBuffer();
        int prevIndex = 0;
        while (true) {
            res.append(text.substring(prevIndex, index));
            if (++index >= text.length()) break;
            char c = text.charAt(index);
            if ('1' <= c && c <= '9') {
                NumberingLabelIterator it;
                int level = c - 49;
                if (level <= maxLevel && (it = (NumberingLabelIterator)this.iteratorForLevel(level)) != null) {
                    res.append(it.getNumberStr());
                }
            } else {
                res.append(c);
            }
            prevIndex = index + 1;
            if ((index = text.indexOf(37, index)) >= 0) continue;
            index = text.length();
        }
        return res.toString();
    }

    void setAbstractNumbering(AbstractNumberingDefinition abstractNumbering) {
        if (abstractNumbering != null) {
            this.abstractNumbering = abstractNumbering;
            abstractNumbering.instances.add(this);
        }
    }
}

