/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.vml;

import com.adobe.dp.office.vml.VMLCallout;
import com.adobe.dp.office.vml.VMLCoordPair;
import com.adobe.dp.office.vml.VMLEnv;
import com.adobe.dp.office.vml.VMLFElement;
import com.adobe.dp.office.vml.VMLFormulasElement;
import com.adobe.dp.office.vml.VMLPathSegment;
import com.adobe.dp.office.vml.VMLShapeElement;
import com.adobe.dp.office.vml.VMLShapeTypeElement;
import com.adobe.dp.office.word.Element;
import java.util.Iterator;
import java.util.Vector;

public class VMLPathConverter
implements VMLEnv {
    float xscale;
    float yscale;
    int[] adj;
    VMLCoordPair origin;
    VMLCoordPair size;
    VMLCoordPair limo;
    VMLShapeElement shape;
    VMLShapeTypeElement shapeType;
    Vector callouts = new Vector();
    float outerWidth = 100.0f;
    float outerHeight = 100.0f;
    float pathScaleX = 1.0f;
    float pathScaleY = 1.0f;
    float pathScale = 1.0f;

    public VMLPathConverter(VMLShapeElement shape) {
        this.shape = shape;
        this.shapeType = shape.type;
        if (this.shapeType == null) {
            return;
        }
        this.adj = shape.adj == null ? this.shapeType.adj : shape.adj;
        this.origin = shape.origin == null ? this.shapeType.origin : shape.origin;
        this.size = shape.size == null ? this.shapeType.size : shape.size;
        this.limo = shape.limo == null ? this.shapeType.limo : shape.limo;
    }

    public void setScale(float xscale, float yscale) {
        this.xscale = xscale;
        this.yscale = yscale;
    }

    public int resolveCallout(VMLCallout callout) {
        if (callout.code == '#') {
            return this.adj[callout.index];
        }
        return (Integer)this.callouts.get(callout.index);
    }

    public int resolveEnv(String env) {
        float w;
        String weight;
        if ((env = env.toLowerCase()).equals("width")) {
            return this.size.x;
        }
        if (env.equals("height")) {
            return this.size.y;
        }
        if (env.equals("xcenter")) {
            return this.origin.x + this.size.x / 2;
        }
        if (env.equals("ycenter")) {
            return this.origin.y + this.size.y / 2;
        }
        if (env.equals("xlimo")) {
            return this.limo == null ? 0 : this.limo.x;
        }
        if (env.equals("ylimo")) {
            return this.limo == null ? 0 : this.limo.y;
        }
        if (env.equals("linedrawn")) {
            return this.shape.stroke == null ? 0 : 1;
        }
        if (env.equals("pixellinewidth") && (weight = this.shape.strokeWeight) != null && (w = VMLPathConverter.readCSSLength(weight, 0.0f)) > 0.0f) {
            return Math.round(w * this.xscale * this.pathScale);
        }
        if (env.equals("pixelwidth")) {
            return Math.round((float)this.size.x * this.xscale * this.pathScale);
        }
        if (env.equals("pixelheight")) {
            return Math.round((float)this.size.x * this.xscale * this.pathScale);
        }
        throw new RuntimeException("unknown env: " + env);
    }

    public void readFormulas() {
        Object n;
        Element formulas = null;
        Iterator it = this.shapeType.content();
        while (it.hasNext()) {
            n = it.next();
            if (!(n instanceof VMLFormulasElement)) continue;
            formulas = (VMLFormulasElement)n;
            break;
        }
        if (formulas == null) {
            return;
        }
        it = formulas.content();
        while (it.hasNext()) {
            n = it.next();
            if (!(n instanceof VMLFElement)) continue;
            VMLFElement f = (VMLFElement)n;
            int val = f.eval(this);
            this.callouts.add(new Integer(val));
        }
    }

    public VMLCoordPair getSize() {
        return this.size;
    }

    public VMLCoordPair getOrigin() {
        return this.origin;
    }

    public void setOuterSize(float width, float height) {
        this.outerWidth = width;
        this.outerHeight = height;
        this.pathScaleX = width / (float)this.size.x;
        this.pathScaleY = height / (float)this.size.y;
        this.pathScale = this.pathScaleX > this.pathScaleY ? this.pathScaleY : this.pathScaleX;
    }

    private float transformX(int x) {
        float r = this.limo != null ? (x < this.limo.x ? -this.outerWidth / 2.0f + this.pathScale * (float)(x - this.origin.x) : this.outerWidth / 2.0f - this.pathScale * (float)(this.origin.x + this.size.x - x)) : this.pathScaleX * (float)(x - this.origin.x) - this.outerWidth / 2.0f;
        return (float)Math.round(r * 100.0f) / 100.0f;
    }

    private float transformY(int y) {
        float r = this.limo != null ? (y < this.limo.y ? -this.outerHeight / 2.0f + this.pathScale * (float)(y - this.origin.y) : this.outerHeight / 2.0f - this.pathScale * (float)(this.origin.y + this.size.y - y)) : this.pathScaleY * (float)(y - this.origin.y) - this.outerHeight / 2.0f;
        return (float)Math.round(r * 100.0f) / 100.0f;
    }

    private int resolve(Object arg) {
        if (arg instanceof VMLCallout) {
            return this.resolveCallout((VMLCallout)arg);
        }
        if (arg instanceof Integer) {
            return (Integer)arg;
        }
        throw new RuntimeException("bad arg: " + arg);
    }

    private void drawArrow(StringBuffer sb, String type, int sx, int sy, int tx, int ty) {
        double y1;
        double dy;
        double x0 = this.transformX(sx);
        double y0 = this.transformY(sy);
        double x1 = this.transformX(tx);
        double dx = x0 - x1;
        double len = Math.sqrt(dx * dx + (dy = y0 - (y1 = (double)this.transformY(ty))) * dy);
        if (len < 0.001) {
            return;
        }
        double nx = dx / len;
        double ny = dy / len;
        double targetLen = 100.0;
        if (type.equals("diamond") || type.equals("oval")) {
            double targetHalfWidth = targetLen / 3.0;
            double ax1 = x1 + targetHalfWidth * nx;
            double ay1 = y1 + targetHalfWidth * ny;
            double ax2 = x1 - targetHalfWidth * ny;
            double ay2 = y1 + targetHalfWidth * nx;
            double ax3 = x1 - targetHalfWidth * nx;
            double ay3 = y1 - targetHalfWidth * ny;
            double ax4 = x1 + targetHalfWidth * ny;
            double ay4 = y1 - targetHalfWidth * nx;
            sb.append('M');
            sb.append((double)Math.round(ax1 * 100.0) / 100.0);
            sb.append(' ');
            sb.append((double)Math.round(ay1 * 100.0) / 100.0);
            sb.append('L');
            sb.append((double)Math.round(ax2 * 100.0) / 100.0);
            sb.append(' ');
            sb.append((double)Math.round(ay2 * 100.0) / 100.0);
            sb.append('L');
            sb.append((double)Math.round(ax3 * 100.0) / 100.0);
            sb.append(' ');
            sb.append((double)Math.round(ay3 * 100.0) / 100.0);
            sb.append('L');
            sb.append((double)Math.round(ax4 * 100.0) / 100.0);
            sb.append(' ');
            sb.append((double)Math.round(ay4 * 100.0) / 100.0);
            sb.append('z');
        } else {
            double targetHalfWidth = targetLen / 4.0;
            double bx = x1 + targetLen * nx;
            double by = y1 + targetLen * ny;
            double ax1 = bx + targetHalfWidth * ny;
            double ay1 = by - targetHalfWidth * nx;
            double ax2 = bx - targetHalfWidth * ny;
            double ay2 = by + targetHalfWidth * nx;
            sb.append('M');
            sb.append((double)Math.round(ax1 * 100.0) / 100.0);
            sb.append(' ');
            sb.append((double)Math.round(ay1 * 100.0) / 100.0);
            sb.append('L');
            sb.append(x1);
            sb.append(' ');
            sb.append(y1);
            sb.append('L');
            sb.append((double)Math.round(ax2 * 100.0) / 100.0);
            sb.append(' ');
            sb.append((double)Math.round(ay2 * 100.0) / 100.0);
            sb.append('z');
        }
    }

    private void startLine(StringBuffer sb, int x0, int y0, int x1, int y1) {
        if (this.shape.startArrow != null && !this.shape.startArrow.equals("none")) {
            this.drawArrow(sb, this.shape.startArrow, x1, y1, x0, y0);
        }
        sb.append('M');
        sb.append(this.transformX(x0));
        sb.append(' ');
        sb.append(this.transformY(y0));
    }

    private void endLine(StringBuffer sb, int x0, int y0, int x1, int y1) {
        if (this.shape.endArrow != null && !this.shape.endArrow.equals("none")) {
            this.drawArrow(sb, this.shape.endArrow, x0, y0, x1, y1);
        }
    }

    public String getSVGPath() {
        VMLPathSegment[] segments = this.shapeType.path;
        if (segments == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int lastX = 0;
        int lastY = 0;
        int prevX = 0;
        int prevY = 0;
        boolean movedTo = false;
        int i = 0;
        while (i < segments.length) {
            int k;
            VMLPathSegment s = segments[i];
            if (s.command.equals("m")) {
                lastX = this.resolve(s.args[0]);
                lastY = this.resolve(s.args[1]);
                movedTo = false;
            } else if (s.command.equals("l")) {
                k = 0;
                while (k + 1 < s.args.length) {
                    int x = this.resolve(s.args[k]);
                    int y = this.resolve(s.args[k + 1]);
                    if (!movedTo) {
                        this.startLine(sb, lastX, lastY, x, y);
                        movedTo = true;
                    }
                    prevX = lastX;
                    prevY = lastY;
                    lastX = x;
                    lastY = y;
                    sb.append('L');
                    sb.append(this.transformX(lastX));
                    sb.append(' ');
                    sb.append(this.transformY(lastY));
                    k += 2;
                }
            } else if (s.command.equals("t")) {
                lastX += this.resolve(s.args[0]);
                lastY += this.resolve(s.args[1]);
                movedTo = false;
            } else if (s.command.equals("r")) {
                int x0 = lastX;
                int y0 = lastY;
                int k2 = 0;
                while (k2 + 1 < s.args.length) {
                    if (k2 > 0) {
                        sb.append(' ');
                    }
                    int x = this.resolve(s.args[k2]) + x0;
                    int y = this.resolve(s.args[k2 + 1]) + y0;
                    if (!movedTo) {
                        this.startLine(sb, lastX, lastY, x, y);
                        movedTo = true;
                    }
                    prevX = lastX;
                    prevY = lastY;
                    lastX = x;
                    lastY = y;
                    sb.append('L');
                    sb.append(this.transformX(lastX));
                    sb.append(' ');
                    sb.append(this.transformY(lastY));
                    k2 += 2;
                }
            } else if (s.command.equals("x")) {
                if (movedTo) {
                    sb.append('z');
                    movedTo = false;
                }
            } else if (s.command.equals("e")) {
                if (movedTo) {
                    this.endLine(sb, prevX, prevY, lastX, lastY);
                    movedTo = false;
                }
            } else if (s.command.equals("qy") || s.command.equals("qx")) {
                boolean tanX = s.command.equals("qx");
                int k3 = 0;
                while (k3 + 1 < s.args.length) {
                    int tx = this.resolve(s.args[k3]);
                    int ty = this.resolve(s.args[k3 + 1]);
                    if (!movedTo) {
                        if (tanX) {
                            this.startLine(sb, lastX, lastY, tx, lastY);
                        } else {
                            this.startLine(sb, lastX, lastY, lastX, ty);
                        }
                        movedTo = true;
                    }
                    sb.append('C');
                    if (tanX) {
                        sb.append(this.transformX(lastX + 2 * (tx - lastX) / 3));
                        sb.append(' ');
                        sb.append(this.transformY(lastY));
                        sb.append(' ');
                        sb.append(this.transformX(tx));
                        sb.append(' ');
                        sb.append(this.transformY(lastY + (ty - lastY) / 3));
                        prevX = tx;
                        prevY = lastY;
                    } else {
                        sb.append(this.transformX(lastX));
                        sb.append(' ');
                        sb.append(this.transformY(lastY + 2 * (ty - lastY) / 3));
                        sb.append(' ');
                        sb.append(this.transformX(lastX + (tx - lastX) / 3));
                        sb.append(' ');
                        sb.append(this.transformY(ty));
                        prevX = lastX;
                        prevY = ty;
                    }
                    sb.append(' ');
                    sb.append(this.transformX(tx));
                    sb.append(' ');
                    sb.append(this.transformY(ty));
                    lastX = tx;
                    lastY = ty;
                    tanX = !tanX;
                    k3 += 2;
                }
            } else if (s.command.equals("c")) {
                k = 0;
                while (k + 5 < s.args.length) {
                    int cx1 = this.resolve(s.args[k]);
                    int cy1 = this.resolve(s.args[k + 1]);
                    int cx2 = this.resolve(s.args[k + 2]);
                    int cy2 = this.resolve(s.args[k + 3]);
                    int cx3 = this.resolve(s.args[k + 4]);
                    int cy3 = this.resolve(s.args[k + 5]);
                    if (!movedTo) {
                        this.startLine(sb, lastX, lastY, cx1, cy1);
                        movedTo = true;
                    }
                    sb.append('C');
                    sb.append(this.transformX(cx1));
                    sb.append(' ');
                    sb.append(this.transformY(cy1));
                    sb.append(' ');
                    sb.append(this.transformX(cx2));
                    sb.append(' ');
                    sb.append(this.transformY(cy2));
                    sb.append(' ');
                    sb.append(this.transformX(cx3));
                    sb.append(' ');
                    sb.append(this.transformY(cy3));
                    prevX = cx2;
                    prevY = cy2;
                    lastX = cx3;
                    lastY = cy3;
                    k += 6;
                }
            } else {
                System.err.println("path command " + s.command + " not supported");
            }
            ++i;
        }
        return sb.toString();
    }

    public static float readCSSLength(String len, float def) {
        int ulen = 2;
        float conv = 0.0f;
        if (len.endsWith("pt") || len.endsWith("px")) {
            conv = 1.0f;
        } else if (len.endsWith("in")) {
            conv = 0.013888889f;
        }
        if (conv > 0.0f) {
            try {
                return Float.parseFloat(len.substring(0, len.length() - ulen)) * conv;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return def;
    }

    public float[] getTextBox() {
        Object[] textbox = this.shapeType.textbox;
        if (textbox == null) {
            return null;
        }
        float[] tb = new float[textbox.length];
        int i = 0;
        while (i < textbox.length) {
            tb[i] = this.transformX(this.resolve(textbox[i]));
            tb[i + 1] = this.transformY(this.resolve(textbox[i + 1]));
            i += 2;
        }
        return tb;
    }
}

