/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.vml;

import com.adobe.dp.office.vml.VMLCallout;
import com.adobe.dp.office.vml.VMLElement;
import com.adobe.dp.office.vml.VMLEnv;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class VMLFElement
extends VMLElement {
    String command;
    Object[] args;

    public VMLFElement(Attributes attr) {
        super(attr);
        String eqn = attr.getValue("eqn");
        StringTokenizer tok = new StringTokenizer(eqn, " ");
        int len = tok.countTokens();
        this.command = tok.nextToken();
        this.args = new Object[len - 1];
        int i = 1;
        while (i < len) {
            int v;
            String t = tok.nextToken();
            char c = t.charAt(0);
            if (c == '@' || c == '#') {
                v = Integer.parseInt(t.substring(1));
                this.args[i - 1] = new VMLCallout(t.charAt(0), v);
            } else if ('0' <= c && c <= '9') {
                v = Integer.parseInt(t);
                this.args[i - 1] = new Integer(v);
            } else if ('a' <= c && c <= 'z') {
                this.args[i - 1] = t;
            } else {
                throw new RuntimeException("Unknown stuff: " + t);
            }
            ++i;
        }
    }

    private static int resolve(VMLEnv env, Object arg) {
        if (arg instanceof Integer) {
            return (Integer)arg;
        }
        if (arg instanceof VMLCallout) {
            return env.resolveCallout((VMLCallout)arg);
        }
        if (arg instanceof String) {
            return env.resolveEnv((String)arg);
        }
        throw new RuntimeException("Unknown stuff: " + arg);
    }

    public int eval(VMLEnv env) {
        if (this.command.equals("val")) {
            return VMLFElement.resolve(env, this.args[0]);
        }
        if (this.command.equals("sum")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            int p2 = VMLFElement.resolve(env, this.args[2]);
            return v + p1 - p2;
        }
        if (this.command.equals("prod")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            int p2 = VMLFElement.resolve(env, this.args[2]);
            return (int)Math.round((double)(v * p1) / (double)p2);
        }
        if (this.command.equals("mid")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            return (v + p1) / 2;
        }
        if (this.command.equals("abs")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            return v > 0 ? v : -v;
        }
        if (this.command.equals("min")) {
            int p1;
            int v = VMLFElement.resolve(env, this.args[0]);
            return v > (p1 = VMLFElement.resolve(env, this.args[1])) ? p1 : v;
        }
        if (this.command.equals("max")) {
            int p1;
            int v = VMLFElement.resolve(env, this.args[0]);
            return v > (p1 = VMLFElement.resolve(env, this.args[1])) ? v : p1;
        }
        if (this.command.equals("if")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            int p2 = VMLFElement.resolve(env, this.args[2]);
            return v > 0 ? p1 : p2;
        }
        if (this.command.equals("mod")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            int p2 = VMLFElement.resolve(env, this.args[2]);
            return (int)Math.floor(Math.sqrt((double)v * (double)v + (double)p1 * (double)p1 + (double)p2 * (double)p2));
        }
        if (this.command.equals("atan2")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            return (int)Math.floor(65536.0 * Math.toDegrees(Math.atan2(p1, v)));
        }
        if (this.command.equals("sin")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            return (int)Math.floor((double)v * Math.sin(Math.toRadians((double)p1 / 65536.0)));
        }
        if (this.command.equals("cos")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            return (int)Math.floor((double)v * Math.cos(Math.toRadians((double)p1 / 65536.0)));
        }
        if (this.command.equals("cosatan2")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            int p2 = VMLFElement.resolve(env, this.args[2]);
            return (int)Math.floor((double)v * Math.cos(Math.atan2(p2, p1)));
        }
        if (this.command.equals("sinatan2")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            int p2 = VMLFElement.resolve(env, this.args[2]);
            return (int)Math.floor((double)v * Math.sin(Math.atan2(p2, p1)));
        }
        if (this.command.equals("sqrt")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            return (int)Math.floor(Math.sqrt(v));
        }
        if (this.command.equals("sumangle")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            int p2 = VMLFElement.resolve(env, this.args[2]);
            return v + p1 * 65536 - p2 * 65536;
        }
        if (this.command.equals("ellipse")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            int p2 = VMLFElement.resolve(env, this.args[2]);
            double r = (double)v / (double)p1;
            return (int)Math.floor((double)p2 * Math.sqrt(1.0 - r * r));
        }
        if (this.command.equals("tan")) {
            int v = VMLFElement.resolve(env, this.args[0]);
            int p1 = VMLFElement.resolve(env, this.args[1]);
            return (int)Math.floor((double)v * Math.tan(Math.toRadians((double)p1 / 65536.0)));
        }
        throw new RuntimeException("unknown command: " + this.command);
    }
}

