/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.vml;

import com.adobe.dp.office.vml.VMLCoordPair;
import com.adobe.dp.office.vml.VMLElement;
import com.adobe.dp.office.vml.VMLFElement;
import com.adobe.dp.office.vml.VMLFormulasElement;
import com.adobe.dp.office.vml.VMLGroupElement;
import com.adobe.dp.office.vml.VMLLineElement;
import com.adobe.dp.office.vml.VMLOvalElement;
import com.adobe.dp.office.vml.VMLRectElement;
import com.adobe.dp.office.vml.VMLShadow;
import com.adobe.dp.office.vml.VMLShapeElement;
import com.adobe.dp.office.vml.VMLShapeTypeElement;
import com.adobe.dp.office.vml.VMLTextboxElement;
import com.adobe.dp.office.word.Element;
import java.util.Hashtable;
import org.xml.sax.Attributes;

public class VMLElementFactory {
    public static Element createVMLElement(VMLElement parent, Hashtable vmldefs, String localName, Attributes attr) {
        if (localName.equals("group")) {
            return new VMLGroupElement(attr);
        }
        if (localName.equals("line")) {
            return new VMLLineElement(attr);
        }
        if (localName.equals("oval")) {
            return new VMLOvalElement(attr);
        }
        if (localName.equals("rect")) {
            return new VMLRectElement(attr);
        }
        if (localName.equals("shape")) {
            Object def;
            VMLShapeElement e = new VMLShapeElement(attr);
            String ref = attr.getValue("type");
            if (ref != null && ref.startsWith("#") && (def = vmldefs.get(ref.substring(1))) instanceof VMLShapeTypeElement) {
                e.type = (VMLShapeTypeElement)def;
            }
            return e;
        }
        if (localName.equals("shapetype")) {
            VMLShapeTypeElement e = new VMLShapeTypeElement(attr);
            if (e.id != null) {
                vmldefs.put(e.id, e);
            }
            return e;
        }
        if (localName.equals("formulas")) {
            return new VMLFormulasElement(attr);
        }
        if (localName.equals("f")) {
            return new VMLFElement(attr);
        }
        if (localName.equals("textbox")) {
            return new VMLTextboxElement(attr);
        }
        if (localName.equals("path")) {
            if (parent instanceof VMLShapeTypeElement) {
                String textbox;
                String fillok;
                String strokeok;
                VMLShapeTypeElement ste = (VMLShapeTypeElement)parent;
                VMLCoordPair limo = VMLCoordPair.parse(attr.getValue("limo"));
                if (limo != null) {
                    ste.limo = limo;
                }
                if ((strokeok = attr.getValue("strokeok")) != null && !strokeok.toLowerCase().startsWith("t")) {
                    ste.strokeok = false;
                }
                if ((fillok = attr.getValue("fillok")) != null && !fillok.toLowerCase().startsWith("t")) {
                    ste.fillok = false;
                }
                if ((textbox = attr.getValue("textboxrect")) != null) {
                    ste.setTextBox(textbox);
                }
            }
        } else if (localName.equals("stroke")) {
            if (parent instanceof VMLElement) {
                VMLElement e = parent;
                e.endArrow = attr.getValue("endarrow");
                e.startArrow = attr.getValue("startarrow");
            }
        } else if (localName.equals("fill")) {
            boolean cfr_ignored_0 = parent instanceof VMLElement;
        } else if (localName.equals("shadow") && parent instanceof VMLElement) {
            VMLElement e = parent;
            e.shadow = new VMLShadow(attr);
        }
        return null;
    }
}

