/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.vml;

import com.adobe.dp.office.types.RGBColor;
import com.adobe.dp.office.vml.VMLShadow;
import com.adobe.dp.office.vml.VMLTextboxElement;
import com.adobe.dp.office.word.ContainerElement;
import com.adobe.dp.office.word.TXBXContentElement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class VMLElement
extends ContainerElement {
    Hashtable style;
    RGBColor fill;
    RGBColor stroke;
    VMLShadow shadow;
    String strokeWeight;
    float opacity = 1.0f;
    String startArrow;
    String endArrow;

    VMLElement(Attributes attr) {
        this.style = VMLElement.parseStyle(attr.getValue("style"));
        String f = attr.getValue("filled");
        if ((f == null || f.startsWith("t")) && this.isDrawable()) {
            this.fill = VMLElement.parseColor(attr.getValue("fillcolor"));
            if (this.fill == null) {
                this.fill = new RGBColor(0xFFFFFF);
            }
        }
        if (((f = attr.getValue("stroked")) == null || f.startsWith("t")) && this.isDrawable()) {
            this.stroke = VMLElement.parseColor(attr.getValue("strokecolor"));
            if (this.stroke == null) {
                this.stroke = new RGBColor(0);
            }
            this.strokeWeight = attr.getValue("strokeweight");
            if (this.strokeWeight == null) {
                this.strokeWeight = "0.75pt";
            }
        }
        this.opacity = VMLElement.parseVMLFloat(attr.getValue("opacity"), 1.0f);
    }

    public float getOpacity() {
        return this.opacity;
    }

    public VMLShadow getShadow() {
        return this.shadow;
    }

    protected boolean isDrawable() {
        return true;
    }

    public Hashtable getStyle() {
        return this.style;
    }

    public RGBColor getFill() {
        return this.fill;
    }

    public RGBColor getStroke() {
        return this.stroke;
    }

    public String getStrokeWeight() {
        return this.strokeWeight;
    }

    static float parseVMLFloat(String f, float def) {
        if (f != null) {
            if (f.endsWith("f")) {
                return (float)Integer.parseInt(f.substring(0, f.length() - 1)) / 65536.0f;
            }
            return Float.parseFloat(f);
        }
        return def;
    }

    static Hashtable parseStyle(String style) {
        if (style == null) {
            return null;
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        StringTokenizer tok = new StringTokenizer(style, ";");
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            int i = t.indexOf(58);
            if (i <= 0) continue;
            String prop = t.substring(0, i).trim();
            String val = t.substring(i + 1).trim();
            result.put(prop, val);
        }
        return result;
    }

    static RGBColor parseColor(String color) {
        if (color == null || !color.startsWith("#") || color.length() < 7) {
            return null;
        }
        try {
            int ival = Integer.parseInt(color.substring(1, 7), 16);
            return new RGBColor(ival);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TXBXContentElement getTextBoxContentElement() {
        Iterator it = this.content();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof VMLTextboxElement)) continue;
            Iterator cit = ((VMLTextboxElement)child).content();
            while (cit.hasNext()) {
                child = cit.next();
                if (!(child instanceof TXBXContentElement)) continue;
                return (TXBXContentElement)child;
            }
        }
        return null;
    }

    public float[] getTextBox() {
        return null;
    }

    public static float getNumberValue(Hashtable style, String propName, float def) {
        Object propVal = style.get(propName);
        if (propVal != null) {
            try {
                return Float.parseFloat(propVal.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return def;
    }
}

