/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.rtf;

import com.adobe.dp.office.rtf.RTFControl;
import com.adobe.dp.office.rtf.RTFControlType;
import com.adobe.dp.office.rtf.RTFDocumentParser;
import com.adobe.dp.office.rtf.RTFEncodingControlType;
import com.adobe.dp.office.rtf.RTFFont;
import com.adobe.dp.office.rtf.RTFGroup;
import java.util.HashSet;

public class RTFFontTableControlType
extends RTFControlType {
    static HashSet encSuffix = new HashSet();

    static {
        encSuffix.add("CE");
        encSuffix.add("Western");
        encSuffix.add("Cyr");
        encSuffix.add("Greek");
        encSuffix.add("Tur");
        encSuffix.add("Baltic");
        encSuffix.add("CE");
    }

    public RTFFontTableControlType(String name) {
        super(name);
    }

    static String stripEncSuffix(String name) {
        String word;
        int sp = name.lastIndexOf(" ");
        if (sp >= 0 && (encSuffix.contains(word = name.substring(sp + 1)) || word.startsWith("(") && word.endsWith(")"))) {
            return name.substring(0, sp);
        }
        return name;
    }

    private void processFont(RTFGroup group, RTFDocumentParser parser) {
        int ne;
        Object[] content = group.content;
        int len = content.length;
        int index = -1;
        int type = 0;
        String encoding = null;
        StringBuffer name = new StringBuffer();
        int i = 0;
        while (i < len) {
            Object e = content[i];
            if (e instanceof RTFControl) {
                RTFControl f = (RTFControl)e;
                String fname = f.getName();
                if (fname.equals("f")) {
                    index = f.getParam();
                } else if (fname.equals("froman")) {
                    type = 0;
                } else if (fname.equals("fswiss")) {
                    type = 1;
                } else if (fname.equals("fmodern")) {
                    type = 2;
                } else if (fname.equals("fscript")) {
                    type = 3;
                } else if (fname.equals("ftech")) {
                    type = 5;
                } else if (fname.equals("cpg")) {
                    encoding = RTFEncodingControlType.getEncoding(f.getParam());
                } else if (fname.equals("fcharset")) {
                    encoding = RTFEncodingControlType.getCharsetEncoding(f.getParam());
                }
            } else if (e instanceof String) {
                name.append(e);
            }
            ++i;
        }
        if (index >= 0 && name != null && (ne = name.indexOf(";")) >= 0) {
            RTFFont font = new RTFFont();
            font.type = type;
            font.encoding = encoding;
            font.name = RTFFontTableControlType.stripEncSuffix(name.substring(0, ne));
            System.out.println("Font name: " + font.name);
            parser.addFont(index, font);
        }
    }

    public boolean parseTimeGroupExec(RTFGroup group, RTFDocumentParser parser) {
        Object[] content = group.content;
        int len = content.length;
        int i = 0;
        while (i < len) {
            Object e = content[i];
            if (e instanceof RTFGroup) {
                this.processFont((RTFGroup)e, parser);
            }
            ++i;
        }
        return true;
    }
}

