/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.rtf;

import com.adobe.dp.office.rtf.RTFColorTableControlType;
import com.adobe.dp.office.rtf.RTFControl;
import com.adobe.dp.office.rtf.RTFDocumentParser;
import com.adobe.dp.office.rtf.RTFEncodingControlType;
import com.adobe.dp.office.rtf.RTFFontControlType;
import com.adobe.dp.office.rtf.RTFFontTableControlType;
import com.adobe.dp.office.rtf.RTFFormattingControlType;
import com.adobe.dp.office.rtf.RTFGenericControlType;
import com.adobe.dp.office.rtf.RTFGroup;
import com.adobe.dp.office.rtf.RTFHexCharControlType;
import com.adobe.dp.office.rtf.RTFListOverrideTableControlType;
import com.adobe.dp.office.rtf.RTFListTableControlType;
import com.adobe.dp.office.rtf.RTFMetadataTableControlType;
import com.adobe.dp.office.rtf.RTFPictControlType;
import com.adobe.dp.office.rtf.RTFResetFormattingControlType;
import com.adobe.dp.office.rtf.RTFSkipCountControlType;
import com.adobe.dp.office.rtf.RTFSpecificFormattingControlType;
import com.adobe.dp.office.rtf.RTFStyle;
import com.adobe.dp.office.rtf.RTFStylesheetControlType;
import com.adobe.dp.office.rtf.RTFSubstituteControlType;
import com.adobe.dp.office.rtf.RTFToggleFormatingControlType;
import com.adobe.dp.office.rtf.RTFUnicodeControlType;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class RTFControlType {
    static Hashtable table = new Hashtable();
    private String name;
    public static final Set paragraphProps;
    public static final Set characterProps;

    static {
        HashSet<String> pp = new HashSet<String>();
        pp.add("q_");
        pp.add("sb");
        pp.add("sa");
        pp.add("fi");
        pp.add("li");
        pp.add("ri");
        pp.add("sl");
        pp.add("slmult");
        paragraphProps = pp;
        HashSet<String> cp = new HashSet<String>();
        cp.add("b");
        cp.add("i");
        cp.add("fs");
        cp.add("cf");
        cp.add("cb");
        cp.add("f");
        cp.add("ul");
        cp.add("sub");
        cp.add("super");
        cp.add("strike");
        cp.add("webhidden");
        characterProps = cp;
        new RTFSubstituteControlType("~", "\u00a0");
        new RTFSubstituteControlType("{", "{");
        new RTFSubstituteControlType("}", "}");
        new RTFSubstituteControlType("\\", "\\");
        new RTFSubstituteControlType("tab", "\t");
        new RTFHexCharControlType("'");
        new RTFEncodingControlType("ansi", "Cp1252");
        new RTFEncodingControlType("mac", "MacRoman");
        new RTFEncodingControlType("pc", "Cp437");
        new RTFEncodingControlType("pca", "Cp850");
        new RTFEncodingControlType("ansicpg", null);
        new RTFEncodingControlType("lang", null);
        new RTFEncodingControlType("langfe", null);
        new RTFEncodingControlType("langnp", null);
        new RTFEncodingControlType("langfenp", null);
        new RTFUnicodeControlType("u");
        new RTFSkipCountControlType("uc");
        new RTFFontTableControlType("fonttbl");
        new RTFStylesheetControlType("stylesheet");
        new RTFColorTableControlType("colortbl");
        new RTFListTableControlType("listtable");
        new RTFListOverrideTableControlType("listoverridetable");
        new RTFMetadataTableControlType("info");
        new RTFPictControlType("pict");
        new RTFResetFormattingControlType("plain", characterProps);
        new RTFResetFormattingControlType("pard", paragraphProps);
        new RTFSpecificFormattingControlType("ql", "q_", "l");
        new RTFSpecificFormattingControlType("qr", "q_", "r");
        new RTFSpecificFormattingControlType("qc", "q_", "c");
        new RTFSpecificFormattingControlType("qj", "q_", "j");
        new RTFFormattingControlType("sb");
        new RTFFormattingControlType("sa");
        new RTFFormattingControlType("fi");
        new RTFFormattingControlType("li");
        new RTFFormattingControlType("ri");
        new RTFFormattingControlType("sl");
        new RTFFormattingControlType("slmult");
        new RTFSpecificFormattingControlType("pagebb");
        new RTFSpecificFormattingControlType("keep");
        new RTFSpecificFormattingControlType("keepn");
        new RTFSpecificFormattingControlType("widctlpar");
        new RTFSpecificFormattingControlType("nowidctlpar", "widctlpar", Boolean.FALSE);
        new RTFFontControlType("f");
        new RTFFormattingControlType("fs");
        new RTFFormattingControlType("cb");
        new RTFFormattingControlType("cf");
        new RTFFormattingControlType("charscalex");
        new RTFFormattingControlType("dn", new Integer(6));
        new RTFFormattingControlType("up", new Integer(6));
        new RTFToggleFormatingControlType("b");
        new RTFToggleFormatingControlType("i");
        new RTFToggleFormatingControlType("ul");
        new RTFToggleFormatingControlType("uldash", "ul", "dash");
        new RTFToggleFormatingControlType("uldashd", "ul", "dashd");
        new RTFToggleFormatingControlType("uldashdd", "ul", "dashdd");
        new RTFToggleFormatingControlType("uldb", "ul", "db");
        new RTFToggleFormatingControlType("ulhwave", "ul", "hwave");
        new RTFToggleFormatingControlType("ulldash", "ul", "ldash");
        new RTFToggleFormatingControlType("ulth", "ul", "th");
        new RTFToggleFormatingControlType("ulthd", "ul", "thd");
        new RTFToggleFormatingControlType("ulthdash", "ul", "thdash");
        new RTFToggleFormatingControlType("ulthdashd", "ul", "thdashd");
        new RTFToggleFormatingControlType("ulthdashdd", "ul", "thdashdd");
        new RTFToggleFormatingControlType("ulthldash", "ul", "thldash");
        new RTFToggleFormatingControlType("ululdbwave", "ul", "uldbwave");
        new RTFToggleFormatingControlType("ulw", "ul", "w");
        new RTFToggleFormatingControlType("ulwave", "ul", "wave");
        new RTFSpecificFormattingControlType("ulnone", "ul", Boolean.FALSE);
        new RTFFormattingControlType("ulc");
        new RTFToggleFormatingControlType("outl");
        new RTFToggleFormatingControlType("shad");
        new RTFToggleFormatingControlType("strike");
        new RTFToggleFormatingControlType("striked", "strike", "d");
        new RTFToggleFormatingControlType("scaps");
        new RTFToggleFormatingControlType("caps");
        new RTFFormattingControlType("kerning");
        new RTFToggleFormatingControlType("v");
        new RTFSpecificFormattingControlType("webhidden");
        new RTFSpecificFormattingControlType("sub");
        new RTFSpecificFormattingControlType("super");
    }

    protected RTFControlType(String name) {
        this.name = name;
        table.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RTFControlType getControlTypeByName(String name) {
        Hashtable hashtable = table;
        synchronized (hashtable) {
            RTFControlType res = (RTFControlType)table.get(name);
            if (res == null) {
                res = new RTFGenericControlType(name);
            }
            return res;
        }
    }

    public boolean parseTimeExec(RTFControl ctrl, RTFDocumentParser parser) {
        return false;
    }

    public boolean parseTimeGroupExec(RTFGroup group, RTFDocumentParser parser) {
        return false;
    }

    public boolean formattingExec(RTFControl ctrl, RTFStyle style) {
        return false;
    }
}

