/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.metafile;

import com.adobe.dp.office.metafile.GDIBitmap;
import com.adobe.dp.office.metafile.GDISurface;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public abstract class MetafileParser {
    private InputStream in;
    private int remainsInRecord;
    GDISurface handler;
    Vector objects = new Vector();

    protected MetafileParser(InputStream in, GDISurface handler) throws IOException {
        this.in = in;
        this.handler = handler;
    }

    protected int storeObject(Object obj, int index) {
        int len = this.objects.size();
        int i = index;
        while (i < len) {
            if (this.objects.get(i) == null) {
                this.objects.set(i, obj);
                return i;
            }
            ++i;
        }
        while (this.objects.size() < index) {
            this.objects.add(null);
        }
        this.objects.add(obj);
        return len;
    }

    protected void setRemainsBytes(int r) {
        this.remainsInRecord = r;
    }

    protected void setRemainsShorts(int r) {
        this.remainsInRecord = 2 * r;
    }

    protected int remainsBytes() {
        return this.remainsInRecord;
    }

    protected int remainsShorts() {
        return this.remainsInRecord / 2;
    }

    protected int remainsInts() {
        return this.remainsInRecord / 4;
    }

    protected void skipBytes(int n) throws IOException {
        if (this.in.skip(n) != (long)n) {
            throw new EOFException();
        }
        this.remainsInRecord -= n;
    }

    protected void skipShorts(int n) throws IOException {
        int byteCount = 2 * n;
        if (this.in.skip(byteCount) != (long)byteCount) {
            throw new EOFException();
        }
        this.remainsInRecord -= byteCount;
    }

    protected void skipInts(int n) throws IOException {
        int byteCount = 4 * n;
        if (this.in.skip(byteCount) != (long)byteCount) {
            throw new EOFException();
        }
        this.remainsInRecord -= byteCount;
    }

    protected short readShort() throws IOException {
        int b1 = this.in.read();
        if (b1 < 0) {
            throw new EOFException();
        }
        int b2 = this.in.read();
        if (b2 < 0) {
            throw new EOFException();
        }
        this.remainsInRecord -= 2;
        return (short)(b2 << 8 | b1 & 0xFF);
    }

    protected int readInt() throws IOException {
        int b1 = this.in.read();
        if (b1 < 0) {
            throw new EOFException();
        }
        int b2 = this.in.read();
        if (b2 < 0) {
            throw new EOFException();
        }
        int b3 = this.in.read();
        if (b3 < 0) {
            throw new EOFException();
        }
        int b4 = this.in.read();
        if (b4 < 0) {
            throw new EOFException();
        }
        this.remainsInRecord -= 4;
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    protected void readBytes(byte[] arr, int offset, int len) throws IOException {
        while (offset < len) {
            int r = this.in.read(arr, offset, len - offset);
            if (r <= 0) {
                throw new IOException("not enough data");
            }
            offset += r;
        }
        this.remainsInRecord -= len;
    }

    protected void readBytes(byte[] arr) throws IOException {
        this.readBytes(arr, 0, arr.length);
    }

    protected int readRGB() throws IOException {
        int bgr = this.readInt();
        int red = bgr & 0xFF;
        int green = bgr >> 8 & 0xFF;
        int blue = bgr >> 16 & 0xFF;
        return red << 16 | green << 8 | blue;
    }

    protected void finishRecord() throws IOException {
        if (this.remainsInRecord > 0) {
            this.in.skip(this.remainsInRecord);
            this.remainsInRecord = 0;
        }
    }

    protected GDIBitmap readDIB() throws IOException {
        return this.readDIB(0);
    }

    protected GDIBitmap readDIB(int offsetToBytes) throws IOException {
        int biSize = this.readInt();
        if (biSize != 40) {
            throw new IOException("Problem with BITMAPINFOHEADER");
        }
        int biWidth = this.readInt();
        int biHeight = this.readInt();
        short biPlanes = this.readShort();
        if (biPlanes != 1) {
            throw new IOException("Problem with BITMAPINFOHEADER");
        }
        short biBitsPixel = this.readShort();
        int biCompression = this.readInt();
        int biSizeImage = this.readInt();
        if (biSizeImage == 0) {
            int stride = 4 * ((biBitsPixel * biWidth + 31) / 32);
            biSizeImage = stride * biHeight;
        }
        this.readInt();
        this.readInt();
        int biClrUsed = this.readInt();
        this.readInt();
        offsetToBytes -= 40;
        int[] colors = null;
        if (biClrUsed > 0) {
            colors = new int[biClrUsed];
            int i = 0;
            while (i < biClrUsed) {
                offsetToBytes -= 4;
                colors[i] = this.readRGB();
                ++i;
            }
        }
        byte[] bits = new byte[biSizeImage];
        if (offsetToBytes > 0) {
            this.skipBytes(offsetToBytes);
        }
        this.readBytes(bits);
        return new GDIBitmap(biWidth, biHeight, biBitsPixel, biCompression, bits, colors);
    }

    public abstract boolean readNext() throws IOException;

    protected void close() throws IOException {
        this.in.close();
    }
}

