/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.metafile;

import com.adobe.dp.office.metafile.GDIBitmap;
import com.adobe.dp.office.metafile.GDIBrush;
import com.adobe.dp.office.metafile.GDIFont;
import com.adobe.dp.office.metafile.GDIMatrix;
import com.adobe.dp.office.metafile.GDIObject;
import com.adobe.dp.office.metafile.GDIPen;
import java.util.Stack;

public class GDISurface {
    public static final int TA_TOP = 0;
    public static final int TA_CENTER = 6;
    public static final int TA_BOTTOM = 8;
    public static final int TA_BASELINE = 24;
    public static final int TA_LEFT = 0;
    public static final int TA_RIGHT = 2;
    public static final int TA_RTLREADING = 256;
    public static final int TA_NOUPDATECP = 0;
    public static final int TA_UPDATECP = 1;
    public static final int ALTERNATE = 1;
    public static final int WINDING = 2;
    Stack saved = new Stack();
    GDIState state = new GDIState();
    int boundsLeft;
    int boundsTop;
    int boundsRight;
    int boundsBottom;

    public void setBounds(int left, int top, int right, int bottom) {
        this.boundsLeft = left;
        this.boundsTop = top;
        this.boundsRight = right;
        this.boundsBottom = bottom;
    }

    public void setWindowOrg(int x, int y) {
        this.state.windowOrgX = x;
        this.state.windowOrgY = y;
    }

    public void setWindowExt(int x, int y) {
        this.state.windowExtX = x;
        this.state.windowExtY = y;
        if (this.boundsLeft == this.boundsRight) {
            this.boundsRight += x > 0 ? x : -x;
        }
        if (this.boundsTop == this.boundsBottom) {
            this.boundsBottom = this.boundsTop + (y > 0 ? y : -y);
        }
    }

    public void setViewportOrg(int x, int y) {
        this.state.viewportOrgX = x;
        this.state.viewportOrgY = y;
    }

    public void setViewportExt(int x, int y) {
        this.state.viewportExtX = x;
        this.state.viewportExtY = y;
    }

    public void setTextColor(int rgb) {
        this.state.textColor = rgb;
    }

    public void setMapMode(int mode) {
        this.state.mapMode = mode;
    }

    public void setBkColor(int rgb) {
        this.state.bkColor = rgb;
    }

    public void setROP2(int mode) {
        this.state.rop2 = mode;
    }

    public void setBkMode(int mode) {
        this.state.bkMode = mode;
    }

    public void setTextAlign(int mode) {
        this.state.textAlign = mode;
    }

    public void setMiterLimit(int miterLimit) {
        this.state.miterLimit = miterLimit;
    }

    public void selectObject(GDIObject obj) {
        if (obj instanceof GDIPen) {
            this.state.currentPen = (GDIPen)obj;
        } else if (obj instanceof GDIBrush) {
            this.state.currentBrush = (GDIBrush)obj;
        } else if (obj instanceof GDIFont) {
            this.state.currentFont = (GDIFont)obj;
        }
    }

    public void deleteObject(GDIObject obj) {
        GDIState s = this.state;
        int si = this.saved.size();
        while (true) {
            if (obj == s.currentPen) {
                s.currentPen = null;
            } else if (obj == s.currentBrush) {
                s.currentBrush = null;
            } else if (obj == s.currentFont) {
                s.currentFont = null;
            }
            if (--si < 0) break;
            s = (GDIState)this.saved.get(si);
        }
    }

    public void setPolyFillMode(int mode) {
        this.state.polyFillMode = mode;
    }

    public void saveDC() {
        this.saved.push(this.state);
        this.state = this.state.cloneState();
    }

    public void restoreDC() {
        this.state = (GDIState)this.saved.pop();
    }

    public void moveTo(int x, int y) {
    }

    public void lineTo(int x, int y) {
    }

    public void rectangle(int x1, int y1, int x2, int y2) {
    }

    public void ellipse(int x1, int y1, int x2, int y2) {
    }

    public void polygon(int[] points, int offset, int len) {
    }

    public void polyline(int[] points, int offset, int len) {
    }

    public void polyPolyline(int[] lens, int[] points) {
        int offset = 0;
        int i = 0;
        while (i < lens.length) {
            int len = lens[i] * 2;
            this.polyline(points, offset, len);
            offset += len;
            ++i;
        }
    }

    public void polyPolygon(int[] lens, int[] points) {
        int offset = 0;
        int i = 0;
        while (i < lens.length) {
            int len = lens[i] * 2;
            this.polygon(points, offset, len);
            offset += len;
            ++i;
        }
    }

    public void extTextOut(int x, int y, String text, int flags, int[] clipRect, int[] adj) {
    }

    public GDIPen createPenIndirect(int style, int width, int rgb) {
        return new GDIPen(style, width, rgb);
    }

    public GDIPen extCreatePen(int extStyle, int width, int rgb) {
        return new GDIPen(0, width, rgb);
    }

    public GDIBrush createBrushIndirect(int style, int rgb, int hatch) {
        return new GDIBrush(style, rgb, hatch);
    }

    public GDIFont createFontIndirect(int fontHeight, int width, int esc, int orientation, int weight, String name, boolean italic, boolean underline, boolean strikeout, int charset, int quality, int pitchAndFamily) {
        return new GDIFont(name, fontHeight, weight, italic, underline, strikeout, charset, quality);
    }

    public void stretchDIB(GDIBitmap bitmap, int destX, int destY, int destWidth, int destHeight, int srcX, int srcY, int srcWidth, int srcHeight) {
    }

    public void commentMetafile(int version, byte[] data, int offset, int len) {
    }

    public void commentBeginGroup(int left, int top, int right, int bottom, String desc) {
    }

    public void commentEndGroup() {
    }

    public void commentEMFPlus(byte[] data, int offset, int len) {
    }

    public void commentGDIC(int type, byte[] data, int offset, int len) {
    }

    public void comment(byte[] data, int offset, int len) {
    }

    public GDIBrush getCurrentBrush() {
        return this.state.currentBrush;
    }

    public GDIFont getCurrentFont() {
        return this.state.currentFont;
    }

    public GDIPen getCurrentPen() {
        return this.state.currentPen;
    }

    public int getBkColor() {
        return this.state.bkColor;
    }

    public int getBkMode() {
        return this.state.bkMode;
    }

    public int getMapMode() {
        return this.state.mapMode;
    }

    public int getPolyFillMode() {
        return this.state.polyFillMode;
    }

    public int getROP2() {
        return this.state.rop2;
    }

    public int getTextAlign() {
        return this.state.textAlign;
    }

    public int getTextColor() {
        return this.state.textColor;
    }

    public int getWindowExtX() {
        return this.state.windowExtX;
    }

    public int getWindowExtY() {
        return this.state.windowExtY;
    }

    public int getWindowOrgX() {
        return this.state.windowOrgX;
    }

    public int getWindowOrgY() {
        return this.state.windowOrgY;
    }

    public int getBoundsBottom() {
        return this.boundsBottom;
    }

    public int getBoundsLeft() {
        return this.boundsLeft;
    }

    public int getBoundsRight() {
        return this.boundsRight;
    }

    public int getBoundsTop() {
        return this.boundsTop;
    }

    public int getViewportExtX() {
        return this.state.viewportExtX;
    }

    public int getViewportExtY() {
        return this.state.viewportExtY;
    }

    public int getViewportOrgX() {
        return this.state.viewportOrgX;
    }

    public int getViewportOrgY() {
        return this.state.viewportOrgY;
    }

    public int getMiterLimit() {
        return this.state.miterLimit;
    }

    public GDIMatrix getViewportMatrix() {
        int viewHeight;
        double sx = 1.0;
        double sy = 1.0;
        int viewX = this.state.viewportOrgX;
        int viewY = this.state.viewportOrgY;
        int viewWidth = this.state.viewportExtX;
        if (viewWidth == 0) {
            viewX = this.boundsLeft;
            viewWidth = this.boundsRight - this.boundsLeft;
        }
        if ((viewHeight = this.state.viewportExtY) == 0) {
            viewY = this.boundsTop;
            viewHeight = this.boundsBottom - this.boundsTop;
        }
        double x = viewX - this.boundsLeft;
        double y = viewY - this.boundsTop;
        if (this.state.windowExtX != 0 && this.state.windowExtY != 0 && viewWidth != 0 && viewHeight != 0) {
            sx = (double)viewWidth / (double)this.state.windowExtX;
            sy = (double)viewHeight / (double)this.state.windowExtY;
        }
        return new GDIMatrix(sx, 0.0, 0.0, sy, x -= sx * (double)this.state.windowOrgX, y -= sy * (double)this.state.windowOrgY);
    }

    class GDIState
    implements Cloneable {
        GDIBrush currentBrush;
        GDIPen currentPen;
        GDIFont currentFont;
        int windowOrgX;
        int windowOrgY;
        int windowExtX;
        int windowExtY;
        int viewportOrgX;
        int viewportOrgY;
        int viewportExtX;
        int viewportExtY;
        int textColor;
        int mapMode;
        int bkColor;
        int rop2;
        int bkMode;
        int textAlign;
        int polyFillMode = 2;
        int miterLimit;

        GDIState() {
        }

        GDIState cloneState() {
            try {
                return (GDIState)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Unexpected exception: CloneNotSupportedException");
            }
        }
    }
}

