/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.conv;

import com.adobe.dp.epub.io.BufferedDataSource;
import com.adobe.dp.epub.io.ContainerSource;
import com.adobe.dp.epub.io.DataSource;
import com.adobe.dp.epub.io.StringDataSource;
import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.Resource;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.ops.Element;
import com.adobe.dp.epub.ops.HTMLElement;
import com.adobe.dp.epub.ops.HyperlinkElement;
import com.adobe.dp.epub.ops.ImageElement;
import com.adobe.dp.epub.ops.OPSDocument;
import com.adobe.dp.epub.ops.SVGElement;
import com.adobe.dp.epub.ops.SVGImageElement;
import com.adobe.dp.epub.ops.XRef;
import com.adobe.dp.epub.style.CSSLength;
import com.adobe.dp.epub.style.InlineStyleRule;
import com.adobe.dp.epub.style.PrototypeRule;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.office.conv.GDISVGSurface;
import com.adobe.dp.office.conv.ResourceWriter;
import com.adobe.dp.office.conv.StreamAndName;
import com.adobe.dp.office.conv.StyleConverter;
import com.adobe.dp.office.conv.StylingResult;
import com.adobe.dp.office.conv.VMLConverter;
import com.adobe.dp.office.drawing.PictureData;
import com.adobe.dp.office.metafile.WMFParser;
import com.adobe.dp.office.vml.VMLGroupElement;
import com.adobe.dp.office.vml.VMLPathConverter;
import com.adobe.dp.office.word.BRElement;
import com.adobe.dp.office.word.BodyElement;
import com.adobe.dp.office.word.ContainerElement;
import com.adobe.dp.office.word.DrawingElement;
import com.adobe.dp.office.word.FootnoteElement;
import com.adobe.dp.office.word.FootnoteReferenceElement;
import com.adobe.dp.office.word.LastRenderedPageBreakElement;
import com.adobe.dp.office.word.NumberingLabel;
import com.adobe.dp.office.word.ParagraphElement;
import com.adobe.dp.office.word.ParagraphProperties;
import com.adobe.dp.office.word.PictElement;
import com.adobe.dp.office.word.RunElement;
import com.adobe.dp.office.word.RunProperties;
import com.adobe.dp.office.word.SmartTagElement;
import com.adobe.dp.office.word.Style;
import com.adobe.dp.office.word.TXBXContentElement;
import com.adobe.dp.office.word.TabElement;
import com.adobe.dp.office.word.TableCellElement;
import com.adobe.dp.office.word.TableElement;
import com.adobe.dp.office.word.TableProperties;
import com.adobe.dp.office.word.TableRowElement;
import com.adobe.dp.office.word.TextElement;
import com.adobe.dp.office.word.WordDocument;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class WordMLConverter {
    private StyleConverter styleConverter;
    private HashSet listElements = new HashSet();
    private Publication epub;
    private OPSDocument chapter;
    private OPSResource resource;
    private WordDocument doc;
    private boolean hadSpace = false;
    private Hashtable footnoteMap;
    private Hashtable convResources = new Hashtable();
    private ContainerSource wordResources;
    private Hashtable metadataNS = new Hashtable();
    private static final String mediaFolder = "OPS/media/";
    private boolean hasEpubMetadata;
    boolean includeWordMetadata = true;
    boolean chapterNameWasSet;
    boolean chapterSplitAllowed;
    private String nextPageName;
    boolean useWordPageBreaks;
    StringBuffer styleAcc = new StringBuffer();
    StringBuffer injectAcc = new StringBuffer();
    PrintWriter log;
    String nextResourceName;
    String nextResourceMediaType;
    Stack nesting = new Stack();
    int lastNumId = -1;

    WordMLConverter(WordDocument doc, Publication epub, StyleConverter styleConverter, PrintWriter log) {
        this.log = log;
        this.doc = doc;
        this.epub = epub;
        this.styleConverter = styleConverter;
        this.metadataNS.put("DC", "http://purl.org/dc/elements/1.1/");
        this.chapterSplitAllowed = true;
    }

    WordMLConverter(WordMLConverter parent, OPSResource chapterResource) {
        this.log = parent.log;
        this.resource = chapterResource;
        this.chapter = chapterResource.getDocument();
        this.doc = parent.doc;
        this.epub = parent.epub;
        this.styleConverter = new StyleConverter(parent.styleConverter);
        this.chapterSplitAllowed = false;
    }

    WordMLConverter(WordMLConverter parent, StyleConverter styleConverter) {
        this.log = parent.log;
        this.chapter = parent.chapter;
        this.doc = parent.doc;
        this.epub = parent.epub;
        this.styleConverter = styleConverter;
        this.chapterSplitAllowed = false;
    }

    Element getCurrentOPSContainer() {
        return ((NestingItem)this.nesting.peek()).opsElement;
    }

    NestingItem getOPSContainer(ParagraphElement wordElement, boolean forceNew) {
        ParagraphElement wp = wordElement;
        ParagraphProperties pp = wp.getParagraphProperties();
        int level = -1;
        int numId = -1;
        NumberingLabel label = pp.getNumberingLabel();
        if (label != null) {
            level = label.getLevel();
            numId = label.getNumId();
        }
        NestingItem item = (NestingItem)this.nesting.peek();
        if (numId < 0 || this.lastNumId >= 0 && this.lastNumId != numId) {
            while (item.listLevel >= 0) {
                this.nesting.pop();
                item = (NestingItem)this.nesting.peek();
            }
        }
        if (numId <= 0 || !this.listElements.contains(wordElement)) {
            boolean createDiv = true;
            if (item.opsElement.getElementName().equals("div")) {
                if (forceNew) {
                    this.nesting.pop();
                    item = (NestingItem)this.nesting.peek();
                } else {
                    createDiv = false;
                }
            }
            if (createDiv) {
                HTMLElement e = this.chapter.createElement("div");
                item.opsElement.add(e);
                NestingItem div = new NestingItem(e, -1);
                this.nesting.push(div);
                item = div;
            }
        } else {
            if (item.opsElement.getElementName().equals("div")) {
                this.nesting.pop();
                item = (NestingItem)this.nesting.peek();
            }
            this.lastNumId = numId;
            while (level > item.listLevel) {
                HTMLElement e;
                if (item.opsElement.getElementName().equals("ul")) {
                    e = this.chapter.createElement("li");
                    item.opsElement.add(e);
                    e.setClassName("nested");
                    NestingItem li = new NestingItem(e, item.listLevel);
                    this.nesting.push(li);
                    item = li;
                }
                e = this.chapter.createElement("ul");
                item.opsElement.add(e);
                NestingItem ul = new NestingItem(e, item.listLevel + 1);
                this.nesting.push(ul);
                item = ul;
            }
            while (level < item.listLevel || item.opsElement.getElementName().equals("li")) {
                this.nesting.pop();
                item = (NestingItem)this.nesting.peek();
            }
        }
        return item;
    }

    int pushOPSContainer(Element p) {
        int size = this.nesting.size();
        this.nesting.push(new NestingItem(p, -1));
        return size;
    }

    void restoreOPSContainer(int size) {
        this.nesting.setSize(size);
    }

    void useWordPageBreaks() {
        this.useWordPageBreaks = true;
    }

    void setFootnoteMap(Hashtable footnoteMap) {
        this.footnoteMap = footnoteMap;
    }

    Publication getPublication() {
        return this.epub;
    }

    private Resource getImageResource(PictureData data, String nameOverride, String mediaTypeOverride) {
        String src = data.getSrc();
        if (src == null) {
            return null;
        }
        String epubName = (String)this.convResources.get(src);
        if (epubName == null || nameOverride != null) {
            String mediaType;
            DataSource dataSource = this.wordResources.getDataSource(src);
            int index = src.lastIndexOf(47);
            String shortName = src.substring(index + 1);
            if (mediaTypeOverride != null) {
                mediaType = mediaTypeOverride;
            } else {
                mediaType = this.doc.getResourceMediaType(src);
                if (mediaType.equals("image/x-wmf")) {
                    WMFResourceWriter dw = new WMFResourceWriter();
                    GDISVGSurface svg = new GDISVGSurface(dw);
                    try {
                        WMFParser parser = new WMFParser(dataSource.getInputStream(), svg);
                        parser.readAll();
                    }
                    catch (IOException e) {
                        e.printStackTrace(this.log);
                        return null;
                    }
                    dataSource = new StringDataSource(svg.getSVG());
                    mediaType = "image/svg+xml";
                    shortName = String.valueOf(shortName) + ".svg";
                } else if (!mediaType.equals("application/octet-stream") || src.endsWith(".emf")) {
                    // empty if block
                }
            }
            epubName = nameOverride != null ? "OPS/" + nameOverride : mediaFolder + shortName;
            if (dataSource == null) {
                return null;
            }
            this.epub.createBitmapImageResource(epubName, mediaType, dataSource);
            if (nameOverride != null) {
                this.convResources.put(src, epubName);
            }
        }
        return this.epub.getResourceByName(epubName);
    }

    private void resetSpaceProcessing() {
        this.hadSpace = false;
    }

    private void treatAsSpace() {
        this.hadSpace = true;
    }

    private String processSpaces(String s) {
        int len = s.length();
        StringBuffer result = null;
        int last = 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == ' ') {
                if (this.hadSpace) {
                    if (result == null) {
                        result = new StringBuffer();
                    }
                    result.append(s.substring(last, i));
                    result.append('\u00a0');
                    last = i + 1;
                } else {
                    this.hadSpace = true;
                }
            } else {
                this.hadSpace = false;
            }
            ++i;
        }
        if (result != null) {
            result.append(s.substring(last));
            return result.toString();
        }
        return s;
    }

    void setImageWidth(Element img, String baseClassName, double widthPt, float emScale) {
        String className = this.styleConverter.getUniqueClassName(baseClassName, false);
        img.setClassName(className);
        SimpleSelector selector = this.styleConverter.stylesheet.getSimpleSelector(null, className);
        Rule rule = this.styleConverter.stylesheet.getRuleForSelector(selector);
        if (this.styleConverter.usingPX()) {
            rule.set("width", new CSSLength(widthPt, "px"));
        } else {
            double defaultFontSize = this.styleConverter.defaultFontSize;
            double widthEM = widthPt / ((double)emScale * defaultFontSize / 2.0);
            rule.set("width", new CSSLength(widthEM, "em"));
        }
        rule.set("max-width", "100%");
    }

    void parseAndInjectXML(StringBuffer xml) {
        try {
            XMLInjector injector = new XMLInjector();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(injector);
            reader.setEntityResolver(injector);
            InputSource source = new InputSource(new StringReader(xml.toString()));
            source.setSystemId("");
            reader.parse(source);
        }
        catch (Exception e) {
            e.printStackTrace(this.log);
        }
    }

    String getMagicStyleName(ParagraphProperties pp) {
        if (pp == null) {
            return null;
        }
        Style ps = pp.getParagraphStyle();
        if (ps == null) {
            return null;
        }
        String name = ps.getName();
        if (name == null) {
            return null;
        }
        String ln = name.toLowerCase();
        if (ln.startsWith("*epub")) {
            return ln.substring(5);
        }
        return null;
    }

    String getMagicStyleName(RunProperties rp) {
        if (rp == null) {
            return null;
        }
        Style rs = rp.getRunStyle();
        if (rs == null) {
            return null;
        }
        String name = rs.getName();
        if (name == null) {
            return null;
        }
        String ln = name.toLowerCase();
        if (ln.startsWith("*epub")) {
            return ln.substring(5);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean processEPUBCommand(String command, int depth) {
        String param;
        String cmd;
        if (!command.startsWith(".")) return true;
        int index = command.indexOf(32);
        if (index > 0) {
            cmd = command.substring(1, index);
            param = command.substring(index + 1).trim();
        } else {
            cmd = command.substring(1);
            param = "";
        }
        if (cmd.equals("chapter")) {
            String newChapterName = "OPS/" + param;
            if (!this.chapterNameWasSet) {
                this.epub.renameResource(this.resource, newChapterName);
                this.chapterNameWasSet = true;
                return true;
            }
            if (this.chapterSplitAllowed && depth <= 1) {
                this.resource = this.epub.createOPSResource(newChapterName);
                return false;
            }
            this.log.println("chapter split not allowed here");
            return true;
        }
        if (cmd.equals("columns")) {
            InlineStyleRule rule = new InlineStyleRule();
            rule.set("oeb-column-number", param);
            this.resource.getDocument().getBody().setStyle(rule);
            return true;
        }
        if (cmd.equals("pageMap")) {
            if (param.length() != 0 && !param.toLowerCase().startsWith("t")) {
                if (!param.equals("1")) return true;
            }
            this.epub.usePageMap();
            return true;
        }
        if (cmd.equals("translit")) {
            if (param.length() != 0 && !param.toLowerCase().startsWith("t") && !param.equals("1")) {
                this.epub.setTranslit(false);
                return true;
            }
            this.epub.setTranslit(true);
            return true;
        }
        if (cmd.equals("fontMangling")) {
            if (param.toLowerCase().equals("adobe")) {
                this.epub.useAdobeFontMangling();
                return true;
            }
            this.epub.useIDPFFontMangling();
            return true;
        }
        if (cmd.equals("resource")) {
            StringTokenizer tok = new StringTokenizer(param);
            this.nextResourceName = tok.nextToken();
            if (tok.hasMoreTokens()) {
                this.nextResourceMediaType = tok.nextToken();
                return true;
            }
            this.nextResourceMediaType = null;
            return true;
        }
        if (!cmd.equals("page")) return true;
        Element parent = this.getCurrentOPSContainer();
        if (parent.content().hasNext()) {
            this.nextPageName = param;
            return true;
        }
        XRef xref = this.createOPSContainerXRefIfPossible();
        if (xref != null) {
            this.epub.getTOC().addPage(param, xref);
            return true;
        }
        this.epub.getTOC().addPage(param, parent.getSelfRef());
        return true;
    }

    XRef createOPSContainerXRefIfPossible() {
        int depth = this.nesting.size() - 1;
        Element lastGood = null;
        while (depth >= 0) {
            NestingItem item = (NestingItem)this.nesting.elementAt(depth--);
            Iterator content = item.opsElement.content();
            if (content.hasNext() && content.next() != null && content.hasNext()) break;
            lastGood = item.opsElement;
        }
        if (lastGood != null) {
            return lastGood.getSelfRef();
        }
        return null;
    }

    void processEPUBMetadata(String command) {
        if (command.startsWith(".")) {
            StringTokenizer tok = new StringTokenizer(command);
            int count = tok.countTokens();
            String cmd = tok.nextToken();
            if (cmd.equals(".namespace")) {
                if (count == 3) {
                    String prefix = tok.nextToken();
                    String ns = tok.nextToken();
                    this.metadataNS.put(prefix, ns);
                }
            } else if (cmd.equals(".includeWordMetadata")) {
                this.includeWordMetadata = true;
            }
        } else {
            int index = command.indexOf(32);
            if (index > 0) {
                String prefix;
                String ns;
                String name = command.substring(0, index);
                String value = command.substring(index + 1);
                index = name.indexOf(46);
                if (index > 0 && (ns = (String)this.metadataNS.get(prefix = name.substring(0, index))) != null) {
                    name = name.substring(index + 1);
                    this.epub.addMetadata(ns, name, value);
                    return;
                }
                this.epub.addMetadata(null, name, value);
            }
        }
    }

    void flushMagic() {
        if (this.injectAcc.length() > 0) {
            this.parseAndInjectXML(this.injectAcc);
            this.injectAcc.delete(0, this.injectAcc.length());
        }
        if (this.styleAcc.length() > 0) {
            try {
                this.styleConverter.stylesheet.addDirectStyles(new StringReader(this.styleAcc.toString()));
            }
            catch (Exception e) {
                e.printStackTrace(this.log);
            }
            this.styleAcc.delete(0, this.styleAcc.length());
        }
    }

    boolean possiblyAddResource(com.adobe.dp.office.word.Element we) {
        if (this.nextResourceName == null) {
            return false;
        }
        Iterator it = we.content();
        while (it.hasNext()) {
            com.adobe.dp.office.word.Element ce;
            Object child = it.next();
            if (child instanceof DrawingElement) {
                DrawingElement wd = (DrawingElement)child;
                PictureData picture = wd.getPictureData();
                if (picture == null) continue;
                try {
                    this.getImageResource(picture, this.nextResourceName, this.nextResourceMediaType);
                    this.nextResourceName = null;
                    this.nextResourceMediaType = null;
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace(this.log);
                    continue;
                }
            }
            if (!(child instanceof com.adobe.dp.office.word.Element) || !this.possiblyAddResource(ce = (com.adobe.dp.office.word.Element)child)) continue;
            return true;
        }
        return false;
    }

    ParagraphProperties getNonMagicParagraphProperties(com.adobe.dp.office.word.Element we) {
        ParagraphProperties pp;
        if (we instanceof ParagraphElement && this.getMagicStyleName(pp = ((ParagraphElement)we).getParagraphProperties()) == null) {
            return pp;
        }
        return null;
    }

    boolean getNeigborCode(ParagraphProperties p1, ParagraphProperties p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return p1.sameStyle(p2);
    }

    boolean appendConvertedElement(com.adobe.dp.office.word.Element we, com.adobe.dp.office.word.Element prev, com.adobe.dp.office.word.Element next, float emScale, int depth) {
        HTMLElement conv = null;
        boolean addToParent = true;
        boolean resetSpaceProcessing = false;
        boolean ensureContent = false;
        if (we instanceof ParagraphElement) {
            ParagraphElement wp = (ParagraphElement)we;
            ParagraphProperties pp = wp.getParagraphProperties();
            String className = null;
            String elementName = null;
            String epubStyle = this.getMagicStyleName(pp);
            ensureContent = true;
            if (epubStyle != null) {
                if (epubStyle.startsWith("*command")) {
                    if (this.possiblyAddResource(wp)) {
                        return true;
                    }
                    return this.processEPUBCommand(we.getTextContent(), depth);
                }
                if (epubStyle.startsWith("*style")) {
                    this.styleAcc.append(String.valueOf(we.getTextContent()) + "\n");
                    return true;
                }
                if (epubStyle.startsWith("*inject")) {
                    this.injectAcc.append(String.valueOf(we.getTextContent()) + "\n");
                    return true;
                }
                if (epubStyle.equals("*metadata")) {
                    if (!this.hasEpubMetadata) {
                        this.includeWordMetadata = false;
                        this.hasEpubMetadata = true;
                    }
                    this.processEPUBMetadata(we.getTextContent());
                    return true;
                }
                this.flushMagic();
                if (epubStyle.startsWith("-")) {
                    int index = epubStyle.indexOf(46);
                    if (index < 0) {
                        elementName = epubStyle.substring(1);
                        epubStyle = "";
                    } else {
                        elementName = epubStyle.substring(1, index);
                        epubStyle = epubStyle.substring(index);
                    }
                } else {
                    elementName = "p";
                }
                if (epubStyle.startsWith(".")) {
                    className = epubStyle.substring(1);
                }
            } else {
                this.flushMagic();
                ParagraphProperties prevpp = this.getNonMagicParagraphProperties(prev);
                ParagraphProperties nextpp = this.getNonMagicParagraphProperties(next);
                boolean nc1 = this.getNeigborCode(prevpp, pp);
                boolean nc2 = this.getNeigborCode(pp, nextpp);
                StylingResult result = this.styleConverter.styleElement(pp, this.listElements.contains(we), emScale, nc1, nc2);
                this.styleConverter.finalizeElementRule(result);
                NestingItem containerItem = this.getOPSContainer(wp, !nc1);
                if (!nc1 && result.containerRule != null) {
                    containerItem.topMargin = result.containerRule.get("margin-top");
                }
                if (!nc2) {
                    if (containerItem.topMargin != null) {
                        if (result.containerRule == null) {
                            result.containerRule = new PrototypeRule();
                        }
                        result.containerRule.set("margin-top", containerItem.topMargin);
                    }
                    this.styleConverter.finalizeContainerRule(result);
                    if (containerItem.opsElement != null) {
                        containerItem.opsElement.setClassName(result.containerClassName);
                    }
                }
                if ((elementName = result.elementName) == null) {
                    elementName = "p";
                }
                className = result.elementClassName;
                NumberingLabel label = pp.getNumberingLabel();
                if (label != null && !this.styleConverter.convertLabelToProperty(label, null)) {
                    conv = this.chapter.createElement(elementName);
                    if (className != null) {
                        conv.setClassName(className);
                    }
                    resetSpaceProcessing = true;
                    SimpleSelector paragraphClassSelector = this.styleConverter.stylesheet.getSimpleSelector(null, className);
                    Rule pr = this.styleConverter.stylesheet.findRuleForSelector(paragraphClassSelector);
                    StylingResult labelRes = this.styleConverter.getLabelRule(pr, label, emScale * this.emScaleMultiplier(conv));
                    HTMLElement labelElement = this.chapter.createElement("span");
                    labelElement.setClassName(labelRes.elementClassName);
                    labelElement.add(String.valueOf(label.getText()) + " ");
                    conv.add(labelElement);
                }
            }
            if (conv == null && elementName != null) {
                conv = this.chapter.createElement(elementName);
                if (className != null) {
                    conv.setClassName(className);
                }
                resetSpaceProcessing = true;
            } else {
                this.treatAsSpace();
            }
        } else {
            com.adobe.dp.office.word.Element wf;
            this.flushMagic();
            if (we instanceof RunElement) {
                String elementName;
                RunElement wr = (RunElement)we;
                RunProperties rp = wr.getRunProperties();
                String epubStyle = this.getMagicStyleName(rp);
                String className = null;
                if (epubStyle != null) {
                    SimpleSelector selector;
                    if (epubStyle.startsWith("*command")) {
                        return this.processEPUBCommand(we.getTextContent(), depth);
                    }
                    if (epubStyle.startsWith("-")) {
                        int index = epubStyle.indexOf(46);
                        if (index < 0) {
                            elementName = epubStyle.substring(1);
                            epubStyle = "";
                        } else {
                            elementName = epubStyle.substring(1, index);
                            epubStyle = epubStyle.substring(index);
                        }
                    } else {
                        elementName = "span";
                    }
                    if (epubStyle.startsWith(".")) {
                        className = epubStyle.substring(1);
                    }
                    if ((selector = this.styleConverter.stylesheet.getSimpleSelector(elementName, className)) != null) {
                        if (selector != null) {
                            elementName = selector.getElementName();
                            if (elementName == null) {
                                elementName = "span";
                            }
                            className = selector.getClassName();
                        } else {
                            elementName = "span";
                        }
                    }
                } else {
                    StylingResult result = this.styleConverter.styleElement(rp, false, emScale, false, false);
                    this.styleConverter.finalizeElementRule(result);
                    elementName = result.elementName;
                    className = result.elementClassName;
                    if (elementName == null && className != null) {
                        elementName = "span";
                    }
                }
                if (elementName != null) {
                    conv = this.chapter.createElement(elementName);
                    if (className != null) {
                        conv.setClassName(className);
                    }
                }
            } else if (we instanceof com.adobe.dp.office.word.HyperlinkElement) {
                com.adobe.dp.office.word.HyperlinkElement wa = (com.adobe.dp.office.word.HyperlinkElement)we;
                HyperlinkElement a = this.chapter.createHyperlinkElement("a");
                String href = wa.getHRef();
                if (href != null) {
                    a.setExternalHRef(href);
                }
                conv = a;
            } else if (we instanceof FootnoteReferenceElement) {
                XRef xref;
                wf = (FootnoteReferenceElement)we;
                String fid = ((FootnoteReferenceElement)wf).getID();
                if (fid != null && (xref = (XRef)this.footnoteMap.get(fid)) != null) {
                    HyperlinkElement a = this.chapter.createHyperlinkElement("a");
                    a.setClassName("footnote-ref");
                    a.setXRef(xref);
                    a.add("[" + fid + "]");
                    conv = a;
                }
                resetSpaceProcessing = true;
            } else if (we instanceof FootnoteElement) {
                wf = (FootnoteElement)we;
                String fid = ((FootnoteElement)wf).getID();
                if (fid != null) {
                    conv = this.chapter.createElement("div");
                    this.footnoteMap.put(fid, conv.getSelfRef());
                    conv.setClassName("footnote");
                    HTMLElement ft = this.chapter.createElement("h6");
                    ft.setClassName("footnote-title");
                    conv.add(ft);
                    ft.add(fid);
                }
                resetSpaceProcessing = true;
            } else if (we instanceof LastRenderedPageBreakElement) {
                if (this.useWordPageBreaks) {
                    XRef xref = this.createOPSContainerXRefIfPossible();
                    if (xref != null) {
                        conv = this.chapter.createElement("span");
                        xref = conv.getSelfRef();
                    }
                    this.epub.getTOC().addPage(null, xref);
                }
            } else if (we instanceof TableElement) {
                TableElement wt = (TableElement)we;
                TableProperties tp = wt.getTableProperties();
                conv = this.chapter.createElement("table");
                StylingResult result = this.styleConverter.convertTableStylingRule(tp, emScale);
                if (!result.elementRule.isEmpty() || result.tableCellRule != null) {
                    String className = this.styleConverter.getUniqueClassName("tb", false);
                    conv.setClassName(className);
                    if (!result.elementRule.isEmpty()) {
                        this.styleConverter.stylesheet.createRuleForPrototype("table", className, result.elementRule);
                    }
                    if (result.tableCellRule != null) {
                        this.styleConverter.stylesheet.createRuleForPrototype("td", className, result.tableCellRule);
                    }
                }
                resetSpaceProcessing = true;
            } else if (we instanceof TableRowElement) {
                conv = this.chapter.createElement("tr");
                conv.setClassName(this.getCurrentOPSContainer().getClassName());
                resetSpaceProcessing = true;
            } else if (we instanceof TableCellElement) {
                conv = this.chapter.createElement("td");
                conv.setClassName(this.getCurrentOPSContainer().getClassName());
                resetSpaceProcessing = true;
            } else {
                if (we instanceof TextElement) {
                    Element parent = this.getCurrentOPSContainer();
                    parent.add(this.processSpaces(((TextElement)we).getText()));
                    return true;
                }
                if (we instanceof TabElement) {
                    Element parent = this.getCurrentOPSContainer();
                    parent.add(this.processSpaces("\t"));
                    return true;
                }
                if (we instanceof BRElement) {
                    conv = this.chapter.createElement("br");
                    resetSpaceProcessing = true;
                } else if (we instanceof DrawingElement) {
                    DrawingElement wd = (DrawingElement)we;
                    PictureData picture = wd.getPictureData();
                    if (picture != null) {
                        try {
                            Resource imageResource = this.getImageResource(picture, null, null);
                            if (imageResource != null) {
                                ImageElement img = this.chapter.createImageElement("img");
                                img.setImageResource(imageResource);
                                conv = img;
                                if (picture.getWidth() > 0.0 && picture.getHeight() > 0.0) {
                                    double widthPt = picture.getWidth();
                                    this.setImageWidth(img, "img", widthPt, emScale * this.emScaleMultiplier(conv));
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(this.log);
                        }
                    }
                    resetSpaceProcessing = true;
                } else {
                    if (we instanceof PictElement) {
                        String widthStr;
                        Hashtable style;
                        Iterator it = we.content();
                        VMLGroupElement group = null;
                        while (it.hasNext()) {
                            Object child = it.next();
                            if (!(child instanceof VMLGroupElement)) continue;
                            group = (VMLGroupElement)child;
                            break;
                        }
                        if (group != null && (style = group.getStyle()) != null && (widthStr = (String)style.get("width")) != null) {
                            float widthPt = VMLPathConverter.readCSSLength(widthStr, 0.0f);
                            boolean embed = false;
                            VMLConverter vmlConv = new VMLConverter(this, embed);
                            Element parent = this.getCurrentOPSContainer();
                            if (embed) {
                                SVGElement svg = this.chapter.createSVGElement("svg");
                                vmlConv.convertVML(this.resource, svg, group);
                                parent.add(svg);
                                this.setImageWidth(svg, "svg", widthPt, emScale);
                            } else {
                                String name = this.epub.makeUniqueResourceName("OPS/media/vml-embed.svg");
                                OPSResource svgResource = this.epub.createOPSResource(name, "image/svg+xml");
                                OPSDocument svgDoc = svgResource.getDocument();
                                SVGElement svg = (SVGElement)svgDoc.getBody();
                                vmlConv.convertVML(svgResource, svg, group);
                                ImageElement img = this.chapter.createImageElement("img");
                                parent.add(img);
                                img.setImageResource(svgResource);
                                this.setImageWidth(img, "img", widthPt, emScale);
                            }
                        }
                        return true;
                    }
                    if (we instanceof TXBXContentElement) {
                        conv = this.chapter.createElement("body");
                        conv.setClassName("embed");
                        resetSpaceProcessing = true;
                    } else if (!(we instanceof SmartTagElement)) {
                        return true;
                    }
                }
            }
        }
        if (conv != null) {
            if (this.nextPageName != null) {
                this.epub.getTOC().addPage(this.nextPageName, conv.getSelfRef());
                this.nextPageName = null;
            }
            if (addToParent) {
                Element parent = this.getCurrentOPSContainer();
                parent.add(conv);
            }
            emScale *= this.emScaleMultiplier(conv);
        }
        if (resetSpaceProcessing) {
            this.resetSpaceProcessing();
        }
        int cdepth = 0;
        if (conv != null) {
            cdepth = this.pushOPSContainer(conv);
        }
        this.addChildren(we, null, emScale, depth + 1);
        if (conv != null) {
            this.restoreOPSContainer(cdepth);
        }
        if (ensureContent && conv != null && !conv.content().hasNext()) {
            conv.add("\u00a0");
        }
        if (resetSpaceProcessing) {
            this.resetSpaceProcessing();
        }
        return true;
    }

    private float emScaleMultiplier(Element e) {
        double scale;
        CSSLength fs;
        Object fontSize = e.getCascadedProperty("font-size");
        if (fontSize != null && fontSize instanceof CSSLength && (fs = (CSSLength)fontSize).getUnit().equals("em") && (scale = fs.getValue()) > 0.0) {
            return (float)scale;
        }
        return 1.0f;
    }

    private com.adobe.dp.office.word.Element addChildren(com.adobe.dp.office.word.Element we, com.adobe.dp.office.word.Element skipToChild, float emScale, int depth) {
        Iterator children = we.content();
        if (skipToChild != null) {
            while (children.hasNext()) {
                if (children.next() == skipToChild) break;
            }
        }
        com.adobe.dp.office.word.Element prev = null;
        com.adobe.dp.office.word.Element curr = children.hasNext() ? (com.adobe.dp.office.word.Element)children.next() : null;
        com.adobe.dp.office.word.Element next = null;
        while (curr != null) {
            next = children.hasNext() ? (com.adobe.dp.office.word.Element)children.next() : null;
            if (!this.appendConvertedElement(curr, prev, next, emScale, depth)) {
                this.flushMagic();
                return curr;
            }
            prev = curr;
            curr = next;
        }
        this.flushMagic();
        return null;
    }

    void findLists(ContainerElement ce) {
        Iterator it = ce.content();
        while (it.hasNext()) {
            Object n = it.next();
            if (n instanceof ParagraphElement) {
                Style style;
                ParagraphElement pe = (ParagraphElement)n;
                ParagraphProperties pp = pe.getParagraphProperties();
                if (pp == null || (style = pp.getParagraphStyle()) == null || style.getStyleId().startsWith("Heading") || style.getStyleId().startsWith("heading") || pp.getNumberingLabel() == null) continue;
                this.listElements.add(pe);
                continue;
            }
            if (!(n instanceof ContainerElement)) continue;
            this.findLists((ContainerElement)n);
        }
    }

    void convert(BodyElement wbody, OPSResource ops, boolean addToSpine) {
        StyleResource global = (StyleResource)this.epub.getResourceByName("OPS/global.css");
        StyleResource styles = (StyleResource)this.epub.getResourceByName("OPS/style.css");
        this.resource = ops;
        com.adobe.dp.office.word.Element child = null;
        do {
            this.chapter = this.resource.getDocument();
            this.chapter.addStyleResource(global);
            this.chapter.addStyleResource(styles);
            if (addToSpine) {
                this.epub.addToSpine(this.resource);
            }
            Element body = this.chapter.getBody();
            body.setClassName("primary");
            int depth = this.pushOPSContainer(body);
            child = this.addChildren(wbody, child, 1.0f, 1);
            this.restoreOPSContainer(depth);
        } while (child != null);
    }

    void setWordResources(ContainerSource source) {
        this.wordResources = source;
    }

    static class NestingItem {
        Element opsElement;
        int listLevel;
        Object topMargin;

        NestingItem(Element opsElement, int listLevel) {
            this.opsElement = opsElement;
            this.listLevel = listLevel;
        }
    }

    class WMFResourceWriter
    implements ResourceWriter {
        WMFResourceWriter() {
        }

        public StreamAndName createResource(String base, String suffix, boolean doNotCompress) throws IOException {
            String name = "OPS/media/wmf-" + base + suffix;
            name = WordMLConverter.this.epub.makeUniqueResourceName(name);
            BufferedDataSource dataSource = new BufferedDataSource();
            WordMLConverter.this.epub.createBitmapImageResource(name, "image/png", dataSource);
            return new StreamAndName(name.substring(WordMLConverter.mediaFolder.length()), dataSource.getOutputStream());
        }
    }

    class XMLInjector
    extends DefaultHandler {
        Stack nesting = new Stack();

        XMLInjector() {
            this.nesting.push(WordMLConverter.this.getCurrentOPSContainer());
        }

        Element parent() {
            return (Element)this.nesting.lastElement();
        }

        public void characters(char[] chars, int index, int len) throws SAXException {
            this.parent().add(new String(chars, index, len));
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.nesting.pop();
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String style;
            String className;
            String id;
            Element e = null;
            if (uri == null || uri.equals("") || uri.equals("http://www.w3.org/1999/xhtml")) {
                if (localName.equals("th") || localName.equals("td")) {
                    String align = attrs.getValue("align");
                    String colspanStr = attrs.getValue("colspan");
                    int colspan = 1;
                    if (colspanStr != null) {
                        try {
                            colspan = Integer.parseInt(colspanStr);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(WordMLConverter.this.log);
                        }
                    }
                    String rowspanStr = attrs.getValue("rowspan");
                    int rowspan = 1;
                    if (rowspanStr != null) {
                        try {
                            rowspan = Integer.parseInt(rowspanStr);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(WordMLConverter.this.log);
                        }
                    }
                    e = WordMLConverter.this.chapter.createTableCellElement(localName, align, colspan, rowspan);
                } else if (localName.equals("img")) {
                    ImageElement imageElement = WordMLConverter.this.chapter.createImageElement(localName);
                    String src = attrs.getValue("src");
                    if (src != null) {
                        Resource imageResource = WordMLConverter.this.epub.getResourceByName("OPS/" + src);
                        imageElement.setImageResource(imageResource);
                    }
                    e = imageElement;
                } else {
                    e = WordMLConverter.this.chapter.createElement(localName);
                }
            } else if (uri.equals("http://www.w3.org/2000/svg")) {
                SVGElement svg;
                if (localName.equals("image")) {
                    SVGImageElement svgImage = WordMLConverter.this.chapter.createSVGImageElement("image");
                    String href = attrs.getValue("http://www.w3.org/1999/xlink", "href");
                    if (href != null) {
                        Resource imageResource = WordMLConverter.this.epub.getResourceByName("OPS/" + href);
                        svgImage.setImageResource(imageResource);
                    }
                    svg = svgImage;
                } else {
                    svg = WordMLConverter.this.chapter.createSVGElement(localName);
                }
                int count = attrs.getLength();
                int i = 0;
                while (i < count) {
                    String attrNS = attrs.getURI(i);
                    String attrName = attrs.getLocalName(i);
                    if (!(attrNS.equals("") && (attrName.equals("id") || attrName.equals("style") || attrName.equals("class")) || localName.equals("image") && attrNS.equals("http://www.w3.org/1999/xlink") && attrName.equals("href"))) {
                        String attrValue = attrs.getValue(i);
                        svg.setAttribute(attrNS, attrName, attrValue);
                    }
                    ++i;
                }
                e = svg;
            }
            if (e == null) {
                e = WordMLConverter.this.chapter.createElement("span");
            }
            if ((id = attrs.getValue("id")) != null) {
                e.setId("id");
            }
            if ((className = attrs.getValue("class")) != null) {
                e.setClassName(className);
            }
            if ((style = attrs.getValue("style")) != null) {
                InlineStyleRule parsedStyle = new InlineStyleRule(style);
                e.setStyle(parsedStyle);
            }
            this.parent().add(e);
            this.nesting.push(e);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            throw new SAXException("External entities not allowed");
        }
    }
}

