/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.conv;

import com.adobe.dp.office.conv.PNGWriter;
import com.adobe.dp.office.conv.ResourceWriter;
import com.adobe.dp.office.conv.StreamAndName;
import com.adobe.dp.office.metafile.GDIBitmap;
import com.adobe.dp.office.metafile.GDIBrush;
import com.adobe.dp.office.metafile.GDIFont;
import com.adobe.dp.office.metafile.GDIMatrix;
import com.adobe.dp.office.metafile.GDIObject;
import com.adobe.dp.office.metafile.GDIPen;
import com.adobe.dp.office.metafile.GDISurface;

public class GDISVGSurface
extends GDISurface {
    StringBuffer body = new StringBuffer();
    StringBuffer defs = new StringBuffer();
    boolean initialized = false;
    GDIMatrix initialTransform;
    int mappingMode;
    int[] path = new int[10];
    int pathEnd = 0;
    ResourceWriter resourceWriter;

    public GDISVGSurface(ResourceWriter resourceWriter) {
        this.resourceWriter = resourceWriter;
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
    }

    private String makeRGB(int rgb) {
        return "#" + Integer.toHexString(rgb & 0xFFFFFF | 0xF000000).substring(1);
    }

    private void appendFillAndStrokeParam() {
        GDIBrush brush;
        GDIPen pen = this.getCurrentPen();
        if (pen != null && pen.getStyle() != 5) {
            this.body.append(" stroke=\"");
            this.body.append(this.makeRGB(pen.getColor()));
            this.body.append('\"');
            int width = pen.getWidth();
            if (width > 1) {
                this.body.append(" stroke-width=\"");
                this.body.append(width);
                this.body.append('\"');
            }
        }
        if ((brush = this.getCurrentBrush()) == null || brush.getStyle() == 1) {
            this.body.append(" fill=\"none\"");
        } else {
            this.body.append(" fill=\"");
            this.body.append(this.makeRGB(brush.getColor()));
            this.body.append('\"');
            if (this.getPolyFillMode() == 1) {
                this.body.append(" fill-rule=\"evenodd\"");
            }
        }
    }

    private void captureHeader() {
        if (this.initialized) {
            return;
        }
        this.initialTransform = this.getViewportMatrix();
        this.initialized = true;
    }

    private void ensurePoints(int count) {
        if (this.path.length < this.pathEnd + 3 * count) {
            int[] newPath = new int[2 * this.pathEnd + 3 * count];
            System.arraycopy(this.path, 0, newPath, 0, this.pathEnd);
            this.path = newPath;
        }
    }

    private void endPathIfAny() {
        if (this.pathEnd == 0) {
            return;
        }
        this.body.append("<path d=\"");
        int i = 0;
        while (i < this.pathEnd) {
            int command = this.path[i++];
            this.body.append((char)command);
            switch (command) {
                case 76: 
                case 77: {
                    int x = this.path[i++];
                    int y = this.path[i++];
                    this.body.append(x);
                    if (y >= 0) {
                        this.body.append(' ');
                    }
                    this.body.append(y);
                }
            }
        }
        this.body.append('\"');
        this.appendFillAndStrokeParam();
        this.body.append("/>\r\n");
        this.pathEnd = 0;
    }

    public void selectObject(GDIObject obj) {
        this.captureHeader();
        this.endPathIfAny();
        super.selectObject(obj);
    }

    public void extTextOut(int x, int y, String text, int flags, int[] clipRect, int[] adj) {
        this.captureHeader();
        this.endPathIfAny();
        GDIFont font = this.getCurrentFont();
        if (font != null) {
            int fontSize = font.getHeight();
            if (fontSize < 0) {
                fontSize = -fontSize;
            }
            int textAlign = this.getTextAlign();
            int color = this.getTextColor();
            this.body.append("<text x=\"");
            this.body.append(x);
            this.body.append("\" y=\"");
            this.body.append(y);
            switch (textAlign & 6) {
                case 6: {
                    this.body.append("\" text-anchor=\"middle");
                    break;
                }
                case 4: {
                    this.body.append("\" text-anchor=\"end");
                }
            }
            this.body.append("\" fill=\"");
            this.body.append(this.makeRGB(color));
            this.body.append("\" font-family=\"'");
            this.body.append(font.getName());
            this.body.append("'\" font-size=\"");
            this.body.append(fontSize);
            this.body.append('\"');
            int weight = font.getWeight();
            if (weight % 100 == 0) {
                this.body.append(" font-weight=\"");
                this.body.append(weight);
                this.body.append('\"');
            }
            if (font.isItalic()) {
                this.body.append(" font-style=\"italic\"");
            }
            if (font.isStrikeout() || font.isUnderline()) {
                this.body.append(" text-decoration=\"");
                if (font.isUnderline()) {
                    this.body.append("underline");
                    if (font.isStrikeout()) {
                        this.body.append(',');
                    }
                }
                if (font.isStrikeout()) {
                    this.body.append("line-through");
                }
                this.body.append('\"');
            }
            this.body.append('>');
            this.body.append(text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
            this.body.append("</text>\r\n");
        }
    }

    public void lineTo(int x, int y) {
        this.captureHeader();
        this.ensurePoints(1);
        this.path[this.pathEnd++] = 76;
        this.path[this.pathEnd++] = x;
        this.path[this.pathEnd++] = y;
    }

    public void moveTo(int x, int y) {
        this.captureHeader();
        this.ensurePoints(1);
        this.path[this.pathEnd++] = 77;
        this.path[this.pathEnd++] = x;
        this.path[this.pathEnd++] = y;
    }

    public void closePath() {
        this.captureHeader();
        this.ensurePoints(1);
        this.path[this.pathEnd++] = 90;
    }

    private void playPoly(int[] points, int offset, int len) {
        this.ensurePoints(len / 2);
        int i = 0;
        while (i < len) {
            this.path[this.pathEnd++] = i == 0 ? 77 : 76;
            this.path[this.pathEnd++] = points[offset + i];
            this.path[this.pathEnd++] = points[offset + i + 1];
            i += 2;
        }
    }

    public void polygon(int[] points, int offset, int len) {
        this.captureHeader();
        this.endPathIfAny();
        this.playPoly(points, offset, len);
        this.closePath();
        this.endPathIfAny();
    }

    public void polyPolygon(int[] lens, int[] points) {
        this.captureHeader();
        this.endPathIfAny();
        int offset = 0;
        int i = 0;
        while (i < lens.length) {
            int len = lens[i] * 2;
            this.playPoly(points, offset, len);
            this.closePath();
            offset += len;
            ++i;
        }
        this.endPathIfAny();
    }

    public void polyline(int[] points, int offset, int len) {
        this.captureHeader();
        this.endPathIfAny();
        this.ensurePoints(len / 2);
        int i = 0;
        while (i < len) {
            this.path[this.pathEnd++] = i == 0 ? 77 : 76;
            this.path[this.pathEnd++] = points[offset + i];
            this.path[this.pathEnd++] = points[offset + i + 1];
            i += 2;
        }
        this.endPathIfAny();
    }

    public void rectangle(int x1, int y1, int x2, int y2) {
        int tmp;
        this.captureHeader();
        this.endPathIfAny();
        if (x2 < x1) {
            tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        if (y2 < y1) {
            tmp = y2;
            y2 = y1;
            y1 = tmp;
        }
        this.body.append("<rect x=\"");
        this.body.append(x1);
        this.body.append("\" y=\"");
        this.body.append(y1);
        this.body.append("\" width=\"");
        this.body.append(x2 - x1);
        this.body.append("\" height=\"");
        this.body.append(y2 - y1);
        this.body.append('\"');
        this.appendFillAndStrokeParam();
        this.body.append("/>\r\n");
    }

    public void ellipse(int x1, int y1, int x2, int y2) {
        this.captureHeader();
        this.endPathIfAny();
        this.body.append("<ellipse cx=\"");
        this.body.append((double)(x1 + x2) / 2.0);
        this.body.append("\" cy=\"");
        this.body.append((double)(y1 + y2) / 2.0);
        this.body.append("\" rx=\"");
        this.body.append(Math.abs((double)(x2 - x1) / 2.0));
        this.body.append("\" ry=\"");
        this.body.append(Math.abs((double)(y2 - y1) / 2.0));
        this.body.append('\"');
        this.appendFillAndStrokeParam();
        this.body.append("/>\r\n");
    }

    public void stretchDIB(GDIBitmap bitmap, int destX, int destY, int destWidth, int destHeight, int srcX, int srcY, int srcWidth, int srcHeight) {
        if (this.resourceWriter != null) {
            try {
                StreamAndName image = this.resourceWriter.createResource("image", ".png", true);
                PNGWriter writer = new PNGWriter(image.stream, bitmap.getWidth(), bitmap.getHeight(), false);
                bitmap.saveAsPNG(writer);
                writer.close();
                boolean flipX = destWidth < 0;
                boolean flipY = destHeight < 0;
                int width = flipX ? -destWidth : destWidth;
                int height = flipY ? -destHeight : destHeight;
                this.body.append("<image transform=\"matrix(");
                this.body.append(flipX ? -1 : 1);
                this.body.append(" 0 0 ");
                this.body.append(flipY ? -1 : 1);
                this.body.append(" ");
                this.body.append(destX);
                this.body.append(" ");
                this.body.append(destY);
                this.body.append(")\" width=\"");
                this.body.append(width);
                this.body.append("\" height=\"");
                this.body.append(height);
                this.body.append("\" xlink:href=\"");
                this.body.append(image.name);
                this.body.append("\"/>\r\n");
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    public String getSVG() {
        boolean flipY;
        this.captureHeader();
        StringBuffer total = new StringBuffer();
        total.append("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
        int wb = this.getBoundsRight() - this.getBoundsLeft();
        int hb = this.getBoundsBottom() - this.getBoundsTop();
        double wv = (double)wb / Math.abs(this.initialTransform.a);
        double hv = (double)hb / Math.abs(this.initialTransform.d);
        double xv = -this.initialTransform.x / this.initialTransform.a;
        double yv = -this.initialTransform.y / this.initialTransform.d;
        boolean flipX = this.initialTransform.a < 0.0;
        boolean bl = flipY = this.initialTransform.d < 0.0;
        if (wb != 0 && hb != 0) {
            total.append(" viewBox=\"");
            if (flipX) {
                total.append('0');
            } else {
                total.append(xv);
                xv = 0.0;
            }
            total.append(' ');
            if (flipY) {
                total.append('0');
            } else {
                total.append(yv / this.initialTransform.d);
                yv = 0.0;
            }
            total.append(' ');
            total.append(wv);
            total.append(' ');
            total.append(hv);
            total.append("\" width=\"");
            total.append(wb);
            total.append("\" height=\"");
            total.append(hb);
            total.append('\"');
        }
        total.append(">\r\n");
        if (this.defs.length() > 0) {
            total.append("<defs>\r\n");
            total.append(this.defs);
            total.append("</defs>\r\n");
        }
        if (flipX || flipY || xv != 0.0 || yv != 0.0) {
            total.append("<g transform=\"matrix(");
            total.append(flipX ? "-1" : "1");
            total.append(" 0 0 ");
            total.append(flipY ? "-1" : "1");
            total.append(' ');
            total.append(xv);
            total.append(' ');
            total.append(yv);
            total.append(")\">\r\n");
            total.append(this.body);
            total.append("</g>\r\n");
        } else {
            total.append(this.body);
        }
        total.append("</svg>\r\n");
        return total.toString();
    }
}

