/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.conv;

import com.adobe.dp.epub.io.ContainerSource;
import com.adobe.dp.epub.opf.NCXResource;
import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.otf.FontEmbeddingReport;
import com.adobe.dp.epub.style.CSSLength;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.office.conv.StyleConverter;
import com.adobe.dp.office.conv.StylingResult;
import com.adobe.dp.office.conv.WordMLConverter;
import com.adobe.dp.office.word.BodyElement;
import com.adobe.dp.office.word.MetadataItem;
import com.adobe.dp.office.word.RunProperties;
import com.adobe.dp.office.word.Style;
import com.adobe.dp.office.word.WordDocument;
import com.adobe.dp.otf.FontLocator;
import com.adobe.dp.xml.util.StringUtil;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class DOCXConverter {
    WordDocument doc;
    Publication epub;
    NCXResource toc;
    StyleResource styles;
    StyleResource global;
    StyleConverter styleConverter;
    Hashtable footnoteMap = new Hashtable();
    Hashtable convResources = new Hashtable();
    ContainerSource wordResources;
    FontLocator fontLocator;
    double defaultFontSize;
    PrintWriter log = new PrintWriter(new OutputStreamWriter(System.out));
    boolean useWordPageBreaks;
    String lang;

    public DOCXConverter(WordDocument doc, Publication epub) {
        RunProperties rp;
        this.doc = doc;
        this.epub = epub;
        this.global = epub.createStyleResource("OPS/global.css");
        Stylesheet globalStylesheet = this.global.getStylesheet();
        this.styles = epub.createStyleResource("OPS/style.css");
        Stylesheet stylesheet = this.styles.getStylesheet();
        this.styleConverter = new StyleConverter(stylesheet, false);
        this.toc = epub.getTOC();
        Style rs = doc.getDefaultParagraphStyle();
        if (rs != null && (rp = rs.getRunProperties()) != null) {
            this.lang = (String)rp.get("lang");
        }
        if ((rp = doc.getDocumentDefaultRunStyle().getRunProperties()) != null) {
            Object sz = rp.get("sz");
            if (sz instanceof Number) {
                this.defaultFontSize = ((Number)sz).doubleValue();
            }
            StylingResult res = this.styleConverter.styleElement(rp, false, 1.0f, false, false);
            SimpleSelector selector = stylesheet.getSimpleSelector("body", null);
            globalStylesheet.createRuleForPrototype(selector, res.elementRule);
            if (this.lang == null) {
                this.lang = (String)rp.get("lang");
            }
        }
        if (this.defaultFontSize < 1.0) {
            this.defaultFontSize = 20.0;
        }
        Rule bodyEmbedRule = globalStylesheet.getRuleForSelector(stylesheet.getSimpleSelector("body", "embed"));
        bodyEmbedRule.set("font-size", new CSSLength(this.defaultFontSize / 2.0, "px"));
        this.styleConverter.setDefaultFontSize(this.defaultFontSize);
        this.styleConverter.setDocumentDefaultParagraphStyle(doc.getDocumentDefaultParagraphStyle());
        Rule tableRule = globalStylesheet.getRuleForSelector(stylesheet.getSimpleSelector("table", null));
        tableRule.set("border-collapse", "collapse");
        tableRule.set("border-spacing", "0px");
        Rule pRule = globalStylesheet.getRuleForSelector(stylesheet.getSimpleSelector("p", null));
        pRule.set("margin-top", "0px");
        pRule.set("margin-bottom", "0px");
        Rule ulRule = globalStylesheet.getRuleForSelector(stylesheet.getSimpleSelector("ul", null));
        ulRule.set("padding-left", "0px");
        ulRule.set("margin", "0px");
        Rule nestedLiRule = globalStylesheet.getRuleForSelector(stylesheet.getSimpleSelector("li", "nested"));
        nestedLiRule.set("display", "block");
    }

    public void setFontLocator(FontLocator fontLocator) {
        this.fontLocator = fontLocator;
    }

    public void setLog(PrintWriter log) {
        this.log = log;
    }

    public void convert() {
        OPSResource footnotes = null;
        if (this.doc.getFootnotes() != null) {
            BodyElement fbody = this.doc.getFootnotes();
            footnotes = this.epub.createOPSResource("OPS/footnotes.xhtml");
            WordMLConverter footnoteConv = new WordMLConverter(this.doc, this.epub, this.styleConverter, this.log);
            footnoteConv.setFootnoteMap(this.footnoteMap);
            footnoteConv.setWordResources(this.wordResources);
            footnoteConv.convert(fbody, footnotes, false);
            if (this.footnoteMap.size() > 0) {
                Stylesheet ss = this.styles.getStylesheet();
                SimpleSelector selector = ss.getSimpleSelector(null, "footnote-ref");
                Rule rule = ss.getRuleForSelector(selector);
                rule.set("font-size", "0.7em");
                rule.set("vertical-align", "super");
                rule.set("line-height", "0.2");
                selector = ss.getSimpleSelector(null, "footnote-title");
                rule = ss.getRuleForSelector(selector);
                rule.set("margin", "0px");
                rule.set("padding", "1em 0px 0.5em 2em");
            } else {
                this.epub.removeResource(footnotes);
            }
        }
        BodyElement body = this.doc.getBody();
        WordMLConverter bodyConv = new WordMLConverter(this.doc, this.epub, this.styleConverter, this.log);
        bodyConv.setFootnoteMap(this.footnoteMap);
        bodyConv.setWordResources(this.wordResources);
        bodyConv.findLists(body);
        OPSResource ops = this.epub.createOPSResource("OPS/document.xhtml");
        if (this.useWordPageBreaks) {
            this.epub.getTOC().addPage(null, ops.getDocument().getRootXRef());
            bodyConv.useWordPageBreaks();
        }
        bodyConv.convert(body, ops, true);
        if (footnotes != null) {
            this.epub.addToSpine(footnotes);
        }
        if (bodyConv.includeWordMetadata) {
            Iterator metadata = this.doc.metadata();
            while (metadata.hasNext()) {
                MetadataItem item = (MetadataItem)metadata.next();
                this.epub.addMetadata(item.getNS(), item.getName(), item.getValue());
                if (!item.getNS().equals("http://purl.org/dc/terms/") || !item.getName().equals("modified")) continue;
                this.epub.addDCMetadata("date", item.getValue());
            }
        }
        if (this.lang != null && this.epub.getDCMetadata("language") == null) {
            this.epub.addDCMetadata("language", this.lang);
        }
        this.epub.addMetadata(null, "DOCX2EPUB.version", "0.5.0");
        this.epub.addMetadata(null, "DOCX2EPUB.conversionDate", StringUtil.dateToW3CDTF(new Date()));
        this.epub.generateTOCFromHeadings(5);
        this.epub.splitLargeChapters();
        this.log.flush();
    }

    public void useWordPageBreaks() {
        this.useWordPageBreaks = true;
    }

    public FontEmbeddingReport embedFonts() {
        if (this.fontLocator != null) {
            return this.epub.addFonts(this.global, this.fontLocator);
        }
        return this.epub.addFonts(this.global);
    }

    public void setWordResources(ContainerSource source) {
        this.wordResources = source;
    }
}

