/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.fb2.convert;

import com.adobe.dp.epub.conv.ConversionClient;
import com.adobe.dp.epub.conv.ConversionService;
import com.adobe.dp.epub.conv.GUIDriver;
import com.adobe.dp.epub.io.OCFContainerWriter;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.epub.util.ConversionTemplate;
import com.adobe.dp.epub.util.Translit;
import com.adobe.dp.fb2.FB2Document;
import com.adobe.dp.fb2.FB2TitleInfo;
import com.adobe.dp.fb2.convert.FB2Converter;
import com.adobe.dp.otf.ChainedFontLocator;
import com.adobe.dp.otf.DefaultFontLocator;
import com.adobe.dp.otf.FontLocator;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import javax.imageio.ImageIO;

public class FB2ConversionService
extends ConversionService {
    BufferedImage fb2icon;
    boolean embedFonts = true;
    boolean adobeMangling = true;
    boolean translit = true;
    static /* synthetic */ Class class$0;

    boolean getBooleanProperty(Properties prop, String name, boolean def) {
        String s = prop.getProperty(name);
        if (s == null) {
            return def;
        }
        return s.toLowerCase().startsWith("t");
    }

    public void setProperties(Properties prop) {
        this.embedFonts = this.getBooleanProperty(prop, "embedFonts", this.embedFonts);
        this.adobeMangling = this.getBooleanProperty(prop, "adobeMangling", this.adobeMangling);
        this.translit = this.getBooleanProperty(prop, "translit", this.translit);
    }

    public FB2ConversionService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.adobe.dp.fb2.convert.FB2ConversionService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream png = clazz.getResourceAsStream("fb2.png");
        try {
            this.fb2icon = ImageIO.read(png);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean canConvert(File src) {
        String name = src.getName().toLowerCase();
        return name.endsWith(".fb2") || name.endsWith("fb2.zip");
    }

    public boolean canUse(File src) {
        return false;
    }

    public File convert(File src, File[] aux, ConversionClient client, PrintWriter log) {
        try {
            FileInputStream fb2in = new FileInputStream(src);
            FB2Document doc = new FB2Document(fb2in);
            Publication epub = new Publication();
            epub.setTranslit(this.translit);
            if (this.adobeMangling) {
                epub.useAdobeFontMangling();
            } else {
                epub.useIDPFFontMangling();
            }
            ((InputStream)fb2in).close();
            FB2TitleInfo bookInfo = doc.getTitleInfo();
            String title = bookInfo == null ? null : bookInfo.getBookTitle();
            String fname = title == null ? "book" : Translit.translit(title).replace(' ', '_').replace('\t', '_').replace('\n', '_').replace('\r', '_').replace('/', '_').replace('\\', '_').replace('\"', '_');
            if (fname.length() == 0) {
                fname = "book";
            }
            File outFile = client.makeFile(String.valueOf(fname) + ".epub");
            FileOutputStream out = new FileOutputStream(outFile);
            OCFContainerWriter container = new OCFContainerWriter(out);
            FB2Converter conv = new FB2Converter();
            conv.setLog(log);
            FontLocator fontLocator = DefaultFontLocator.getInstance();
            if (aux != null && aux.length > 0) {
                ConversionTemplate template = new ConversionTemplate(aux);
                FontLocator customLocator = template.getFontLocator();
                fontLocator = new ChainedFontLocator(customLocator, fontLocator);
                Stylesheet stylesheet = template.getStylesheet();
                if (stylesheet != null) {
                    conv.setTemplate(stylesheet);
                }
            }
            conv.setFontLocator(fontLocator);
            conv.convert(doc, epub);
            if (this.embedFonts) {
                conv.embedFonts();
            }
            epub.serialize(container);
            return outFile;
        }
        catch (Exception e) {
            e.printStackTrace(log);
            return null;
        }
    }

    public Image getIcon(File src) {
        return this.fb2icon;
    }

    public static void main(String[] args) {
        GUIDriver.main(args);
    }
}

