/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.web.util;

import com.adobe.dp.otf.DefaultFontLocator;
import com.adobe.dp.otf.FontLocator;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class Initializer {
    static File home;
    static File epubgenHome;
    static File uploadDir;
    static File workDir;
    static File logDir;
    static DefaultFontLocator defaultFontLocator;

    static {
        try {
            home = new File("/home/soroto2");
            if (!home.isDirectory()) {
                home = new File(System.getProperty("user.home"));
            }
            epubgenHome = new File(home, "epubgen");
            epubgenHome.mkdirs();
            File fontDir = new File(epubgenHome, "defaultFonts");
            uploadDir = new File(epubgenHome, "upload");
            uploadDir.mkdir();
            workDir = new File(epubgenHome, "work");
            workDir.mkdir();
            logDir = new File(epubgenHome, "log");
            logDir.mkdir();
            RollingFileAppender appender = new RollingFileAppender();
            appender.setFile(new File(logDir, "epubconv.log").getAbsolutePath());
            appender.setBufferedIO(false);
            String pattern = "%d{DATE} %-5p [%c@%t]: %m%n";
            appender.setLayout((Layout)new PatternLayout(pattern));
            appender.setMaxFileSize("1Mb");
            appender.setMaxBackupIndex(3);
            appender.activateOptions();
            BasicConfigurator.configure((Appender)appender);
            String[] dirs = new String[]{fontDir.getAbsolutePath()};
            defaultFontLocator = new DefaultFontLocator(dirs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() {
    }

    public static File getEPubGenHome() {
        return epubgenHome;
    }

    public static File getWorkDir() {
        return workDir;
    }

    public static File getUploadDir() {
        return uploadDir;
    }

    public static FontLocator getDefaultFontLocator() {
        return defaultFontLocator;
    }
}

