/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.web.servlet;

import com.adobe.dp.epub.otf.FontEmbeddingReport;
import com.adobe.dp.epub.util.Base64;
import com.adobe.dp.epub.util.ConversionTemplate;
import com.adobe.dp.epub.web.font.FontCookieSet;
import com.adobe.dp.epub.web.font.SharedFontSet;
import com.adobe.dp.otf.FontProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class FontsServlet
extends HttpServlet {
    public static final long serialVersionUID = 0L;
    static Logger logger;
    static File home;
    static HashSet activeStreams;
    static ConversionTemplate sharedTemplate;
    static String css;
    static final int S_NO_FONTS = 0;
    static final int S_INSTALLED = 1;
    static final int S_ADD = 2;
    static final int S_TITLE = 3;
    static final int S_BACK = 4;
    static final int S_REPORT_TITLE = 5;
    static final int S_REPORT_NO_EMBEDDED = 6;
    static final int S_REPORT_EMBEDDED = 7;
    static final int S_REPORT_PROHIBITED = 8;
    static final int S_REPORT_MISSING = 9;
    static /* synthetic */ Class class$0;

    static {
        activeStreams = new HashSet();
        css = "";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.adobe.dp.epub.web.servlet.FontsServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        logger.setLevel(Level.ALL);
        logger.trace((Object)"servlet loaded");
        try {
            int len;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.adobe.dp.epub.web.servlet.FontsServlet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream in = clazz2.getResourceAsStream("fonts.css");
            InputStreamReader r = new InputStreamReader(in, "UTF-8");
            StringBuffer sb = new StringBuffer();
            char[] buf = new char[128];
            while ((len = r.read(buf)) > 0) {
                sb.append(buf, 0, len);
            }
            css = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getString(int code, String lang) {
        if (lang != null && lang.equals("ru")) {
            switch (code) {
                case 0: {
                    return "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u0448\u0440\u0438\u0444\u0442\u044b \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b";
                }
                case 1: {
                    return "\u0428\u0440\u0438\u0444\u0442\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435:";
                }
                case 2: {
                    return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0448\u0440\u0438\u0444\u0442\u044b:";
                }
                case 3: {
                    return "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u043c\u0438 \u0448\u0440\u0438\u0444\u0442\u0430\u043c\u0438";
                }
                case 4: {
                    return "\u041d\u0430\u0437\u0430\u0434";
                }
                case 5: {
                    return "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0448\u0440\u0438\u0444\u0442\u0430\u0445";
                }
                case 6: {
                    return "\u0412\u043d\u0435\u0434\u0440\u0451\u043d\u043d\u044b\u0445 \u0448\u0440\u0438\u0444\u0442\u043e\u0432 \u043d\u0435\u0442";
                }
                case 7: {
                    return "\u0428\u0440\u0438\u0444\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u0443\u0434\u0443\u0442 \u0432\u043d\u0435\u0434\u0440\u0435\u043d\u044b \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442";
                }
                case 8: {
                    return "\u0428\u0440\u0438\u0444\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b \u043a \u0432\u043d\u0435\u0434\u0440\u0435\u043d\u0438\u044e";
                }
                case 9: {
                    return "\u0428\u0440\u0438\u0444\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u0431\u044b\u043b\u0438 \u043d\u0430\u0439\u0434\u0435\u043d\u044b";
                }
            }
        }
        switch (code) {
            case 0: {
                return "No custom fonts installed";
            }
            case 1: {
                return "Currently installed fonts:";
            }
            case 2: {
                return "Install custom fonts:";
            }
            case 3: {
                return "Custom Font Management";
            }
            case 4: {
                return "Back";
            }
            case 5: {
                return "Font Usage Report";
            }
            case 6: {
                return "No fonts embedded";
            }
            case 7: {
                return "Fonts that will be embedded";
            }
            case 8: {
                return "Fonts which cannot be embedded";
            }
            case 9: {
                return "Missing fonts (not embedded)";
            }
        }
        return "";
    }

    private String addFont(FileItem item) throws Exception {
        int len;
        InputStream in = item.getInputStream();
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        byte[] buffer = new byte[4096];
        int size = 0;
        while ((len = in.read(buffer)) > 0) {
            sha1.update(buffer, 0, len);
            size += len;
        }
        in.close();
        if (size <= 100) {
            return null;
        }
        byte[] hash = sha1.digest();
        String sha1str = Base64.encodeBytes(hash).replace('/', '-');
        SharedFontSet fontSet = SharedFontSet.getInstance();
        if (fontSet.getFontProperties(sha1str) == null && !fontSet.addFont(sha1str, item.getInputStream())) {
            return null;
        }
        return sha1str;
    }

    private static String replace(String text, char c, String rep) {
        int k;
        if (text == null) {
            return "";
        }
        int i = text.indexOf(c);
        if (i < 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer(text.substring(0, i));
        ++i;
        while ((k = text.indexOf(c, i)) >= 0) {
            sb.append(rep);
            sb.append(text.substring(i, k));
            i = k + 1;
        }
        sb.append(rep);
        sb.append(text.substring(i));
        return sb.toString();
    }

    private static String escape(String text) {
        text = FontsServlet.replace(text, '&', "&amp;");
        text = FontsServlet.replace(text, '<', "&lt;");
        text = FontsServlet.replace(text, '>', "&gt;");
        text = FontsServlet.replace(text, '\"', "&quot;");
        return text;
    }

    private void writeFontList(HttpServletResponse resp, FontCookieSet cookieSet, String myPath, String ref, String lang) throws Exception {
        resp.setContentType("text/html");
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8"));
        Iterator hashes = cookieSet.hashes();
        Vector<FontInfo> props = new Vector<FontInfo>();
        SharedFontSet fontSet = SharedFontSet.getInstance();
        while (hashes.hasNext()) {
            String sha1str = hashes.next().toString();
            FontProperties prop = fontSet.getFontProperties(sha1str);
            if (prop == null) continue;
            props.add(new FontInfo(sha1str, prop));
        }
        Collections.sort(props);
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
        out.println("http://www.w3.org/TR/html4/loose.dtd\">");
        out.println("<html>");
        out.println("<head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        out.println("<title>" + FontsServlet.getString(3, lang) + "</title>");
        out.println("<style type=\"text/css\">");
        out.println(css);
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        out.println("<div class=\"tool\">");
        if (ref != null && ref.length() > 0) {
            out.println("<p class=\"back\">");
            out.println("<a href=\"" + FontsServlet.escape(ref) + "\"><span>" + FontsServlet.getString(4, lang) + "</a>");
            out.println("</p>");
        }
        out.println("<h1>" + FontsServlet.getString(2, lang) + "</h1>");
        out.println("<form action=\"" + myPath + "\" method=\"post\" enctype=\"multipart/form-data\">");
        out.println("<input type=\"hidden\" name=\"ref\" value=\"" + FontsServlet.escape(ref) + "\"/>");
        out.println("<input type=\"hidden\" name=\"lang\" value=\"" + FontsServlet.escape(lang) + "\"/>");
        out.println("<input class=\"file\" type=\"file\" name=\"font01\"/><br/>");
        out.println("<input class=\"file\" type=\"file\" name=\"font02\"/><br/>");
        out.println("<input class=\"file\" type=\"file\" name=\"font03\"/><br/>");
        out.println("<input class=\"file\" type=\"file\" name=\"font04\"/><br/>");
        out.println("<input class=\"file\" type=\"file\" name=\"font05\"/><br/>");
        out.println("<input class=\"install\" type=\"submit\" value=\"Install\"/>");
        out.println("</form>");
        if (props.isEmpty()) {
            out.println("<h1 class=\"sep\">" + FontsServlet.getString(0, lang) + "</h1>");
        } else {
            out.println("<h1 class=\"sep\">" + FontsServlet.getString(1, lang) + "</h1>");
            Iterator fp = props.iterator();
            while (fp.hasNext()) {
                FontInfo fi = (FontInfo)fp.next();
                FontProperties f = fi.prop;
                out.println("<form action=\"" + myPath + "\" method=\"post\">");
                out.println("<input type=\"hidden\" name=\"remove\" value=\"" + fi.sha1str + "\"/>");
                out.println("<input type=\"hidden\" name=\"ref\" value=\"" + FontsServlet.escape(ref) + "\"/>");
                out.println("<input type=\"hidden\" name=\"lang\" value=\"" + FontsServlet.escape(lang) + "\"/>");
                out.println("<input class=\"delete\" type=\"image\" alt=\"Remove Font\" src=\"/images/del.png\"/>");
                out.println(String.valueOf(FontsServlet.escape(f.getFamilyName())) + " - " + f.getWeightString() + " " + f.getStyleString());
                out.println("</form>");
            }
        }
        out.println("</div>");
        out.println("</body>");
        out.println("</html>");
        out.flush();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String ref = req.getParameter("ref");
            String lang = req.getParameter("lang");
            String pathURI = req.getRequestURI();
            FontCookieSet cookieSet = new FontCookieSet(req);
            this.writeFontList(resp, cookieSet, pathURI, ref, lang);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String ref = "";
            String lang = "";
            String pathURI = req.getRequestURI();
            FontCookieSet cookieSet = new FontCookieSet(req);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                DiskFileItemFactory itemFac = new DiskFileItemFactory();
                File repositoryPath = new File(home, "upload");
                repositoryPath.mkdir();
                itemFac.setRepository(repositoryPath);
                ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)itemFac);
                List fileItemList = servletFileUpload.parseRequest(req);
                Iterator list = fileItemList.iterator();
                while (list.hasNext()) {
                    String sha1str;
                    FileItem item = (FileItem)list.next();
                    String paramName = item.getFieldName();
                    if (paramName.startsWith("font")) {
                        sha1str = this.addFont(item);
                        if (sha1str != null) {
                            cookieSet.addFontHash(sha1str);
                        }
                    } else if (paramName.startsWith("remove")) {
                        sha1str = item.getString();
                        cookieSet.removeFontHash(sha1str);
                    } else if (paramName.equals("ref")) {
                        ref = item.getString();
                    } else if (paramName.equals("lang")) {
                        lang = item.getString();
                    }
                    item.delete();
                }
            } else {
                Enumeration names = req.getParameterNames();
                while (names.hasMoreElements()) {
                    String paramName = (String)names.nextElement();
                    if (!paramName.startsWith("remove")) continue;
                    String sha1str = req.getParameter(paramName);
                    cookieSet.removeFontHash(sha1str);
                }
                ref = req.getParameter("ref");
                lang = req.getParameter("lang");
            }
            int index = pathURI.lastIndexOf(47);
            String cookiePath = pathURI.substring(0, index + 1);
            cookieSet.setCookies(resp, cookiePath, 315360000);
            this.writeFontList(resp, cookieSet, pathURI, ref, lang);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reportFonts(HttpServletResponse resp, FontEmbeddingReport report, String ref, String lang) throws IOException {
        FontProperties f;
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8"));
        Iterator used = report.usedFonts();
        Iterator missing = report.missingFonts();
        Iterator prohibited = report.prohibitedFonts();
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
        out.println("http://www.w3.org/TR/html4/loose.dtd\">");
        out.println("<html>");
        out.println("<head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        out.println("<title>" + FontsServlet.getString(5, lang) + "</title>");
        out.println("<style type=\"text/css\">");
        out.println(css);
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        out.println("<div class=\"tool\">");
        if (ref != null && ref.length() > 0) {
            out.println("<p class=\"back\">");
            out.println("<a href=\"" + FontsServlet.escape(ref) + "\"><span>" + FontsServlet.getString(4, lang) + "</a>");
            out.println("</p>");
        }
        if (!used.hasNext()) {
            out.println("<h1>" + FontsServlet.getString(6, lang) + "</h1>");
        } else {
            out.println("<h1>" + FontsServlet.getString(7, lang) + "</h1>");
            while (used.hasNext()) {
                f = (FontProperties)used.next();
                out.println("<p class=\"rfont\"><img src=\"/images/used.png\"/ alt=\"used font\"> " + FontsServlet.escape(f.getFamilyName()) + " - " + f.getWeightString() + " " + f.getStyleString() + "</p>");
            }
        }
        if (prohibited.hasNext()) {
            out.println("<h1 class=\"sep\">" + FontsServlet.getString(8, lang) + "</h1>");
            while (prohibited.hasNext()) {
                f = (FontProperties)prohibited.next();
                out.println("<p class=\"rfont\"><img src=\"/images/prohibit.png\"/ alt=\"prohibited font\"> " + FontsServlet.escape(f.getFamilyName()) + " - " + f.getWeightString() + " " + f.getStyleString() + "</p>");
            }
        }
        if (missing.hasNext()) {
            out.println("<h1 class=\"sep\">" + FontsServlet.getString(9, lang) + "</h1>");
            while (missing.hasNext()) {
                f = (FontProperties)missing.next();
                out.println("<p class=\"rfont\"><img src=\"/images/missing.png\"/ alt=\"missing font\"> " + FontsServlet.escape(f.getFamilyName()) + " - " + f.getWeightString() + " " + f.getStyleString() + "</p>");
            }
        }
        out.println("</div>");
        out.println("</body>");
        out.println("</html>");
        out.flush();
    }

    static class FontInfo
    implements Comparable {
        String sha1str;
        FontProperties prop;

        FontInfo(String sha1str, FontProperties prop) {
            this.sha1str = sha1str;
            this.prop = prop;
        }

        public int compareTo(Object o) {
            FontInfo f = (FontInfo)o;
            int c = this.prop.getFamilyName().compareTo(f.prop.getFamilyName());
            if (c != 0) {
                return c;
            }
            c = this.prop.getWeight() - f.prop.getWeight();
            if (c != 0) {
                return c;
            }
            return this.prop.getStyle() - f.prop.getStyle();
        }
    }
}

