/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.web.servlet;

import com.adobe.dp.epub.io.OCFContainerWriter;
import com.adobe.dp.epub.io.ZipContainerSource;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.util.Translit;
import com.adobe.dp.epub.web.font.FontCookieSet;
import com.adobe.dp.epub.web.font.SharedFontSet;
import com.adobe.dp.epub.web.servlet.FontsServlet;
import com.adobe.dp.epub.web.util.Initializer;
import com.adobe.dp.office.conv.DOCXConverter;
import com.adobe.dp.office.word.WordDocument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DOCXConverterServlet
extends HttpServlet {
    public static final long serialVersionUID = 0L;
    static Logger logger;
    static HashSet activeStreams;
    static /* synthetic */ Class class$0;

    static {
        activeStreams = new HashSet();
        Initializer.init();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.adobe.dp.epub.web.servlet.DOCXConverterServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        logger.setLevel(Level.ALL);
        logger.trace((Object)"servlet loaded");
    }

    void reportError(HttpServletResponse resp, String err) throws IOException {
        logger.error((Object)err);
        resp.setContentType("text/plain; charset=utf8");
        PrintWriter out = resp.getWriter();
        ((Writer)out).write(err);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(false, req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(true, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doRequest(boolean post, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block66: {
            block63: {
                streamIP = null;
                resources = null;
                DOCXConverterServlet.logger.trace((Object)("start " + req.getRemoteAddr()));
                docxin = null;
                templatein = null;
                book = null;
                template = null;
                translit = false;
                useurl = false;
                fontReport = false;
                docxurl = null;
                workPath = Initializer.getWorkDir();
                ref = null;
                lang = "en";
                workPath.mkdir();
                docxpath = null;
                if (post && ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                    itemFac = new DiskFileItemFactory();
                    repositoryPath = Initializer.getUploadDir();
                    repositoryPath.mkdir();
                    itemFac.setRepository(repositoryPath);
                    servletFileUpload = new ServletFileUpload((FileItemFactory)itemFac);
                    fileItemList = servletFileUpload.parseRequest(req);
                    list = fileItemList.iterator();
                    while (list.hasNext()) {
                        item = (FileItem)list.next();
                        t = item.getString();
                        paramName = item.getFieldName();
                        if (paramName.equals("file")) {
                            if (t.startsWith("http://")) {
                                docxurl = t;
                                continue;
                            }
                            if (t.length() <= 0) continue;
                            book = item;
                            continue;
                        }
                        if (paramName.equals("template")) {
                            if (t.length() <= 0) continue;
                            template = item;
                            continue;
                        }
                        if (paramName.equals("translit")) {
                            translit = t.equals("on") != false || t.equals("yes") != false;
                            continue;
                        }
                        if (paramName.equals("fontReport")) {
                            fontReport = t.equals("on") != false || t.equals("yes") != false;
                            continue;
                        }
                        if (paramName.equals("useurl")) {
                            useurl = t.equals("on") != false || t.equals("yes") != false;
                            continue;
                        }
                        if (paramName.equals("url")) {
                            if (t.length() <= 0) continue;
                            docxurl = t;
                            continue;
                        }
                        if (paramName.equals("ref")) {
                            ref = item.getString();
                            continue;
                        }
                        if (!paramName.equals("lang")) continue;
                        lang = item.getString();
                    }
                    if (!useurl && book != null) {
                        docxin = book.getInputStream();
                        docxpath = book.getName();
                    }
                    if (template != null) {
                        templatein = template.getInputStream();
                    }
                } else {
                    docxurl = req.getParameter("url");
                    t = req.getParameter("translit");
                    translit = t != null && (t.equals("on") != false || t.equals("yes") != false);
                    t = req.getParameter("fontReport");
                    fontReport = t != null && (t.equals("on") != false || t.equals("yes") != false);
                    ref = req.getParameter("ref");
                    lang = req.getParameter("lang");
                }
                if (docxin != null) ** GOTO lbl119
                if (docxurl != null) break block63;
                this.reportError(resp, "Invalid request: neither docx file nor URL is provided");
lbl78:
                // 3 sources

                while (true) {
                    if (resources != null) {
                        resources.close();
                    }
                    if (streamIP != null) {
                        var34_30 = DOCXConverterServlet.activeStreams;
                        synchronized (var34_30) {
                            DOCXConverterServlet.activeStreams.remove(streamIP);
                        }
                    }
                    DOCXConverterServlet.logger.trace((Object)"end");
                    return;
                }
            }
            try {
                block67: {
                    url = new URL(docxurl);
                    if (url.getProtocol().equals("http")) break block67;
                    this.reportError(resp, "Invalid request: docx URL protocol is not http");
                    ** GOTO lbl78
                }
                docxpath = url.getPath();
                host = url.getHost();
                ipaddr = InetAddress.getByName(host);
                ipstr = ipaddr.toString();
                list = DOCXConverterServlet.activeStreams;
                synchronized (list) {
                    if (!DOCXConverterServlet.activeStreams.contains(ipstr)) {
                        DOCXConverterServlet.activeStreams.add(ipstr);
                        streamIP = ipstr;
                    }
                }
                if (streamIP == null) {
                    this.reportError(resp, "Only a single connection to the server " + host + " is allowed");
                    ** continue;
                }
                DOCXConverterServlet.logger.info((Object)("downloading from " + docxurl));
                docxin = url.openStream();
lbl119:
                // 2 sources

                docxtmp = File.createTempFile("docx2epub", "docx", workPath);
                docxout = new FileOutputStream(docxtmp);
                buffer = new byte[8192];
                while ((len = docxin.read(buffer)) > 0) {
                    docxout.write(buffer, 0, len);
                }
                docxout.close();
                docxin.close();
                if (book != null) {
                    book.delete();
                }
                if (docxpath != null) {
                    if (docxpath.endsWith("/")) {
                        docxpath = docxpath.substring(0, docxpath.length() - 1);
                    }
                    if ((index = docxpath.lastIndexOf(47)) >= 0) {
                        docxpath = docxpath.substring(index + 1);
                    }
                    if ((index = docxpath.lastIndexOf(92)) >= 0) {
                        docxpath = docxpath.substring(index + 1);
                    }
                }
                doc = new WordDocument(docxtmp);
                epub = new Publication();
                epub.setTranslit(translit);
                epub.useAdobeFontMangling();
                conv = new DOCXConverter(doc, epub);
                if (templatein != null && template != null) {
                    template.delete();
                }
                fontLocator = Initializer.getDefaultFontLocator();
                customFontCookies = new FontCookieSet(req);
                sharedFontSet = SharedFontSet.getInstance();
                fontLocator = sharedFontSet.getFontLocator(customFontCookies, fontLocator);
                conv.setFontLocator(fontLocator);
                resources = new ZipContainerSource(docxtmp);
                conv.setWordResources(resources);
                conv.convert();
                report = conv.embedFonts();
                if (fontReport) {
                    FontsServlet.reportFonts(resp, report, ref, lang);
                } else {
                    title = epub.getDCMetadata("title");
                    if (title == null) {
                        if (docxpath != null) {
                            fname = docxpath;
                            if (fname.endsWith(".docx")) {
                                fname = fname.substring(0, fname.length() - 5);
                            }
                            epub.addDCMetadata("title", docxpath);
                        } else {
                            fname = "book";
                        }
                    } else {
                        fname = Translit.translit(title).replace(' ', '_').replace('\t', '_').replace('\n', '_').replace('\r', '_');
                    }
                    resp.setContentType("application/epub+zip");
                    resp.setHeader("Content-Disposition", "attachment; filename=" + fname + ".epub");
                    out = resp.getOutputStream();
                    container = new OCFContainerWriter((OutputStream)out);
                    epub.serialize(container);
                }
                resources.close();
                docxtmp.delete();
            }
            catch (Exception e) {
                DOCXConverterServlet.logger.error((Object)"error", (Throwable)e);
                this.reportError(resp, "Internal server error: " + e.toString());
                e.printStackTrace();
                if (resources != null) {
                    resources.close();
                }
                if (streamIP != null) {
                    var34_31 = DOCXConverterServlet.activeStreams;
                    synchronized (var34_31) {
                        DOCXConverterServlet.activeStreams.remove(streamIP);
                    }
                }
                DOCXConverterServlet.logger.trace((Object)"end");
            }
            catch (Throwable e) {
                block65: {
                    try {
                        DOCXConverterServlet.logger.fatal((Object)"error", e);
                        if (resources == null) break block65;
                    }
                    catch (Throwable var33_42) {
                        if (resources != null) {
                            resources.close();
                        }
                        if (streamIP != null) {
                            var34_33 = DOCXConverterServlet.activeStreams;
                            synchronized (var34_33) {
                                DOCXConverterServlet.activeStreams.remove(streamIP);
                            }
                        }
                        DOCXConverterServlet.logger.trace((Object)"end");
                        throw var33_42;
                    }
                    resources.close();
                }
                if (streamIP != null) {
                    var34_32 = DOCXConverterServlet.activeStreams;
                    synchronized (var34_32) {
                        DOCXConverterServlet.activeStreams.remove(streamIP);
                    }
                }
                DOCXConverterServlet.logger.trace((Object)"end");
            }
            if (resources == null) break block66;
            resources.close();
        }
        if (streamIP != null) {
            var34_34 = DOCXConverterServlet.activeStreams;
            synchronized (var34_34) {
                DOCXConverterServlet.activeStreams.remove(streamIP);
            }
        }
        DOCXConverterServlet.logger.trace((Object)"end");
    }
}

