/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.util;

import java.util.Hashtable;

public class Translit {
    static final int NEUTRAL = 0;
    static final int UPPER = 1;
    static final int LOWER = 2;
    static final Hashtable map = Translit.makeTranslitMap();

    private static Hashtable makeTranslitMap() {
        Hashtable<Character, String> map = new Hashtable<Character, String>();
        map.put(new Character('\u0430'), "a");
        map.put(new Character('\u0431'), "b");
        map.put(new Character('\u0432'), "v");
        map.put(new Character('\u0433'), "g");
        map.put(new Character('\u0434'), "d");
        map.put(new Character('\u0435'), "e");
        map.put(new Character('\u0451'), "yo");
        map.put(new Character('\u0436'), "zh");
        map.put(new Character('\u0437'), "z");
        map.put(new Character('\u0438'), "i");
        map.put(new Character('\u0439'), "j");
        map.put(new Character('\u043a'), "k");
        map.put(new Character('\u043b'), "l");
        map.put(new Character('\u043c'), "m");
        map.put(new Character('\u043d'), "n");
        map.put(new Character('\u043e'), "o");
        map.put(new Character('\u043f'), "p");
        map.put(new Character('\u0440'), "r");
        map.put(new Character('\u0441'), "s");
        map.put(new Character('\u0442'), "t");
        map.put(new Character('\u0443'), "u");
        map.put(new Character('\u0444'), "f");
        map.put(new Character('\u0445'), "h");
        map.put(new Character('\u0446'), "ts");
        map.put(new Character('\u0447'), "ch");
        map.put(new Character('\u0448'), "sh");
        map.put(new Character('\u0449'), "sh'");
        map.put(new Character('\u044a'), "`");
        map.put(new Character('\u044b'), "y");
        map.put(new Character('\u044c'), "'");
        map.put(new Character('\u044d'), "e");
        map.put(new Character('\u044e'), "yu");
        map.put(new Character('\u044f'), "ya");
        map.put(new Character('\u00ab'), "\"");
        map.put(new Character('\u00bb'), "\"");
        map.put(new Character('\u2116'), "No");
        return map;
    }

    private static int charClass(char c) {
        if (Character.isLowerCase(c)) {
            return 2;
        }
        if (Character.isUpperCase(c)) {
            return 1;
        }
        return 0;
    }

    public static String translit(String text) {
        int len = text.length();
        if (len == 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        int pc = 0;
        char c = text.charAt(0);
        int cc = Translit.charClass(c);
        int i = 1;
        while (i <= len) {
            char nextChar = i < len ? (char)text.charAt(i) : (char)' ';
            int nc = Translit.charClass(nextChar);
            Character co = new Character(Character.toLowerCase(c));
            String tr = (String)map.get(co);
            if (tr == null) {
                sb.append(c);
            } else {
                switch (cc) {
                    case 0: 
                    case 2: {
                        sb.append(tr);
                        break;
                    }
                    case 1: {
                        if (nc == 2 || nc == 0 && pc != 1) {
                            sb.append(Character.toUpperCase(tr.charAt(0)));
                            if (tr.length() <= 0) break;
                            sb.append(tr.substring(1));
                            break;
                        }
                        sb.append(tr.toUpperCase());
                    }
                }
            }
            c = nextChar;
            pc = cc;
            cc = nc;
            ++i;
        }
        return sb.toString();
    }

    public static String makeFileName(String text) {
        int len = text.length();
        if (len == 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        int lastAppended = 0;
        int count = 0;
        int i = 0;
        while (i < len) {
            int c = text.charAt(i);
            if ((c & 0xFFFF) <= 127 && (c <= 32 || c == 47 || c == 92 || c == 58 || c == 126 || c == 34 || c == 46)) {
                c = 95;
            }
            if (c != 95 || lastAppended != 95) {
                sb.append((char)c);
                if (++count > 50) break;
                lastAppended = c;
            }
            ++i;
        }
        return sb.toString();
    }
}

