/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.ops;

import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.ops.Element;
import com.adobe.dp.epub.ops.HTMLElement;
import com.adobe.dp.epub.ops.HyperlinkElement;
import com.adobe.dp.epub.ops.ImageElement;
import com.adobe.dp.epub.ops.SVGElement;
import com.adobe.dp.epub.ops.SVGImageElement;
import com.adobe.dp.epub.ops.TableCellElement;
import com.adobe.dp.epub.ops.XRef;
import com.adobe.dp.epub.otf.FontSubsetter;
import com.adobe.dp.xml.util.SMapImpl;
import com.adobe.dp.xml.util.XMLSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class OPSDocument {
    OPSResource resource;
    Hashtable idMap = new Hashtable();
    Element body;
    Vector styleResources = new Vector();
    XRef rootXRef;
    int nextid = 1;
    public static final String xhtmlns = "http://www.w3.org/1999/xhtml";
    public static final String svgns = "http://www.w3.org/2000/svg";
    public static final String xlinkns = "http://www.w3.org/1999/xlink";

    public OPSDocument(OPSResource resource) {
        this.resource = resource;
        this.body = resource.getMediaType().equals("image/svg+xml") ? new SVGElement(this, "svg") : new HTMLElement(this, "body");
    }

    public int assignPlayOrder(int playOrder) {
        XRef rootXRef = this.getRootXRef();
        if (rootXRef.playOrderNeeded()) {
            rootXRef.setPlayOrder(++playOrder);
        }
        return this.body.assignPlayOrder(playOrder);
    }

    public Element getBody() {
        return this.body;
    }

    public Element getElementById(String id) {
        return (Element)this.idMap.get(id);
    }

    void setElementId(Element e, String id) {
        if (e.id != null) {
            this.idMap.remove(e.id);
        }
        Element old = this.idMap.put(id, e);
        e.id = id;
        if (old != null) {
            old.id = null;
            if (old.selfRef != null) {
                this.assignId(old);
            }
        }
    }

    private String newId() {
        String id;
        while (this.idMap.get(id = "id" + this.nextid) != null) {
            ++this.nextid;
        }
        return id;
    }

    String assignId(Element e) {
        String id = e.id;
        if (id == null) {
            e.id = id = this.newId();
            this.idMap.put(id, e);
        }
        return id;
    }

    public Iterator styleResources() {
        return this.styleResources.iterator();
    }

    public void addStyleResource(StyleResource style) {
        this.styleResources.add(style);
    }

    public XRef getRootXRef() {
        if (this.rootXRef == null) {
            this.rootXRef = new XRef(this.resource, null);
        }
        return this.rootXRef;
    }

    public HTMLElement createElement(String name) {
        return new HTMLElement(this, name);
    }

    public HyperlinkElement createHyperlinkElement(String name) {
        return new HyperlinkElement(this, name);
    }

    public TableCellElement createTableCellElement(String name, String align, int colSpan, int rowSpan) {
        return new TableCellElement(this, name, align, colSpan, rowSpan);
    }

    public ImageElement createImageElement(String name) {
        return new ImageElement(this, name);
    }

    public SVGElement createSVGElement(String name) {
        return new SVGElement(this, name);
    }

    public SVGImageElement createSVGImageElement(String name) {
        return new SVGImageElement(this, name);
    }

    public void addFonts(FontSubsetter subsetter, StyleResource styleResource) {
        if (!this.styleResources.contains(styleResource)) {
            return;
        }
        subsetter.setStyles(this.styleResources);
        this.body.addFonts(subsetter);
    }

    public void serialize(OutputStream out) throws IOException {
        XMLSerializer ser = new XMLSerializer(out);
        this.serialize(ser);
    }

    public int getEstimatedSize() {
        return 200 + this.getBody().getEstimatedSize();
    }

    public boolean peelOffBack(OPSDocument newDoc, int targetSize) {
        newDoc.styleResources.addAll(this.styleResources);
        Element newBody = this.body.peelElements(newDoc, targetSize);
        if (newBody == null) {
            return false;
        }
        newDoc.body = newBody;
        return true;
    }

    public void serialize(XMLSerializer ser) {
        ser.startDocument("1.0", "UTF-8");
        boolean isSVG = this.resource.getMediaType().equals("image/svg+xml");
        if (isSVG) {
            Iterator s = this.styleResources();
            while (s.hasNext()) {
                StyleResource sr = (StyleResource)s.next();
                String href = this.resource.makeReference(sr, null);
                ser.processingInstruction("xml-stylesheet", "href=\"" + href + "\" type=\"text/css\"");
            }
            this.getBody().serialize(ser);
        } else {
            ser.startElement(xhtmlns, "html", null, true);
            ser.newLine();
            ser.startElement(xhtmlns, "head", null, false);
            ser.newLine();
            ser.startElement(xhtmlns, "title", null, false);
            ser.endElement(xhtmlns, "title");
            ser.newLine();
            Iterator s = this.styleResources();
            while (s.hasNext()) {
                StyleResource sr = (StyleResource)s.next();
                String href = this.resource.makeReference(sr, null);
                SMapImpl attr = new SMapImpl();
                attr.put(null, "rel", "stylesheet");
                attr.put(null, "type", "text/css");
                attr.put(null, "href", href);
                ser.startElement(xhtmlns, "link", attr, false);
                ser.endElement(xhtmlns, "link");
                ser.newLine();
            }
            ser.endElement(xhtmlns, "head");
            ser.newLine();
            this.getBody().serialize(ser);
            ser.newLine();
            ser.endElement(xhtmlns, "html");
        }
        ser.newLine();
        ser.endDocument();
    }
}

