/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.ops;

import com.adobe.dp.epub.ncx.TOCEntry;
import com.adobe.dp.epub.ops.Element;
import com.adobe.dp.epub.ops.OPSDocument;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.epub.util.TOCLevel;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;

public class HTMLElement
extends Element {
    static HashSet sectionElements;
    static HashSet nonbreakable;
    static Hashtable peelingBonus;
    static Stylesheet builtInStylesheet;
    static /* synthetic */ Class class$0;

    static {
        InputStream in;
        HashSet<String> be = new HashSet<String>();
        be.add("div");
        be.add("body");
        be.add("table");
        be.add("tr");
        be.add("ul");
        be.add("ol");
        be.add("dl");
        sectionElements = be;
        HashSet<String> nb = new HashSet<String>();
        nb.add("table");
        nb.add("ol");
        nb.add("ul");
        nb.add("dl");
        nonbreakable = nb;
        Hashtable<String, Integer> pb = new Hashtable<String, Integer>();
        pb.put("h1", new Integer(8000));
        pb.put("h2", new Integer(8000));
        pb.put("h3", new Integer(5000));
        pb.put("h4", new Integer(3000));
        pb.put("h5", new Integer(2000));
        pb.put("h6", new Integer(1500));
        pb.put("div", new Integer(1500));
        pb.put("p", new Integer(500));
        pb.put("dl", new Integer(0));
        pb.put("ul", new Integer(0));
        pb.put("ol", new Integer(0));
        pb.put("blockquote", new Integer(0));
        pb.put("pre", new Integer(0));
        peelingBonus = pb;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.adobe.dp.epub.ops.HTMLElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((in = clazz.getResourceAsStream("XHTMLStyles.css")) != null) {
            try {
                InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                builtInStylesheet = new Stylesheet(null, reader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    HTMLElement(OPSDocument document, String name) {
        super(document, name);
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/1999/xhtml";
    }

    Element cloneElementShallow(OPSDocument newDoc) {
        HTMLElement e = new HTMLElement(newDoc, this.getElementName());
        e.className = this.className;
        return e;
    }

    protected Object getBuiltInProperty(String propName) {
        if (builtInStylesheet == null) {
            return null;
        }
        SimpleSelector selector = builtInStylesheet.getSimpleSelector(this.elementName, null);
        return HTMLElement.getValue(builtInStylesheet, selector, propName);
    }

    boolean isSection() {
        return sectionElements.contains(this.elementName);
    }

    int getPeelingBonus() {
        Integer bonus = (Integer)peelingBonus.get(this.elementName);
        if (bonus == null) {
            return -1;
        }
        int bv = bonus;
        if (this.selfRef != null) {
            int usage = this.selfRef.getUsage();
            if ((usage & 2) != 0) {
                bv += 10000;
            } else if ((usage & 1) != 0 && bv < 5000) {
                bv = 5000;
            }
        }
        return bv;
    }

    public void generateTOCFromHeadings(Stack headings, int depth) {
        if (this.elementName.startsWith("h") && this.elementName.length() == 2 && Character.isDigit(this.elementName.charAt(1))) {
            TOCLevel level;
            int headingLevel = this.elementName.charAt(1) - 48;
            do {
                level = (TOCLevel)headings.pop();
            } while (!headings.isEmpty() && level.getHeadingLevel() >= headingLevel);
            headings.push(level);
            if (headings.size() < depth + 1) {
                String title = this.getText();
                TOCEntry entry = new TOCEntry(title, this.getSelfRef());
                level.getTOCEntry().add(entry);
                TOCLevel myLevel = new TOCLevel(headingLevel, entry);
                headings.push(myLevel);
            }
        }
        super.generateTOCFromHeadings(headings, depth);
    }

    boolean makeNSDefault() {
        return this.elementName.equals("body");
    }

    boolean canPeelChild() {
        return !nonbreakable.contains(this.elementName);
    }
}

