/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.opf;

import com.adobe.dp.epub.io.ContainerWriter;
import com.adobe.dp.epub.io.DataSource;
import com.adobe.dp.epub.ncx.TOCEntry;
import com.adobe.dp.epub.opf.BitmapImageResource;
import com.adobe.dp.epub.opf.FontResource;
import com.adobe.dp.epub.opf.NCXResource;
import com.adobe.dp.epub.opf.OPFResource;
import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.PageMapResource;
import com.adobe.dp.epub.opf.Resource;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.otf.FontEmbeddingReport;
import com.adobe.dp.epub.otf.FontSubsetter;
import com.adobe.dp.epub.util.TOCLevel;
import com.adobe.dp.otf.DefaultFontLocator;
import com.adobe.dp.otf.FontLocator;
import com.adobe.dp.xml.util.SMapImpl;
import com.adobe.dp.xml.util.XMLSerializer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Publication {
    public static final String dcns = "http://purl.org/dc/elements/1.1/";
    public static final String ocfns = "urn:oasis:names:tc:opendocument:xmlns:container";
    public static final String encns = "http://www.w3.org/2001/04/xmlenc#";
    public static final String deencns = "http://ns.adobe.com/digitaleditions/enc";
    boolean translit;
    boolean useIDPFFontMangling = true;
    Hashtable resourcesByName = new Hashtable();
    Hashtable resourcesById = new Hashtable();
    Hashtable namingIndices = new Hashtable();
    Vector spine = new Vector();
    Vector metadata = new Vector();
    NCXResource toc;
    OPFResource opf;
    int idCount = 1;
    private String contentFolder;
    private byte[] idpfMask;
    private byte[] adobeMask;
    PageMapResource pageMap;

    public Publication() {
        this("OPS");
    }

    public Publication(String contentFolder) {
        this.contentFolder = contentFolder;
        this.toc = new NCXResource(this, String.valueOf(contentFolder) + "/toc.ncx");
        this.opf = new OPFResource(this, String.valueOf(contentFolder) + "/content.opf");
        this.resourcesByName.put(this.toc.name, this.toc);
        this.resourcesByName.put(this.opf.name, this.opf);
    }

    public Publication(File file) throws IOException {
        ZipFile zip = new ZipFile(file);
        ZipEntry container = zip.getEntry("META-INF/container.xml");
        if (container == null) {
            throw new IOException("Not an EPUB file: META-INF/container.xml missing");
        }
        String opfName = Publication.processOCF(zip.getInputStream(container));
        this.opf = new OPFResource(this, opfName);
        this.opf.parse(zip.getInputStream(zip.getEntry(opfName)));
    }

    public String getContentFolder() {
        return this.contentFolder;
    }

    public void useAdobeFontMangling() {
        this.useIDPFFontMangling = false;
    }

    public void useIDPFFontMangling() {
        this.useIDPFFontMangling = true;
    }

    private static String processOCF(InputStream ocfStream) throws IOException {
        throw new IOException("Not yet implemented");
    }

    public void setTranslit(boolean translit) {
        this.translit = translit;
    }

    public void splitLargeChapters(int sizeToSplit) {
        int i = 0;
        while (i < this.spine.size()) {
            OPSResource[] split;
            Resource item = (Resource)this.spine.elementAt(i);
            if (item instanceof OPSResource && (split = ((OPSResource)item).splitLargeChapter(this, sizeToSplit)) != null) {
                this.spine.remove(i);
                int j = 0;
                while (j < split.length) {
                    this.spine.insertElementAt(split[j], i);
                    ++i;
                    ++j;
                }
                --i;
            }
            ++i;
        }
    }

    public void splitLargeChapters() {
        this.splitLargeChapters(100000);
    }

    public void generateTOCFromHeadings(int depth) {
        TOCEntry entry = this.getTOC().getRootTOCEntry();
        entry.removeAll();
        Iterator spine = this.spine();
        Stack<TOCLevel> headings = new Stack<TOCLevel>();
        headings.push(new TOCLevel(0, entry));
        while (spine.hasNext()) {
            Resource r = (Resource)spine.next();
            if (!(r instanceof OPSResource)) continue;
            ((OPSResource)r).generateTOCFromHeadings(headings, depth);
        }
    }

    public void generateTOCFromHeadings() {
        this.generateTOCFromHeadings(6);
    }

    public boolean isTranslit() {
        return this.translit;
    }

    private static void addRandomHexDigit(StringBuffer sb, Random r, int count, int mask, int value) {
        int i = 0;
        while (i < count) {
            int v = r.nextInt(16) & mask | value;
            if (v < 10) {
                sb.append((char)(48 + v));
            } else {
                sb.append((char)(87 + v));
            }
            ++i;
        }
    }

    public String generateRandomIdentifier() {
        StringBuffer sb = new StringBuffer("urn:uuid:");
        SecureRandom sr = new SecureRandom();
        Publication.addRandomHexDigit(sb, sr, 8, 15, 0);
        sb.append('-');
        Publication.addRandomHexDigit(sb, sr, 4, 15, 0);
        sb.append('-');
        sb.append('4');
        Publication.addRandomHexDigit(sb, sr, 3, 15, 0);
        sb.append('-');
        Publication.addRandomHexDigit(sb, sr, 1, 3, 8);
        Publication.addRandomHexDigit(sb, sr, 3, 15, 0);
        sb.append('-');
        Publication.addRandomHexDigit(sb, sr, 12, 15, 0);
        String id = sb.toString();
        this.addDCMetadata("identifier", id);
        return id;
    }

    public NCXResource getTOC() {
        return this.toc;
    }

    public OPFResource getOPF() {
        return this.opf;
    }

    public String getDCMetadata(String name) {
        return this.getMetadata(dcns, name, 0);
    }

    public void addDCMetadata(String name, String value) {
        if (value != null) {
            this.addMetadata(dcns, name, value);
        }
    }

    public String getMetadata(String ns, String name, int index) {
        Iterator it = this.metadata.iterator();
        while (it.hasNext()) {
            SimpleMetadata md = (SimpleMetadata)it.next();
            if (!(ns == null ? md.ns == null : md.ns != null && md.ns.equals(ns)) || !md.name.equals(name)) continue;
            if (index == 0) {
                return md.value;
            }
            --index;
        }
        return null;
    }

    public void addMetadata(String ns, String name, String value) {
        if (value == null) {
            return;
        }
        this.metadata.add(new SimpleMetadata(ns, name, value));
    }

    private String getAdobePrimaryUUID() {
        Iterator it = this.metadata.iterator();
        while (it.hasNext()) {
            SimpleMetadata item = (SimpleMetadata)it.next();
            if (item.ns == null || !item.ns.equals(dcns) || !item.name.equals("identifier") || !item.value.startsWith("urn:uuid:")) continue;
            return item.value.substring(9);
        }
        String value = this.generateRandomIdentifier();
        return value.substring(9);
    }

    public String getPrimaryIdentifier() {
        Iterator it = this.metadata.iterator();
        while (it.hasNext()) {
            SimpleMetadata item = (SimpleMetadata)it.next();
            if (item.ns == null || !item.ns.equals(dcns) || !item.name.equals("identifier")) continue;
            return item.value;
        }
        return this.generateRandomIdentifier();
    }

    public String makeUniqueResourceName(String baseName) {
        String name;
        String suffix;
        if (this.resourcesByName.get(baseName) == null) {
            return baseName;
        }
        int index = baseName.lastIndexOf(46);
        if (index < 0) {
            suffix = "";
        } else {
            suffix = baseName.substring(index);
            baseName = baseName.substring(0, index);
        }
        Integer lastIndex = (Integer)this.namingIndices.get(baseName);
        index = lastIndex == null ? 1 : lastIndex + 1;
        while (this.resourcesByName.get(name = String.valueOf(baseName) + "-" + index + suffix) != null) {
            ++index;
        }
        this.namingIndices.put(baseName, new Integer(index));
        return name;
    }

    public OPSResource createOPSResource(String name) {
        return this.createOPSResource(name, "application/xhtml+xml");
    }

    public OPSResource createOPSResource(String name, String mediaType) {
        OPSResource resource = new OPSResource(name, mediaType);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public void removeResource(Resource r) {
        this.resourcesByName.remove(r.name);
    }

    public void renameResource(Resource r, String newName) {
        this.resourcesByName.remove(r.name);
        r.name = newName;
        this.resourcesByName.put(newName, r);
    }

    public BitmapImageResource createBitmapImageResource(String name, String mediaType, DataSource data) {
        BitmapImageResource resource = new BitmapImageResource(name, mediaType, data);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public StyleResource createStyleResource(String name) {
        StyleResource resource = new StyleResource(name);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public Resource createResource(String name, String mediaType, DataSource data) {
        Resource resource = new Resource(name, mediaType, data);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public FontResource createFontResource(String name, DataSource data) {
        FontResource resource = new FontResource(this, name, data);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public void addToSpine(Resource resource) {
        this.spine.add(resource);
    }

    public Iterator resources() {
        return this.resourcesByName.values().iterator();
    }

    public Iterator spine() {
        return this.spine.iterator();
    }

    public Resource getResourceByName(String name) {
        return (Resource)this.resourcesByName.get(name);
    }

    String assignId(Resource res) {
        if (res.id == null) {
            res.id = this.makeId();
            this.resourcesById.put(res.id, res);
        }
        return res.id;
    }

    String makeId() {
        String id;
        while (this.resourcesById.get(id = "id" + this.idCount++) != null) {
        }
        return id;
    }

    public void usePageMap() {
        if (this.pageMap == null) {
            String name = this.makeUniqueResourceName("OPS/pageMap.xml");
            this.pageMap = new PageMapResource(this, name);
            this.resourcesByName.put(name, this.pageMap);
        }
    }

    public FontEmbeddingReport addFonts(StyleResource styleResource) {
        return this.addFonts(styleResource, DefaultFontLocator.getInstance());
    }

    public FontEmbeddingReport addFonts(StyleResource styleResource, FontLocator locator) {
        FontSubsetter subsetter = new FontSubsetter(this, styleResource, locator);
        Iterator res = this.resources();
        while (res.hasNext()) {
            Object next = res.next();
            if (!(next instanceof OPSResource)) continue;
            OPSResource ops = (OPSResource)next;
            ops.getDocument().addFonts(subsetter, styleResource);
        }
        subsetter.addFonts(this);
        return subsetter;
    }

    static String strip(String source) {
        return source.replaceAll("\\s+", "");
    }

    byte[] makeIDPFXORMask() {
        if (this.idpfMask == null) {
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                String temp = Publication.strip(this.getPrimaryIdentifier());
                sha.update(temp.getBytes("UTF-8"), 0, temp.length());
                this.idpfMask = sha.digest();
            }
            catch (NoSuchAlgorithmException e) {
                System.err.println("No such Algorithm (really, did I misspell SHA-1?");
                System.err.println(e.toString());
                return null;
            }
            catch (IOException e) {
                System.err.println("IO Exception. check out mask.write...");
                System.err.println(e.toString());
                return null;
            }
        }
        return this.idpfMask;
    }

    byte[] makeAdobeXORMask() {
        if (this.adobeMask != null) {
            return this.adobeMask;
        }
        ByteArrayOutputStream mask = new ByteArrayOutputStream();
        String opfUID = this.getAdobePrimaryUUID();
        int acc = 0;
        int len = opfUID.length();
        int i = 0;
        while (i < len) {
            block11: {
                int n;
                block9: {
                    char c;
                    block10: {
                        block8: {
                            c = opfUID.charAt(i);
                            if ('0' > c || c > '9') break block8;
                            n = c - 48;
                            break block9;
                        }
                        if ('a' > c || c > 'f') break block10;
                        n = c - 87;
                        break block9;
                    }
                    if ('A' > c || c > 'F') break block11;
                    n = c - 55;
                }
                if (acc == 0) {
                    acc = 0x100 | n << 4;
                } else {
                    mask.write(acc | n);
                    acc = 0;
                }
            }
            ++i;
        }
        if (mask.size() != 16) {
            return null;
        }
        this.adobeMask = mask.toByteArray();
        return this.adobeMask;
    }

    public void serialize(ContainerWriter container) throws IOException {
        XMLSerializer ser;
        this.getPrimaryIdentifier();
        this.toc.prepareTOC();
        Iterator spine = this.spine();
        int playOrder = 0;
        while (spine.hasNext()) {
            Object sp = spine.next();
            if (!(sp instanceof OPSResource)) continue;
            playOrder = ((OPSResource)sp).getDocument().assignPlayOrder(playOrder);
        }
        Enumeration names = this.resourcesByName.keys();
        boolean needEnc = false;
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Resource res = (Resource)this.resourcesByName.get(name);
            if (res instanceof FontResource) {
                needEnc = true;
            }
            OutputStream out = container.getOutputStream(name, res.canCompress());
            res.serialize(out);
        }
        if (needEnc) {
            ser = new XMLSerializer(container.getOutputStream("META-INF/encryption.xml"));
            ser.startDocument("1.0", "UTF-8");
            ser.startElement(ocfns, "encryption", null, true);
            ser.newLine();
            names = this.resourcesByName.keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Resource res = (Resource)this.resourcesByName.get(name);
                if (!(res instanceof FontResource)) continue;
                SMapImpl attrs = new SMapImpl();
                ser.startElement(encns, "EncryptedData", null, true);
                ser.newLine();
                if (this.useIDPFFontMangling) {
                    attrs.put(null, "Algorithm", "http://www.idpf.org/2008/embedding");
                } else {
                    attrs.put(null, "Algorithm", "http://ns.adobe.com/pdf/enc#RC");
                }
                ser.startElement(encns, "EncryptionMethod", attrs, false);
                ser.endElement(encns, "EncryptionMethod");
                ser.newLine();
                ser.startElement(encns, "CipherData", null, false);
                ser.newLine();
                attrs = new SMapImpl();
                attrs.put(null, "URI", name);
                ser.startElement(encns, "CipherReference", attrs, false);
                ser.endElement(encns, "CipherReference");
                ser.newLine();
                ser.endElement(encns, "CipherData");
                ser.newLine();
                ser.endElement(encns, "EncryptedData");
                ser.newLine();
            }
            ser.endElement(ocfns, "encryption");
            ser.newLine();
            ser.endDocument();
        }
        ser = new XMLSerializer(container.getOutputStream("META-INF/container.xml"));
        ser.startDocument("1.0", "UTF-8");
        SMapImpl attrs = new SMapImpl();
        attrs.put(null, "version", "1.0");
        ser.startElement(ocfns, "container", attrs, true);
        ser.newLine();
        ser.startElement(ocfns, "rootfiles", null, false);
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "full-path", this.opf.name);
        attrs.put(null, "media-type", this.opf.mediaType);
        ser.startElement(ocfns, "rootfile", attrs, true);
        ser.endElement(ocfns, "rootfile");
        ser.newLine();
        ser.endElement(ocfns, "rootfiles");
        ser.newLine();
        ser.endElement(ocfns, "container");
        ser.newLine();
        ser.endDocument();
        container.close();
    }

    static class SimpleMetadata {
        String ns;
        String name;
        String value;

        SimpleMetadata(String ns, String name, String value) {
            this.name = name;
            this.ns = ns;
            this.value = value;
        }
    }
}

