/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.opf;

import com.adobe.dp.epub.ncx.TOCEntry;
import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.PageMapResource;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.Resource;
import com.adobe.dp.epub.ops.Element;
import com.adobe.dp.epub.ops.XRef;
import com.adobe.dp.epub.util.Translit;
import com.adobe.dp.xml.util.SMapImpl;
import com.adobe.dp.xml.util.StringUtil;
import com.adobe.dp.xml.util.XMLSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;

public class NCXResource
extends Resource {
    Publication owner;
    TOCEntry rootTOCEntry = new TOCEntry("", null);
    int entryCount;
    Vector pages = new Vector();
    private static final String ncxns = "http://www.daisy.org/z3986/2005/ncx/";

    NCXResource(Publication owner, String name) {
        super(name, "application/x-dtbncx+xml", null);
        this.owner = owner;
    }

    public TOCEntry getRootTOCEntry() {
        return this.rootTOCEntry;
    }

    public TOCEntry createTOCEntry(String title, XRef xref) {
        return new TOCEntry(title, xref);
    }

    private static String increment(String pageName) {
        char c;
        int len = pageName.length();
        int numberStart = len - 1;
        while ('0' <= (c = pageName.charAt(numberStart)) && c <= '9' && --numberStart >= 0) {
        }
        if (++numberStart != len) {
            int n = Integer.parseInt(pageName.substring(numberStart));
            return String.valueOf(pageName.substring(0, numberStart)) + (n + 1);
        }
        int n = StringUtil.parseRoman(pageName);
        if (n > 0) {
            return StringUtil.printRoman(n + 1);
        }
        return null;
    }

    public void addPage(String name, XRef location) {
        if (name == null || name.length() == 0) {
            if (this.pages.size() > 0) {
                Page lastPage = (Page)this.pages.lastElement();
                String lastName = lastPage.name;
                name = NCXResource.increment(lastName);
            }
            if (name == null || name.length() == 0) {
                name = Integer.toString(this.pages.size() + 1);
            }
        } else if (name.equals(".")) {
            name = "";
        }
        location.addUsage(2);
        this.pages.add(new Page(name, location));
    }

    public void serialize(OutputStream out) throws IOException {
        XMLSerializer ser = new XMLSerializer(out);
        ser.startDocument("1.0", "UTF-8");
        SMapImpl attrs = new SMapImpl();
        attrs.put(null, "version", "2005-1");
        String lang = this.owner.getDCMetadata("language");
        if (lang != null) {
            attrs.put(null, "xml:lang", lang);
        }
        ser.startElement(ncxns, "ncx", attrs, true);
        ser.newLine();
        ser.startElement(ncxns, "head", null, false);
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "name", "dtb:uid");
        String uid = this.owner.getDCMetadata("identifier");
        if (uid == null) {
            uid = "";
        }
        attrs.put(null, "content", uid);
        ser.startElement(ncxns, "meta", attrs, false);
        ser.endElement(ncxns, "meta");
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "name", "dtb:depth");
        int depth = NCXResource.calculateDepth(this.rootTOCEntry);
        attrs.put(null, "content", Integer.toString(depth));
        ser.startElement(ncxns, "meta", attrs, false);
        ser.endElement(ncxns, "meta");
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "name", "dtb:totalPageNumber");
        attrs.put(null, "content", Integer.toString(this.pages.size()));
        ser.startElement(ncxns, "meta", attrs, false);
        ser.endElement(ncxns, "meta");
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "name", "dtb:maxPageNumber");
        attrs.put(null, "content", Integer.toString(this.pages.size()));
        ser.startElement(ncxns, "meta", attrs, false);
        ser.endElement(ncxns, "meta");
        ser.newLine();
        ser.endElement(ncxns, "head");
        ser.newLine();
        ser.startElement(ncxns, "docTitle", null, false);
        ser.startElement(ncxns, "text", null, false);
        String title = this.owner.getDCMetadata("title");
        if (title == null) {
            title = "";
        }
        if (this.owner.isTranslit()) {
            title = Translit.translit(title);
        }
        char[] arr = title.toCharArray();
        ser.text(arr, 0, arr.length);
        ser.endElement(ncxns, "text");
        ser.endElement(ncxns, "docTitle");
        ser.newLine();
        ser.startElement(ncxns, "navMap", null, false);
        ser.newLine();
        this.entryCount = 1;
        this.serializeChildEntries(this.rootTOCEntry, ser);
        ser.endElement(ncxns, "navMap");
        ser.newLine();
        if (this.pages.size() > 0) {
            ser.startElement(ncxns, "pageList", null, false);
            ser.startElement(ncxns, "navLabel", null, false);
            ser.startElement(ncxns, "text", null, false);
            ser.endElement(ncxns, "text");
            ser.endElement(ncxns, "navLabel");
            ser.newLine();
            Iterator pages = this.pages.iterator();
            int count = 1;
            while (pages.hasNext()) {
                Page page = (Page)pages.next();
                attrs = new SMapImpl();
                String countStr = Integer.toString(count++);
                attrs.put(null, "value", countStr);
                attrs.put(null, "type", "normal");
                attrs.put(null, "playOrder", Integer.toString(page.xref.getPlayOrder()));
                ser.startElement(ncxns, "pageTarget", attrs, false);
                ser.newLine();
                ser.startElement(ncxns, "navLabel", null, false);
                ser.startElement(ncxns, "text", null, false);
                char[] text = page.name.toCharArray();
                ser.text(text, 0, text.length);
                ser.endElement(ncxns, "text");
                ser.endElement(ncxns, "navLabel");
                ser.newLine();
                attrs = new SMapImpl();
                attrs.put(null, "src", page.xref.makeReference(this));
                ser.startElement(ncxns, "content", attrs, false);
                ser.endElement(ncxns, "content");
                ser.newLine();
                ser.endElement(ncxns, "pageTarget");
                ser.newLine();
            }
            ser.endElement(ncxns, "pageList");
        }
        ser.endElement(ncxns, "ncx");
        ser.newLine();
        ser.endDocument();
    }

    private static int calculateDepth(TOCEntry entry) {
        Iterator it = entry.content();
        int maxDepth = 0;
        while (it.hasNext()) {
            TOCEntry child = (TOCEntry)it.next();
            int depth = NCXResource.calculateDepth(child);
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth + 1;
    }

    private void serializeChildEntries(TOCEntry entry, XMLSerializer ser) {
        Iterator it = entry.content();
        while (it.hasNext()) {
            TOCEntry child = (TOCEntry)it.next();
            SMapImpl attrs = new SMapImpl();
            attrs.put(null, "playOrder", Integer.toString(child.getXRef().getPlayOrder()));
            attrs.put(null, "id", "id" + this.entryCount);
            ++this.entryCount;
            ser.startElement(ncxns, "navPoint", attrs, false);
            ser.newLine();
            ser.startElement(ncxns, "navLabel", null, false);
            ser.newLine();
            ser.startElement(ncxns, "text", null, false);
            String title = child.getTitle();
            if (title == null) {
                title = "";
            }
            if (this.owner.isTranslit()) {
                title = Translit.translit(title);
            }
            char[] arr = title.toCharArray();
            ser.text(arr, 0, arr.length);
            ser.endElement(ncxns, "text");
            ser.newLine();
            ser.endElement(ncxns, "navLabel");
            ser.newLine();
            attrs = new SMapImpl();
            attrs.put(null, "src", child.getXRef().makeReference(this));
            ser.startElement(ncxns, "content", attrs, false);
            ser.endElement(ncxns, "content");
            ser.newLine();
            this.serializeChildEntries(child, ser);
            ser.endElement(ncxns, "navPoint");
            ser.newLine();
        }
    }

    void serializePageMap(PageMapResource pageMap, OutputStream out) throws IOException {
        String pagemapns = "http://www.idpf.org/2007/opf";
        XMLSerializer ser = new XMLSerializer(out);
        ser.startDocument("1.0", "UTF-8");
        ser.startElement("http://www.idpf.org/2007/opf", "page-map", null, true);
        ser.newLine();
        Iterator pages = this.pages.iterator();
        while (pages.hasNext()) {
            Page page = (Page)pages.next();
            SMapImpl attrs = new SMapImpl();
            attrs.put(null, "name", page.name);
            attrs.put(null, "href", page.xref.makeReference(pageMap));
            ser.startElement("http://www.idpf.org/2007/opf", "page", attrs, false);
            ser.endElement("http://www.idpf.org/2007/opf", "page");
            ser.newLine();
        }
        ser.endElement("http://www.idpf.org/2007/opf", "page-map");
        ser.endDocument();
    }

    public void prepareTOC() {
        Iterator pages = this.pages.iterator();
        OPSResource lastResource = null;
        boolean report = false;
        while (pages.hasNext()) {
            Page page = (Page)pages.next();
            OPSResource resource = page.xref.getTargetResource();
            if (resource == lastResource) continue;
            lastResource = resource;
            if (page.xref.getTargetId() != null) {
                if (report) {
                    Element p = resource.getDocument().getBody();
                    Element t = page.xref.getTagetElement();
                    while (p != t) {
                        Object f;
                        Iterator it = p.content();
                        if (!it.hasNext() || !((f = it.next()) instanceof Element)) break;
                        p = (Element)f;
                    }
                    if (p != t) {
                        System.out.println("chapter break is moved");
                    } else {
                        System.out.println("chapter break is adjusted");
                    }
                }
                page.xref = resource.getDocument().getRootXRef();
            } else if (report) {
                System.out.println("chapter break is good as is");
            }
            page.xref.requestPlayOrder();
        }
        this.rootTOCEntry.requestPlayOrder();
    }

    static class Page {
        String name;
        XRef xref;

        Page(String name, XRef xref) {
            this.name = name;
            this.xref = xref;
        }
    }
}

