/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.conv;

import com.adobe.dp.epub.conv.ConversionClient;
import com.adobe.dp.epub.conv.ConversionService;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GUIDriver
extends JFrame {
    public static final long serialVersionUID = 0L;
    BufferedImage epubIcon;
    BufferedImage cssIcon;
    BufferedImage otfIcon;
    BufferedImage ttfIcon;
    BufferedImage errIcon;
    DragSource dragSource = DragSource.getDefaultDragSource();
    boolean dragActive;
    Point dragStart = new Point(0, 0);
    Vector conversionQueue = new Vector();
    FileIcon currentlyConverting;
    FileIcon[] localDrag;
    JTabbedPane tabbedPane;
    FilePanel docPane;
    FilePanel resourcePane;
    SettingsPanel settingsPane;
    JEditorPane helpPane;
    File docFolder;
    File resourceFolder;
    File settingsFile;
    File workFolder;
    Properties settings = new Properties();
    static DataFlavor urilist;
    static /* synthetic */ Class class$0;

    static {
        try {
            urilist = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GUIDriver(File epubgenHome) {
        super("EPUBGen - Buttonless Converter");
        if (epubgenHome == null || !epubgenHome.isDirectory()) {
            File home = new File(System.getProperty("user.home"));
            epubgenHome = new File(home, "EPUBGen");
        }
        this.docFolder = new File(epubgenHome, "Documents");
        this.docFolder.mkdirs();
        this.resourceFolder = new File(epubgenHome, "Resources");
        this.resourceFolder.mkdirs();
        File settingsFolder = new File(epubgenHome, "Settings");
        settingsFolder.mkdirs();
        this.settingsFile = new File(settingsFolder, "settings.prop");
        this.workFolder = new File(epubgenHome, "Work");
        this.workFolder.mkdirs();
        if (this.settingsFile.exists()) {
            try {
                this.settings.load(new FileInputStream(this.settingsFile));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.docPane = new FilePanel(this.docFolder);
        this.resourcePane = new FilePanel(this.resourceFolder);
        this.settingsPane = new SettingsPanel();
        this.tabbedPane = new JTabbedPane();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.adobe.dp.epub.conv.GUIDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.helpPane = new JEditorPane(clazz.getResource("help.html"));
            this.helpPane.setEditable(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.tabbedPane);
        this.tabbedPane.add("Documents", new JScrollPane(this.docPane));
        this.tabbedPane.add("Resources", new JScrollPane(this.resourcePane));
        this.tabbedPane.add("Settings", new JScrollPane(this.settingsPane));
        if (this.helpPane != null) {
            this.tabbedPane.add("Help", new JScrollPane(this.helpPane));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setSize(350, 250);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.adobe.dp.epub.conv.GUIDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream png = clazz.getResourceAsStream("epub.png");
            this.epubIcon = ImageIO.read(png);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.adobe.dp.epub.conv.GUIDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            png = clazz2.getResourceAsStream("css.png");
            this.cssIcon = ImageIO.read(png);
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("com.adobe.dp.epub.conv.GUIDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            png = clazz3.getResourceAsStream("otf.png");
            this.otfIcon = ImageIO.read(png);
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("com.adobe.dp.epub.conv.GUIDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            png = clazz4.getResourceAsStream("ttf.png");
            this.ttfIcon = ImageIO.read(png);
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("com.adobe.dp.epub.conv.GUIDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            png = clazz5.getResourceAsStream("err.png");
            this.errIcon = ImageIO.read(png);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new Converter().start();
        new Updater();
        new FileCheck();
    }

    public static File makeFile(File folder, String baseName) {
        File file = new File(folder, baseName);
        if (file.exists()) {
            String extStr;
            String baseStr;
            int ext = baseName.indexOf(46);
            if (ext < 0) {
                baseStr = baseName;
                extStr = "";
            } else {
                baseStr = baseName.substring(0, ext);
                extStr = baseName.substring(ext);
            }
            int count = 1;
            while ((file = new File(folder, String.valueOf(baseStr) + "-" + count + extStr)).exists()) {
                ++count;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleConversion(FileIcon file) {
        Vector vector = this.conversionQueue;
        synchronized (vector) {
            this.conversionQueue.add(file);
            this.conversionQueue.notify();
        }
    }

    public static void main(String[] args) {
        File home = null;
        if (args.length == 1 && !(home = new File(args[0])).isDirectory()) {
            System.err.println(String.valueOf(args[0]) + ": not a folder");
        }
        GUIDriver conv = new GUIDriver(home);
        conv.setVisible(true);
    }

    class AlphaFilter
    extends RGBImageFilter {
        private int alpha;

        public AlphaFilter() {
            this.canFilterIndexColorModel = true;
        }

        public void setLevel(float f) {
            this.alpha = Math.round(f * 255.0f);
        }

        public int filterRGB(int x, int y, int rgb) {
            int alpha = this.alpha * (rgb >>> 24) / 255 << 24;
            return rgb & 0xFFFFFF | alpha;
        }
    }

    class Converter
    extends Thread
    implements ConversionClient {
        Converter() {
            super("Converter");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                FileIcon item;
                Vector vector = GUIDriver.this.conversionQueue;
                synchronized (vector) {
                    while (true) {
                        if (GUIDriver.this.conversionQueue.size() != 0) {
                            item = (FileIcon)GUIDriver.this.conversionQueue.get(0);
                            GUIDriver.this.conversionQueue.removeElementAt(0);
                            GUIDriver.this.currentlyConverting = item;
                            break;
                        }
                        try {
                            GUIDriver.this.conversionQueue.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Vector resources = new Vector();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(this, resources){
                        final /* synthetic */ Converter this$1;
                        private final /* synthetic */ Vector val$resources;
                        {
                            this.this$1 = converter;
                            this.val$resources = vector;
                        }

                        public void run() {
                            Component[] components = Converter.access$0((Converter)this.this$1).resourcePane.getComponents();
                            int i = 0;
                            while (i < components.length) {
                                if (components[i] instanceof FileIcon) {
                                    FileIcon fi = (FileIcon)components[i];
                                    if (fi.file != null) {
                                        this.val$resources.add(fi.file);
                                    }
                                }
                                ++i;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Object[] reslist = new File[resources.size()];
                resources.copyInto(reslist);
                this.reportProgress(0.0f);
                item.service.setProperties(GUIDriver.this.settings);
                FileIcon srcItem = item;
                StringWriter log = new StringWriter();
                PrintWriter plog = new PrintWriter(log);
                plog.println("Conversion log for " + item.file.getAbsolutePath());
                plog.println("Start: " + new Date());
                File res = item.service.convert(item.file, (File[])reslist, this, plog);
                plog.println("End: " + new Date());
                String logTxt = log.toString();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(this, res, logTxt, srcItem){
                        final /* synthetic */ Converter this$1;
                        private final /* synthetic */ File val$res;
                        private final /* synthetic */ String val$logTxt;
                        private final /* synthetic */ FileIcon val$srcItem;
                        {
                            this.this$1 = converter;
                            this.val$res = file;
                            this.val$logTxt = string;
                            this.val$srcItem = fileIcon;
                        }

                        public void run() {
                            if (this.val$res == null) {
                                File dest = GUIDriver.makeFile(Converter.access$0((Converter)this.this$1).docFolder, "error.txt");
                                try {
                                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(dest), "UTF-8");
                                    out.write(this.val$logTxt);
                                    ((Writer)out).close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                this.val$srcItem.changeFile(dest, Converter.access$0((Converter)this.this$1).errIcon);
                            } else {
                                File dest = GUIDriver.makeFile(Converter.access$0((Converter)this.this$1).docFolder, this.val$res.getName());
                                if (this.val$res.renameTo(dest)) {
                                    this.val$srcItem.changeFile(dest, Converter.access$0((Converter)this.this$1).epubIcon);
                                } else {
                                    this.val$srcItem.changeFile(this.val$res, Converter.access$0((Converter)this.this$1).epubIcon);
                                }
                            }
                            this.val$srcItem.setLog(this.val$logTxt);
                            Converter.access$0((Converter)this.this$1).currentlyConverting = null;
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.reportProgress(1.0f);
            }
        }

        public void reportIssue(String errorCode) {
        }

        public void reportProgress(float progress) {
        }

        public File makeFile(String baseName) {
            return GUIDriver.makeFile(GUIDriver.this.workFolder, baseName);
        }

        static /* synthetic */ GUIDriver access$0(Converter converter) {
            return converter.GUIDriver.this;
        }
    }

    class FileCheck
    extends AbstractAction {
        public static final long serialVersionUID = 0L;
        Timer timer = new Timer(500, this);

        FileCheck() {
            this.timer.start();
        }

        public void actionPerformed(ActionEvent evt) {
            this.timer.setDelay(3000);
            GUIDriver.this.docPane.checkFiles();
            GUIDriver.this.resourcePane.checkFiles();
        }
    }

    class FileIcon
    extends JComponent
    implements DragGestureListener {
        public static final long serialVersionUID = 0L;
        File file;
        Image icon;
        Image highlightedIcon;
        ConversionService service;
        boolean highlighted;
        boolean dragIcon;
        String name;
        Point initial;
        String log;

        FileIcon(File file, Image icon, ConversionService service, String name) {
            this.file = file;
            this.icon = icon;
            this.service = service;
            this.name = name;
            this.dragIcon = file == null;
            this.setOpaque(false);
            this.setSize(64, 88);
            if (!this.dragIcon) {
                this.addMouseListener(new MouseAdapter(this){
                    final /* synthetic */ FileIcon this$1;
                    {
                        this.this$1 = fileIcon;
                    }

                    public void mousePressed(MouseEvent evt) {
                        if (!this.this$1.highlighted && !evt.isControlDown()) {
                            ((FilePanel)this.this$1.getParent()).resetSelection();
                        }
                        this.this$1.highlighted = true;
                        this.this$1.repaint();
                    }

                    public void mouseReleased(MouseEvent evt) {
                        if (this.this$1.highlighted && !evt.isControlDown()) {
                            ((FilePanel)this.this$1.getParent()).resetSelection();
                            this.this$1.highlighted = true;
                        }
                    }
                });
                int actions = 3;
                GUIDriver.this.dragSource.createDefaultDragGestureRecognizer(this, actions, this);
            }
        }

        void setLog(String log) {
            this.log = log;
        }

        void clearHighlight() {
            this.highlighted = false;
            this.repaint();
        }

        FileIcon makeDragIcon() {
            FileIcon fi = new FileIcon(null, this.icon, null, this.name);
            fi.highlighted = true;
            fi.initial = this.getLocation();
            fi.setLocation(fi.initial);
            return fi;
        }

        void setDragLocation(Point dragNow) {
            if (GUIDriver.this.dragStart != null) {
                int newX = this.initial.x + dragNow.x - GUIDriver.this.dragStart.x;
                int newY = this.initial.y + dragNow.y - GUIDriver.this.dragStart.y;
                this.setLocation(newX, newY);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void paint(Graphics g) {
            baseG = g;
            group = null;
            if (this.dragIcon) {
                if (!GUIDriver.this.dragActive) {
                    return;
                }
                group = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                g = group.getGraphics();
            }
            g2d = (Graphics2D)g;
            width = this.getWidth();
            height = 50;
            if (this == GUIDriver.this.currentlyConverting) {
                r = new Random();
                pix = new int[2500];
                i = 0;
                while (i < 50) {
                    xd = i < 11 ? 11 - i : (i > 38 ? i - 38 : 0);
                    j = 0;
                    while (j < 50) {
                        yd = j < 11 ? 11 - j : (j > 38 ? j - 38 : 0);
                        d = xd == 0 && yd == 0 ? 11.0f : 11.0f - (float)Math.sqrt(xd * xd + yd * yd);
                        pix[i * 50 + j] = d > (p = 20.0f * r.nextFloat()) ? ((p = 11.0f * r.nextFloat()) > d ? -256 : -65536) : 0;
                        ++j;
                    }
                    ++i;
                }
                img = this.createImage(new MemoryImageSource(50, 50, pix, 0, 50));
                g.drawImage(img, 7, 0, null);
            }
            if (this.icon != null) {
                iwidth = this.icon.getWidth(this);
                iheight = this.icon.getHeight(this);
                x = (width - iwidth) / 2;
                y = (height - iheight) / 2;
                if (this.highlighted) {
                    if (this.highlightedIcon == null) {
                        filter = new HighlightedFilter();
                        producer = new FilteredImageSource(this.icon.getSource(), filter);
                        this.highlightedIcon = this.createImage(producer);
                    }
                    g.drawImage(this.highlightedIcon, x, y, this);
                } else {
                    g.drawImage(this.icon, x, y, this);
                }
            }
            lineBreaks = new int[3];
            offx = new int[lineBreaks.length];
            lbi = 0;
            font = new Font("SansSerif", 0, 11);
            g.setFont(font);
            fm = g.getFontMetrics();
            em = fm.charWidth('m');
            emlen = width / em;
            nameChars = this.name.toCharArray();
            chi = 0;
            while (chi < nameChars.length && lbi < lineBreaks.length) {
                block18: {
                    len = emlen;
                    if (chi + len > nameChars.length) {
                        len = nameChars.length - chi;
                    }
                    if ((chw = fm.charsWidth(nameChars, chi, len)) <= width) ** GOTO lbl68
                    while (len > 1) {
                        if ((chw = fm.charsWidth(nameChars, chi, --len)) > width) {
                            continue;
                        }
                        break block18;
                    }
                    break block18;
lbl-1000:
                    // 1 sources

                    {
                        if ((chw1 = fm.charsWidth(nameChars, chi, ++len)) > width) {
                            --len;
                            break;
                        }
                        chw = chw1;
lbl68:
                        // 2 sources

                        ** while (chi + len < nameChars.length)
                    }
                }
                offx[lbi] = (width - chw) / 2;
                lineBreaks[lbi++] = chi += len;
            }
            chi = 0;
            if (this.highlighted) {
                g2d.setPaint(new Color(0.0f, 0.2f, 0.8f, 0.75f));
                rect = new Rectangle(0, this.getHeight() - lineBreaks.length * fm.getHeight(), width, lbi * fm.getHeight());
                g2d.setComposite(AlphaComposite.getInstance(3));
                g2d.fill(rect);
                g.setColor(Color.white);
            }
            line = 0;
            while (line < lbi) {
                chi1 = lineBreaks[line];
                ty = this.getHeight() - fm.getDescent() - (lineBreaks.length - 1 - line) * fm.getHeight();
                g.drawString(this.name.substring(chi, chi1), offx[line], ty);
                chi = chi1;
                ++line;
            }
            if (group != null) {
                g.dispose();
                filter = new AlphaFilter();
                filter.setLevel(0.5f);
                producer = new FilteredImageSource(group.getSource(), filter);
                filtered = this.createImage(producer);
                baseG.drawImage(filtered, 0, 0, null);
            }
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            ((FilePanel)this.getParent()).startDrag(this, dge);
        }

        void changeFile(File file, Image icon) {
            FilePanel fp = (FilePanel)this.getParent();
            File folder = fp.folder;
            if (folder.equals(this.file.getParentFile()) && !this.file.delete()) {
                fp.blackList.add(this.file);
            }
            this.service = null;
            this.file = file;
            this.icon = icon;
            this.name = file.getName();
            this.highlightedIcon = null;
            this.repaint();
        }
    }

    class FilePanel
    extends JPanel
    implements DropTargetListener,
    DragSourceListener {
        public static final long serialVersionUID = 0L;
        File folder;
        HashSet blackList = new HashSet();

        public FilePanel(File folder) {
            this.folder = folder;
            this.setBackground(new Color(-1));
            this.setLayout(null);
            new DropTarget(this, this);
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ FilePanel this$1;
                {
                    this.this$1 = filePanel;
                }

                public void mousePressed(MouseEvent evt) {
                    this.this$1.resetSelection();
                }
            });
        }

        void resetSelection() {
            Component[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof FileIcon) {
                    FileIcon fi = (FileIcon)components[i];
                    fi.clearHighlight();
                }
                ++i;
            }
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.getComponentCount() == 0) {
                String label = this == GUIDriver.this.docPane ? "Drop documents here" : "Drop resources here";
                Dimension d = this.getSize();
                int size = 20;
                Font f = new Font("Serif", 0, size);
                g.setFont(f);
                FontMetrics fm = g.getFontMetrics();
                char[] arr = label.toCharArray();
                int width = fm.charsWidth(arr, 0, arr.length);
                int fs = 2 * size * d.width / (3 * width);
                f = new Font("Serif", 0, fs);
                g.setFont(f);
                int x = (d.width - fs * width / size) / 2;
                int y = (d.height + 2 * fs / 3) / 2;
                g.setColor(new Color(0xCCCCCC));
                g.drawString(label, x, y);
            }
        }

        public void add(FileIcon component) {
            if (this.getComponentCount() == 0) {
                this.repaint();
            }
            super.add(component);
        }

        private boolean isEPub(File f) {
            return f.getName().toLowerCase().endsWith(".epub");
        }

        private boolean isErrorLog(File f) {
            String nm = f.getName();
            return nm.startsWith("error") && nm.endsWith(".txt");
        }

        private boolean canUse(File f) {
            String nm = f.getName().toLowerCase();
            return nm.endsWith(".css") || nm.endsWith(".otf") || nm.endsWith(".ttf") || nm.endsWith(".ttc");
        }

        private BufferedImage getResIcon(String nm) {
            if (nm.endsWith(".ttf") || nm.endsWith(".ttc")) {
                return GUIDriver.this.ttfIcon;
            }
            if (nm.endsWith(".otf")) {
                return GUIDriver.this.otfIcon;
            }
            if (nm.endsWith(".css")) {
                return GUIDriver.this.cssIcon;
            }
            return null;
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (!GUIDriver.this.dragActive) {
                GUIDriver.this.dragActive = true;
                if (GUIDriver.this.localDrag != null) {
                    int i = 0;
                    while (i < GUIDriver.this.localDrag.length) {
                        GUIDriver.this.localDrag[i].repaint();
                        ++i;
                    }
                }
            }
            this.dragOver(dtde);
        }

        public void dragExit(DropTargetEvent dte) {
            if (GUIDriver.this.dragActive) {
                GUIDriver.this.dragActive = false;
                if (GUIDriver.this.localDrag != null) {
                    int i = 0;
                    while (i < GUIDriver.this.localDrag.length) {
                        GUIDriver.this.localDrag[i].repaint();
                        ++i;
                    }
                }
            }
        }

        private List getFilesFromTransferable(Transferable t) throws Exception {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            String uris = (String)t.getTransferData(urilist);
            StringTokenizer tok = new StringTokenizer(uris);
            Vector<File> files = new Vector<File>();
            while (tok.hasMoreTokens()) {
                String uri = tok.nextToken();
                try {
                    URL url = new URL(uri);
                    if (!url.getProtocol().equals("file")) continue;
                    files.add(new File(url.getFile()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return files;
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && !dtde.isDataFlavorSupported(urilist)) {
                return;
            }
            if (GUIDriver.this.localDrag != null) {
                int i = 0;
                while (i < GUIDriver.this.localDrag.length) {
                    GUIDriver.this.localDrag[i].setDragLocation(dtde.getLocation());
                    ++i;
                }
                dtde.acceptDrag(2);
                return;
            }
            Transferable t = dtde.getTransferable();
            try {
                List files = this.getFilesFromTransferable(t);
                if (files == null) {
                    dtde.acceptDrag(1);
                    return;
                }
                Iterator f = files.iterator();
                boolean canUse = false;
                while (f.hasNext()) {
                    File file = (File)f.next();
                    Iterator it = ConversionService.registeredSerivces();
                    while (it.hasNext()) {
                        ConversionService service = (ConversionService)it.next();
                        if (service.canConvert(file)) {
                            dtde.acceptDrag(1);
                            GUIDriver.this.tabbedPane.setSelectedIndex(0);
                            return;
                        }
                        if (!this.canUse(file) && !service.canUse(file)) continue;
                        canUse = true;
                    }
                }
                if (canUse) {
                    dtde.acceptDrag(1);
                    GUIDriver.this.tabbedPane.setSelectedIndex(1);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dtde.rejectDrag();
        }

        void nextLocation(FilePanel panel, Point loc, FileIcon icon) {
            loc.x += icon.getWidth() + 5;
            if (loc.x + icon.getWidth() > panel.getWidth()) {
                loc.x = 5;
                loc.y += icon.getHeight() + 5;
            }
        }

        private void copyResourceFile(File file, Image fileIcon, Point loc) {
            byte[] buffer = new byte[4096];
            try {
                if (!GUIDriver.this.resourceFolder.equals(file.getParentFile())) {
                    int len;
                    FileInputStream in = new FileInputStream(file);
                    File target = GUIDriver.makeFile(GUIDriver.this.resourceFolder, file.getName());
                    FileOutputStream out = new FileOutputStream(target);
                    while ((len = ((InputStream)in).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                    ((OutputStream)out).close();
                    ((InputStream)in).close();
                    file = target;
                }
                FileIcon icon = new FileIcon(file, fileIcon, null, file.getName());
                GUIDriver.this.resourcePane.add(icon);
                icon.setLocation(loc);
                this.nextLocation(GUIDriver.this.resourcePane, loc, icon);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        boolean addFile(File file, Point loc, boolean anyType) {
            String nm;
            BufferedImage fileIcon;
            boolean canAddDocs;
            boolean canAddResources = anyType || this == GUIDriver.this.resourcePane;
            boolean bl = canAddDocs = anyType || this == GUIDriver.this.docPane;
            if (canAddResources && this.canUse(file) && (fileIcon = this.getResIcon(nm = file.getName().toLowerCase())) != null) {
                this.copyResourceFile(file, fileIcon, loc);
                return true;
            }
            Iterator it = ConversionService.registeredSerivces();
            while (it.hasNext()) {
                Image image;
                ConversionService service = (ConversionService)it.next();
                if (canAddDocs && service.canConvert(file)) {
                    image = service.getIcon(file);
                    FileIcon icon = new FileIcon(file, image, service, file.getName());
                    GUIDriver.this.docPane.add(icon);
                    icon.setLocation(loc);
                    this.nextLocation(GUIDriver.this.docPane, loc, icon);
                    GUIDriver.this.scheduleConversion(icon);
                    return true;
                }
                if (!canAddResources || !service.canUse(file) || (image = service.getIcon(file)) == null) continue;
                this.copyResourceFile(file, image, loc);
                return true;
            }
            return false;
        }

        public void drop(DropTargetDropEvent dtde) {
            GUIDriver.this.dragActive = false;
            if (!dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && !dtde.isDataFlavorSupported(urilist)) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(0x40000000);
            Transferable t = dtde.getTransferable();
            if (dtde.isLocalTransfer()) {
                this.localDrop(dtde);
                dtde.dropComplete(true);
                return;
            }
            try {
                Point loc = dtde.getLocation();
                List files = this.getFilesFromTransferable(t);
                Iterator f = files.iterator();
                boolean success = false;
                while (f.hasNext()) {
                    File file = (File)f.next();
                    if (!this.addFile(file, loc, true)) continue;
                    success = true;
                }
                dtde.dropComplete(success);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void startDrag(FileIcon src, DragGestureEvent dge) {
            InputEvent trigger = dge.getTriggerEvent();
            Point dragStart = null;
            if (trigger instanceof MouseEvent) {
                dragStart = ((MouseEvent)trigger).getPoint();
                Point pos = src.getLocation();
                GUIDriver.this.dragStart = new Point(dragStart.x + pos.x, dragStart.y + pos.y);
            }
            Vector<File> files = new Vector<File>();
            Vector<FileIcon> dragIcons = new Vector<FileIcon>();
            Component[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof FileIcon) {
                    FileIcon fi = (FileIcon)components[i];
                    if (fi.highlighted) {
                        files.add(fi.file);
                        FileIcon di = fi.makeDragIcon();
                        dragIcons.add(di);
                        this.add(di);
                        this.setComponentZOrder(di, 0);
                    }
                }
                ++i;
            }
            FileTransferable transferable = new FileTransferable(files);
            if (DragSource.isDragImageSupported()) {
                BufferedImage dragImage = new BufferedImage(src.getWidth(), src.getHeight(), 2);
                Graphics g = dragImage.getGraphics();
                src.paint(g);
                g.dispose();
                Point imageOffset = new Point(-dragStart.x, -dragStart.y);
                dge.startDrag(null, dragImage, imageOffset, transferable, this);
            } else {
                dge.startDrag(null, transferable, this);
            }
            GUIDriver.this.localDrag = new FileIcon[dragIcons.size()];
            dragIcons.copyInto(GUIDriver.this.localDrag);
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void localDrop(DropTargetDropEvent dtde) {
            Point dragEnd = dtde.getLocation();
            int dx = dragEnd.x - GUIDriver.this.dragStart.x;
            int dy = dragEnd.y - GUIDriver.this.dragStart.y;
            Component[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof FileIcon) {
                    FileIcon fi = (FileIcon)components[i];
                    if (fi.highlighted) {
                        Point loc = fi.getLocation();
                        loc.x += dx;
                        loc.y += dy;
                        fi.setLocation(loc);
                    }
                }
                ++i;
            }
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            int i = 0;
            while (i < GUIDriver.this.localDrag.length) {
                this.remove(GUIDriver.this.localDrag[i]);
                ++i;
            }
            GUIDriver.this.localDrag = null;
            this.checkFiles();
        }

        public void checkFiles() {
            Component[] components = this.getComponents();
            boolean repaint = false;
            HashSet<String> names = new HashSet<String>();
            int maxy = 0;
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof FileIcon) {
                    FileIcon fi = (FileIcon)components[i];
                    if (fi.file == null) {
                        return;
                    }
                    if (!fi.file.exists()) {
                        this.remove(fi);
                        repaint = true;
                    } else if (fi.file.getParentFile().equals(this.folder)) {
                        names.add(fi.file.getName());
                        int y = fi.getY() + fi.getHeight();
                        if (y > maxy) {
                            maxy = y;
                        }
                    }
                }
                ++i;
            }
            Point location = new Point(5, maxy + 5);
            String[] list = this.folder.list();
            if (list != null) {
                int i2 = 0;
                while (i2 < list.length) {
                    String name = list[i2];
                    if (!names.contains(name)) {
                        File newFile = new File(this.folder, name);
                        if (this.blackList.contains(newFile)) {
                            if (newFile.delete()) {
                                this.blackList.remove(newFile);
                            }
                        } else if (this == GUIDriver.this.docPane && (this.isErrorLog(newFile) || this.isEPub(newFile))) {
                            BufferedImage img = this.isErrorLog(newFile) ? GUIDriver.this.errIcon : GUIDriver.this.epubIcon;
                            FileIcon icon = new FileIcon(newFile, img, null, name);
                            this.add(icon);
                            repaint = true;
                            icon.setLocation(location);
                            this.nextLocation(this, location, icon);
                        } else {
                            this.addFile(newFile, location, false);
                        }
                    }
                    ++i2;
                }
            }
            if (repaint) {
                this.validate();
                this.repaint();
            }
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dse) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        public Dimension getPreferredSize() {
            Component[] components = this.getComponents();
            int width = 100;
            int height = 100;
            if (components != null) {
                int i = 0;
                while (i < components.length) {
                    Component c = components[i];
                    int w = c.getX() + c.getWidth();
                    int h = c.getY() + c.getHeight();
                    if (w > width) {
                        width = w;
                    }
                    if (h > height) {
                        height = h;
                    }
                    ++i;
                }
            }
            return new Dimension(width, height);
        }
    }

    class FileTransferable
    implements Transferable {
        Vector list;

        FileTransferable(Vector list) {
            this.list = list;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                return this.list;
            }
            if (flavor.equals(urilist)) {
                StringBuffer sb = new StringBuffer();
                Iterator it = this.list.iterator();
                while (it.hasNext()) {
                    File f = (File)it.next();
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(f.toURI());
                }
                return sb.toString();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, urilist};
            return flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.javaFileListFlavor) || flavor.equals(urilist);
        }
    }

    static class HighlightedFilter
    extends RGBImageFilter {
        public HighlightedFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            return ((rgb & 0xFEFEFE) >> 1) + 128 | rgb & 0xFF000000;
        }
    }

    class SettingsPanel
    extends JPanel
    implements ChangeListener {
        public static final long serialVersionUID = 0L;
        JCheckBox translit = new JCheckBox("Transliterate cyrillic metadata");
        JCheckBox embedFonts = new JCheckBox("Embed fonts");
        JCheckBox adobeMangling = new JCheckBox("Use Adobe font mangling");
        JCheckBox pageBreaks = new JCheckBox("Add page map using page breaks (DOCX only)");

        SettingsPanel() {
            Box box = Box.createVerticalBox();
            this.add(box);
            box.add(this.translit);
            box.add(this.embedFonts);
            box.add(this.adobeMangling);
            this.translit.setSelected(this.getBooleanProperty("translit", true));
            this.embedFonts.setSelected(this.getBooleanProperty("embedFonts", true));
            this.adobeMangling.setSelected(this.getBooleanProperty("adobeMangling", true));
            this.pageBreaks.setSelected(this.getBooleanProperty("pageBreaks", false));
            this.translit.addChangeListener(this);
            this.embedFonts.addChangeListener(this);
            this.adobeMangling.addChangeListener(this);
            this.pageBreaks.addChangeListener(this);
        }

        boolean getBooleanProperty(String name, boolean def) {
            String s = GUIDriver.this.settings.getProperty(name);
            if (s == null) {
                return def;
            }
            return s.toLowerCase().startsWith("t");
        }

        void setBooleanProperty(String name, boolean val) {
            GUIDriver.this.settings.setProperty(name, val ? "true" : "false");
        }

        public void stateChanged(ChangeEvent arg) {
            this.setBooleanProperty("translit", this.translit.isSelected());
            this.setBooleanProperty("embedFonts", this.embedFonts.isSelected());
            this.setBooleanProperty("adobeMangling", this.adobeMangling.isSelected());
            this.setBooleanProperty("pageBreaks", this.pageBreaks.isSelected());
            try {
                FileOutputStream out = new FileOutputStream(GUIDriver.this.settingsFile);
                GUIDriver.this.settings.store(out, "EPUBGen");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Updater
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        Updater() {
            new Timer(50, this).start();
        }

        public void actionPerformed(ActionEvent evt) {
            if (GUIDriver.this.currentlyConverting != null) {
                GUIDriver.this.currentlyConverting.repaint();
            }
        }
    }
}

