/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.conv;

import com.adobe.dp.epub.conv.ConversionClient;
import com.adobe.dp.epub.conv.ConversionService;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class CLDriver
implements ConversionClient {
    Properties settings = new Properties();
    Vector resources = new Vector();
    Vector sources = new Vector();

    public CLDriver() {
        this.settings.put("translit", "true");
        this.settings.put("embedFonts", "true");
        this.settings.put("adobeMangling", "true");
        this.settings.put("pageBreaks", "false");
        this.settings.put("targetDir", ".");
    }

    void addFile(Vector list, File file) {
        if (!file.canRead()) {
            System.err.println("cannot read file: " + file.getPath());
            System.exit(1);
        }
        if (file.isDirectory()) {
            String[] files = file.list();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    this.addFile(list, new File(file, files[i]));
                    ++i;
                }
            }
        } else {
            list.add(file);
        }
    }

    int processParam(int index, String[] args) {
        String arg;
        if ((arg = args[index++]).startsWith("-")) {
            String a = arg.substring(1);
            if (index >= args.length) {
                System.err.println("missing option value: " + arg);
                System.exit(2);
            }
            String val = args[index++];
            if (a.equals("resource")) {
                this.addFile(this.resources, new File(val));
            } else if (this.settings.get(a) == null) {
                System.err.println("unknown option: " + arg);
                System.exit(2);
            } else {
                this.settings.put(a, val);
            }
        } else {
            this.addFile(this.sources, new File(arg));
        }
        return index;
    }

    public void invoke(String[] args) {
        if (args.length == 0) {
            System.err.println("User:");
            System.err.println(" java -jar epubgen.jar com.adobe.dp.epub.conv.CLDriver [options] srcfile ...");
            System.err.println("Options:");
            Enumeration<Object> keys = this.settings.keys();
            while (keys.hasMoreElements()) {
                System.err.println("\t-" + keys.nextElement());
            }
            System.exit(2);
        }
        int index = 0;
        while (index < args.length) {
            index = this.processParam(index, args);
        }
        Object[] resourceArr = new File[this.resources.size()];
        this.resources.copyInto(resourceArr);
        Object[] sourceArr = new File[this.sources.size()];
        this.sources.copyInto(sourceArr);
        this.invoke((File[])sourceArr, (File[])resourceArr, this.settings);
    }

    public void invoke(File[] sourceArr, File[] resourceArr, Properties settings) {
        int i = 0;
        while (i < sourceArr.length) {
            this.invoke(sourceArr[i], resourceArr, settings);
            ++i;
        }
    }

    public void invoke(File source, File[] resourceArr, Properties settings) {
        Iterator it = ConversionService.registeredSerivces();
        while (it.hasNext()) {
            ConversionService service = (ConversionService)it.next();
            if (!service.canConvert(source)) continue;
            try {
                System.err.println("Converting " + source.getPath() + "...");
                service.setProperties(settings);
                StringWriter log = new StringWriter();
                File out = service.convert(source, resourceArr, this, new PrintWriter(log));
                if (out == null) {
                    System.err.println("Error log:");
                    System.err.println(log.toString());
                }
                System.err.println("Written " + out.getPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        System.err.println("No service to convert " + source.getPath());
    }

    public File makeFile(String baseName) {
        String targetDir = this.settings.getProperty("targetDir");
        File folder = new File(targetDir);
        File file = new File(folder, baseName);
        if (file.exists()) {
            String extStr;
            String baseStr;
            int ext = baseName.indexOf(46);
            if (ext < 0) {
                baseStr = baseName;
                extStr = "";
            } else {
                baseStr = baseName.substring(0, ext);
                extStr = baseName.substring(ext);
            }
            int count = 1;
            while ((file = new File(folder, String.valueOf(baseStr) + "-" + count + extStr)).exists()) {
                ++count;
            }
        }
        return file;
    }

    public void reportIssue(String errorCode) {
        System.err.println(errorCode);
    }

    public void reportProgress(float progress) {
    }

    public static void main(String[] args) {
        new CLDriver().invoke(args);
    }
}

