/*
 * Thomas Thomassen
 * thomas[at]thomthom[dot]net
 * Copyright 2010-2013
 */

$(document).ready(init);


function init()
{
  add_callbacks();
  
  // Collect the string of all elements with l10n class and pass on to the
  // ready event. Ruby will when look up these and pass back translated
  // versions.
  var params = new Array;
  $('.l10n').each(function(index) {
    params.push( $(this).text() );
  });  

  // Signal that we're ready
  window.location = 'skp:ready@' + params.join('|');
}


function add_callbacks()
{
  // Buttons
  $('#cmdTrial').on('click', request_trial);
  $('#cmdActivateOffline').on('click', activate_offline);
  $('#cmdRemoveLicense').on( 'click', remove_license );
  $('#cmdClose').on( 'click', close_window );
  
  // Ensure links are opened in the default browser.
  $(document).on('click', 'a.url', function()
  {
    window.location = 'skp:url@' + this.href;
    return false;
  } );
}


// Make a function that takes the text of the element and use that for lookup.
function load_l10n(l10n)
{
  // All elements with l10n class.
  $('.l10n').each(function(index) {
    str = $(this).text();
    if (str in l10n)
      $(this).text( l10n[str] );
  });
}


function close_window()
{
  window.location = 'skp:close';
}


function display_page( page )
{
  $('.page').hide();
  $(page).show();
}

function display_page_home()
{
  display_page('#pageHome');
}


function is_licensed_to(email, expire)
{
  $('#licensedUser').text(email);
  if ( expire )
  {
    var expiry_date = new Date(expire * 1000); // Milliseconds to seconds.
    var current_date = new Date();
    var message = '';
    if ( current_date > expiry_date )
    {
      message = '<b>Expired!</b> Please purchase full version to continue using Vertex Tools.';
    }
    else
    {
      var diff = expiry_date - current_date;
      var seconds = diff / 1000;
      var minutes = seconds / 60;
      var hours   = minutes / 60;
      var days    = Math.ceil(hours / 24);
      message = days + ' days left of trial period.';
    }
    $('#licenseExpire').html(message);
  }
  display_page('#pageLicensed');
  $('#cmdRemoveLicense,#cmdClose').removeClass('hidden');
  $('#cmdTrial,#cmdActivateOffline').addClass('hidden');
}


function remove_license()
{
  if ( confirm('Are you sure you want to remove the license?') )
  {  
    window.location = 'skp:remove_license';
    display_page_home();
    $('#cmdRemoveLicense,#cmdClose').addClass('hidden');
    $('#cmdTrial,#cmdActivateOffline').removeClass('hidden');
  }
}


function request_trial()
{
  alert('An internet connection is required to activate a trial version.');
}


function activate_offline()
{
  activation_data = $.trim( $('#txtLicenseCode').val() );
  window.location = 'skp:response@' + activation_data;
}


function display_error(error_id)
{
  alert(error_id);
}