/*
 * Thomas Thomassen
 * thomas[at]thomthom[dot]net
 * Copyright 2010
 */

$(document).ready(init);


// Array of localised strings.
var msgs = new Array();
var langs = { 'en':
  {
    'name': 'English',
    'author': 'Thomas Thomassen',
    'contact': ''
  }
};


function init()
{
  // Add callbacks
  add_callbacks();
  
  // Collect the string of all elements with l10n class and pass on to the
  // ready event. Ruby will when look up these and pass back translated
  // versions.
  var params = new Array;
  $('.l10n').each(function(index) {
    params.push( $(this).text() );
  });
  // Messages
  params.push( 'Vertex Size must be an integer between @@1 and @@2.' );
  params.push( 'Normal Size must be an integer between @@1 and @@2.' );
  
  // Signal that we're ready
  window.location = 'skp:ready@' + params.join('|');
}


function add_callbacks()
{
  // Language
  $('#lstLang').on( 'change', function() {
    language = langs[ $(this).val() ];
    $('#translator .author').text( language['author'] );
    // Add conact link:
    if ( language['contact'].match(/(http(s)?:\/\/|mailto:)/) )
      $('#translator .author').wrapInner('<a href="'+language['contact']+'" class="url" target="_new" />');
  });
  
  // Save
  $('#cmdSave').click( function() {
    // Validate, abort on error.
    var vs = parseInt( $('#txtVertexSize').val() );
    var ns = parseInt( $('#txtNormalSize').val() );
    
    if ( !valid_int(vs, 4, 10, msgs['VertexSize']) )
      return false;
      
    if ( !valid_int(ns, 4, 99, msgs['NormalSize']) )
      return false;
    
    // Set Checkbox values to reflect checked state so SU Ruby's
    $('input[type=checkbox]').val( function(index,value){
      return $(this).is(':checked').toString()
    } );
    
    // Everything validated, save the settings.
    window.location = 'skp:save';
  } );
  
  // Cancel
  $('#cmdCancel').on( 'click', function() { window.location = 'skp:cancel'; } );
  
  // Ensure links are opened in the default browser.
  $(document).on('click', 'a.url', function()
  {
    window.location = 'skp:url@' + this.href;
    return false;
  } );
}


// Make a function that takes the text of the element and use that for lookup.
function load_l10n(l10n)
{
  // All elements with l10n class.
  $('.l10n').each(function(index) {
    str = $(this).text();
    if (str in l10n)
      $(this).text( l10n[str] );
  });

  // Messages
  msgs['VertexSize'] = l10n['Vertex Size must be an integer between @@1 and @@2.'];
  msgs['NormalSize'] = l10n['Normal Size must be an integer between @@1 and @@2.'];
}


function load_settings(settings)
{
  $('#lstLang').val( settings['Language'] );
  $('#txtVertexSize').val( settings['VertexSize'] );
  $('#txtNormalSize').val( settings['NormalSize'] );
  $('#lstInitialTool').val( settings['InitialTool'] );
  $('#chkContextMenu').prop('checked', settings['ContextMenu']);
  $('#lstLang').change();
}


function load_language_list(languages)
{
  list = $('#lstLang');
  for (i in languages)
  {
    list.append('<option value="' + i + '">' + languages[i]['name'] + '</option>');
    langs[i] = languages[i];
  }
}


// Ensures that the given integer is between the valid range.
// Display an message to the user upon error.
function valid_int(integer, min, max, error_message)
{
  integer = parseInt(integer);
  if ( isNaN(integer) || integer < min || integer > max)
  {
    message = error_message.replace( '@@1', min.toString() ).replace( '@@2', max.toString() )
    alert(message);
    return false;
  }
  return true;
}


function update_check(version, license)
{
  var UP_TO_DATE                = 0;
  var UPDATE_AVAILIBLE          = 1;
  var FAILURE                   = 2;
  var FAILURE_ARGUMENTS_MISSING = 3;
  var FAILURE_USER_NOT_FOUND    = 4;

  url = 'http://www.thomthom.net/software/vertex_tools/api/update_check';
  //url = 'http://localhost/software/vertex_tools/api/update_check';
  user_data = {
    'version' : version,
    'license' : license
  }

  var jqxhr = $.getJSON( url + "?callback=?", user_data, function(data)
  {
    if ( data.response_code == UPDATE_AVAILIBLE )
    {
      alert(data.response_data);
    }
  })
  /*
  .fail(function(xhr, textStatus)
  {
    alert('Error: ' + textStatus + '\nPlease try again shortly.' );
  })
  */
}