function AIP(container,option)
{
    this.aip = null;
    var def = {
        id : "aip",
        prefix : "AIP_",
        width : "100%",
        height : "100%",
        fileBae64 : "",
        fileURL : "",
        convert : 0,
        loginUser : "HWSEALDEMO",
        loginType : 4,
        loginAccess : 65535,
        loginPass : "DEMO",
        debug : false
    };
    var p = extend(def,option,true);
    
    this.id = p.id;
    this.prefix = p.prefix;
    this.width = p.width;
    this.height = p.height;
    this.fileBae64 = p.fileBae64;
    this.fileURL = p.fileURL;
    this.convert = p.convert;
    this.loginUser = p.loginUser;
    this.loginType = p.loginType;
    this.loginAccess = p.loginAccess;
    this.loginPass = p.loginPass;
    this.debug = p.debug;
    
    this.Load(container);
}

AIP.prototype.Load = function(container)
{
    var s = "";
    s += '<object id="' + this.prefix + this.id + '" style="width:' + this.width + ';height:' + this.height + ';" codebase="/module/AIP/HWPostil_trial.cab#version=3,1,2,0" classid="clsid:FF3FE7A0-0578-4FEE-A54E-FB21B277D567">';
    s += '<param name="_Version" value="65536">';
    s += '<param name="_ExtentX" value="17410">';
    s += '<param name="_ExtentY" value="10874">';
    s += '<param name="_StockProps" value="0">';
    s += '</object>';
    s += '<input type="hidden" name="'+this.prefix+'DATA' + this.id + '" value="' + this.fileBae64 + '">';
    
    document.getElementById(container).innerHTML = s;
    this.aip = document.getElementById(this.prefix + this.id);
}

/**
 * ǩİʽؼ 091013
 * readOnlyFlag1-ðʽΪֻ0ʾд
 * moduleNameԴsign-ǩ棻print-ӡ
 */
AIP.prototype.OnCtrlReady = function(readOnlyFlag, moduleName)
{
    this.aip.ShowDefMenu = 0 ;							        // ز˵ 0Ϊ; 1Ϊʾ
    this.aip.ShowScrollBarButton = 1;						    // ˮƽԵĹ
    this.aip.ShowToolBar = 0;								    // ع 0Ϊ; 1Ϊʾ
    
    if(this.fileBae64 != "")
    {
       var ErrCode = this.aip.LoadFileBase64(this.fileBae64);
       if(ErrCode != 0 && this.debug == true)
          alert(this.GetErrDesc(ErrCode));
    }
    else if(this.fileURL != "")
    {
       var ErrCode = this.aip.LoadFile(this.fileURL);
       if(ErrCode != 0 && this.debug == true)
          alert(this.GetErrDesc(ErrCode));
    }
}

/**
 * дİʽؼ 091013
 * 
 */
AIP.prototype.OnCtrlReadySign = function(userType)
{
    this.aip.ShowDefMenu = 1 ;					    // ز˵ 0Ϊ; 1Ϊʾ
    this.aip.ShowScrollBarButton = 0;				// ˮƽԵĹ
    this.aip.ShowToolBar = 1;						// ع 0Ϊ; 1Ϊʾ
}
/**
 * ڴӡİʽؼ 110111
 * 
 */
AIP.prototype.OnCtrlReadyPrint = function(userType)
{
    this.aip.ShowDefMenu = 1 ;					    // ز˵ 0Ϊ; 1Ϊʾ
    this.aip.ShowScrollBarButton = 0;				// ˮƽԵĹ
    this.aip.ShowToolBar = 1;						// ع 0Ϊ; 1Ϊʾ
}

AIP.prototype.Login = function()
{
    var ErrCode = this.aip.Login(this.loginUser, this.loginType, this.loginAccess, this.loginPass, "");
    if(ErrCode != 0)
        alert(this.GetErrDesc(ErrCode));
}

AIP.prototype.SetSize = function(width, height)
{
    this.width = width;
    this.height = height;
}

AIP.prototype.SetCurrAction = function(action)
{
    this.aip.CurrAction = action;
}

AIP.prototype.SetFileBase64 = function(data)
{
    this.fileBae64 = data;
}

AIP.prototype.SetFileURL = function(url)
{
    this.fileURL = url;
}

AIP.prototype.SetLoginUser = function(name, type, access, pass)
{
    this.loginUser = name;
    this.loginType = type;
    this.loginAccess = access;
    this.loginPass = pass;
}

AIP.prototype.GetValue = function(name)
{
    return this.aip.GetValue(name);
}

AIP.prototype.GetCurrFileBase64 = function()
{
    return this.aip.GetCurrFileBase64();
}

AIP.prototype.DoReset = function()
{
    this.aip.UndoAll();
}

AIP.prototype.InsertNote = function(data, type, field, posX)
{
    var NoteInfo;
    var NoteCount = 0;
    var docHeight = 0;
    while(NoteInfo = this.aip.GetNextNote("HWSEALDEMOADMIN", 0, NoteInfo))
    {
       NoteCount++;
    }
    
    var NoteName = this.aip.InsertNote(field + NoteCount, this.aip.CurrPage, type, posX, docHeight, 1, 1);
    if(NoteName)
    {
       this.aip.SetValue(NoteName, data);
       this.aip.SetValue(NoteName, ":PROP:BORDER:0");
       this.aip.SetValue(NoteName, ":PROP::LABEL:1");
    }
    
    return NoteName;
}

AIP.prototype.LoadFileBase64 = function(data)
{
    var ErrCode = this.aip.LoadFileBase64(data);
    if(ErrCode != 0 && this.debug == true)
        alert(this.GetErrDesc(ErrCode));
}

AIP.prototype.GetErrDesc = function(ErrCode)
{
    switch(ErrCode)
    {
        case 0: return td_lang.global.right;//"ȷ"
        case -1: return td_lang.module.msg_1;//"AIPæԺ"
        case -2: return td_lang.module.msg_2;//"ЧǷ"
        case -3: return td_lang.module.msg_3;//"δ֪Ӵ"
        case -5: return td_lang.module.msg_4;//"Чϵͳֱ֧"
        case -6: return td_lang.module.msg_5;//"ϵͳֱ֧"
        case -7: return td_lang.module.msg_6;//"ݰʽݴ䲻ȷ"
        case -8: return td_lang.module.msg_7;//"ʱ䲻ܾ¼뱣֤ʱͷʱʮ֮"
        
        case -11: return td_lang.module.msg_8;//"ָ֤Ѿϣ޷ʹ"
        case -12: return td_lang.module.msg_9;//"ָ֤Ѿڣ޷ʹ"
        case -13: return td_lang.module.msg_10;//"ݿδֱûӦ֤"
        
        case -20: return td_lang.module.msg_36;//"Ȩ޴󣬱ûȨʹָӡ"
        case -21: return td_lang.module.msg_37;//"ָӡѾϣ޷ʹ"
        case -22: return td_lang.module.msg_38;//"ָӡѾڣ޷ʹ"
        case -23: return td_lang.module.msg_39;//"ָӡ²"
        
        case -30: return td_lang.module.msg_40;//"Ȩ޴Ȩĵ"
        case -31: return td_lang.module.msg_41;//"ĵѾȨ"
        case -33: return td_lang.module.msg_42;//"ָĵ"
        case -35: return td_lang.module.msg_43;//"Ȩ޴Ȩӡĵ"
        case -36: return td_lang.module.msg_44;//"ĵӡ꣬Ȩӡĵ"
        
        case -40: return td_lang.module.msg_45;//"򿪷ݿʧ"
        case -41: return td_lang.module.msg_46;//"·ݿʧ"
        case -42: return td_lang.module.msg_59;//"ȡݿʧ"
        case -43: return td_lang.module.msg_60;//"ݿʧ"
        
        case -50: return td_lang.module.msg_61;//"ûûе¼޷б"
        case -51: return td_lang.module.msg_62;//"û¼"
        case -52: return td_lang.module.msg_63;//"ûѱ"
        case -53: return td_lang.module.msg_64;//"ָû"
        case -54: return td_lang.module.msg_65;//"û벻ϸʽϵԱ"
        case -55: return td_lang.module.msg_66;//"δֵǰû֤Ϣ"
        
        case -70: return td_lang.module.msg_67;//"δעᣬϵԱ"
        case -71: return td_lang.module.msg_68;//"ûȨϵԱ"
        case -72: return td_lang.module.msg_69;//"ûڱϵԱ"
        case -73: return td_lang.module.msg_70;//"ִֵ֧¼ʽ"
        case -74: return td_lang.module.msg_71;//"˴ʱ"
        case -75: return td_lang.module.msg_72;//"˷δ֪ϵԱ"
        
        case -100: return td_lang.module.msg_73;//"ַЧ뱣֤IP:Port(ֱ)HTTP URL(http://www.xx.com:8080/aipserver.jsp)"
        case -101: return td_lang.module.msg_74;//"ӳʱ"
        case -102: return td_lang.module.msg_75;//"ûȡ"
        case -103: return td_lang.module.msg_76;//"ûIDӦ'HWSEALDEMO'ʼ"
        case -104: return td_lang.module.msg_77;//"δûб"
        
        case -110: return td_lang.module.msg_78;//"û¼"
        case -111: return td_lang.module.msg_79;//"ִ󣬲ֹ"
        
        case -120: return td_lang.module.msg_80;//"ЧĶ"
        case -121: return td_lang.module.msg_81;//"Чݴ"
        case -122: return td_lang.module.msg_82;//"ЧĴ"
        case -123: return td_lang.module.msg_83;//"Ч"
        
        case -130: return td_lang.module.msg_84;//"У"
        case -131: return td_lang.module.msg_85;//"ڴ޷"
        
        case -140: return td_lang.module.msg_86;//"Ȩ"
        case -141: return td_lang.module.msg_87;//""
        case -142: return td_lang.module.msg_88;//"δ֪"
        
        case -200: return td_lang.module.msg_89;//"ûвܿ"
        case -201: return td_lang.module.msg_90;//"ܿ¼PIN"
        case -202: return td_lang.module.msg_91;//"ϵͳδЧ˽Կ"
        case -203: return td_lang.module.msg_92;//"ϵͳδЧ֤"
        case -204: return td_lang.module.msg_93;//"CSP"
        case -205: return td_lang.module.msg_94;//"ڶܿ"
        case -206: return td_lang.module.msg_95;//"CSPδװ,ȷѾװȷܿ"
        case -209: return td_lang.module.msg_96;//"ܿгδ֪"
        
        case -210: return td_lang.module.msg_97;//"֤δͨ"
        case -211: return td_lang.module.msg_98;//"ܿвӡ"
        
        default : return td_lang.module.msg_88;//"δ֪"
    }
}

function extend(des, src, override){
    if(src instanceof Array){
        for(var i = 0, len = src.length; i < len; i++)
             extend(des, src[i], override);
    }
    for( var i in src){
        if(override || !(i in des)){
            des[i] = src[i];
        }
    } 
    return des;
}