/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.DecoderOutput;
import com.flazr.DefaultInvokeResultHandler;
import com.flazr.FlvWriter;
import com.flazr.RtmpDecoder;
import com.flazr.RtmpSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.mina.common.ByteBuffer;

public class Utils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char BYTE_SEPARATOR = ' ';

    public static int readInt24(ByteBuffer in) {
        byte a = in.get();
        byte b = in.get();
        byte c = in.get();
        int val = 0;
        val = a < 0 ? (val += a + 256 << 16) : (val += a << 16);
        val = b < 0 ? (val += b + 256 << 8) : (val += b << 8);
        val = c < 0 ? (val += c + 256) : (val += c);
        return val;
    }

    public static void writeInt24(ByteBuffer out, int value) {
        out.put((byte)(0xFF & value >> 16));
        out.put((byte)(0xFF & value >> 8));
        out.put((byte)(0xFF & value >> 0));
    }

    public static int readInt32Reverse(ByteBuffer in) {
        byte a = in.get();
        byte b = in.get();
        byte c = in.get();
        byte d = in.get();
        int val = 0;
        val += d << 24;
        val += c << 16;
        val += b << 8;
        return val += a;
    }

    public static void writeInt32Reverse(ByteBuffer out, int value) {
        out.put((byte)(0xFF & value));
        out.put((byte)(0xFF & value >> 8));
        out.put((byte)(0xFF & value >> 16));
        out.put((byte)(0xFF & value >> 24));
    }

    public static String toHex(byte[] ba) {
        return Utils.toHex(ba, true);
    }

    public static String toHex(byte[] ba, boolean withSeparator) {
        return Utils.toHex(ba, 0, ba.length, withSeparator);
    }

    public static String toHex(byte[] ba, int offset, int length, boolean withSeparator) {
        char[] buf = withSeparator ? new char[length * 3] : new char[length * 2];
        int i = offset;
        int j = 0;
        while (i < offset + length) {
            char[] chars = Utils.toHexChars(ba[i++]);
            buf[j++] = chars[0];
            buf[j++] = chars[1];
            if (!withSeparator) continue;
            buf[j++] = 32;
        }
        return new String(buf);
    }

    private static char[] toHexChars(int b) {
        char left = HEX_DIGITS[b >>> 4 & 0xF];
        char right = HEX_DIGITS[b & 0xF];
        return new char[]{left, right};
    }

    public static String toHex(byte b) {
        char[] chars = Utils.toHexChars(b);
        return chars[0] + "" + chars[1];
    }

    public static byte[] fromHex(char[] hex) {
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            raw[i] = (byte)value;
        }
        return raw;
    }

    public static byte[] fromHex(String s) {
        String temp = s.replace(" ", "");
        return Utils.fromHex(temp.toCharArray());
    }

    public static ByteBuffer removeChunkDelimiters(byte[] bytes, int chunkSize) {
        ByteBuffer buffer = ByteBuffer.allocate((int)bytes.length);
        int i = 0;
        for (byte b : bytes) {
            if (i == chunkSize) {
                i = 0;
                continue;
            }
            buffer.put(b);
            ++i;
        }
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer toByteBuffer(char[] chars, int chunkSize) {
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return Utils.removeChunkDelimiters(bytes, chunkSize);
    }

    public static CharSequence readAsString(String fileName) {
        return Utils.readAsString(new File(fileName));
    }

    public static CharSequence readAsString(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            String s;
            FileInputStream fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            while ((s = reader.readLine()) != null) {
                sb.append(s);
            }
            return sb;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readAsByteArray(String fileName) {
        File file = new File(fileName);
        return Utils.readAsByteArray(file, file.length());
    }

    public static byte[] readAsByteArray(String fileName, int length) {
        return Utils.readAsByteArray(new File(fileName), (long)length);
    }

    public static byte[] readAsByteArray(File file) {
        return Utils.readAsByteArray(file, file.length());
    }

    public static byte[] readAsByteArray(File file, long length) {
        try {
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            FileInputStream is = new FileInputStream(file);
            for (int offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            is.close();
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void convert(String inFileName, String outFileName) {
        FlvWriter flvWriter = new FlvWriter(outFileName);
        DecoderOutput decoderOutput = new DecoderOutput(){

            public void write(Object packet) {
            }

            public void disconnect() {
            }
        };
        RtmpSession session = new RtmpSession();
        session.setFlvWriter(flvWriter);
        session.setDecoderOutput(decoderOutput);
        session.setInvokeResultHandler(new DefaultInvokeResultHandler());
        byte[] bytes = Utils.readAsByteArray(inFileName);
        ByteBuffer buf = ByteBuffer.wrap((byte[])bytes);
        int prevPosition = -1;
        while (prevPosition < buf.position()) {
            prevPosition = buf.position();
            RtmpDecoder.decode(buf, session);
        }
        flvWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOverHttp(String url) {
        HttpClient client = new HttpClient();
        String response = null;
        GetMethod get = new GetMethod(url);
        try {
            client.executeMethod((HttpMethod)get);
            response = get.getResponseBodyAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            get.releaseConnection();
        }
        return response;
    }
}

