/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.DecoderOutput;
import com.flazr.DefaultInvokeResultHandler;
import com.flazr.FlvWriter;
import com.flazr.Handshake;
import com.flazr.Header;
import com.flazr.Invoke;
import com.flazr.InvokeResultHandler;
import com.flazr.Packet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtmpSession {
    private static final String RTMP_SESSION_KEY = "RTMP_SESSION_KEY";
    private boolean serverHandshakeReceived;
    private Map<Integer, Header> prevHeadersIn = new ConcurrentHashMap<Integer, Header>();
    private Map<Integer, Header> prevHeadersOut = new ConcurrentHashMap<Integer, Header>();
    private Map<Integer, Packet> prevPacketsIn = new ConcurrentHashMap<Integer, Packet>();
    private Map<Integer, String> invokedMethods = new ConcurrentHashMap<Integer, String>();
    private int chunkSize = 128;
    private int nextInvokeId;
    private int bytesReadLastSent;
    private int bytesRead;
    private Map<String, Object> connectParams;
    private String playName;
    private int playStart;
    private int playDuration = -2;
    private FlvWriter flvWriter;
    private DecoderOutput decoderOutput;
    private String host;
    private int port;
    private InvokeResultHandler invokeResultHandler;

    public RtmpSession() {
    }

    public RtmpSession(String host, int port, String app, String playName, String saveFileName) {
        this.host = host;
        this.port = port;
        this.playName = playName;
        this.flvWriter = new FlvWriter(saveFileName);
        String tcUrl = "rtmp://" + host + ":" + port + "/" + app;
        this.connectParams = new HashMap<String, Object>();
        this.connectParams.put("objectEncoding", 0);
        this.connectParams.put("app", app);
        this.connectParams.put("flashVer", "WIN 9,0,115,0");
        this.connectParams.put("fpad", false);
        this.connectParams.put("tcUrl", tcUrl);
        this.connectParams.put("audioCodecs", 1639);
        this.connectParams.put("videoFunction", 1);
        this.connectParams.put("capabilities", 15);
        this.connectParams.put("videoCodecs", 252);
        this.invokeResultHandler = new DefaultInvokeResultHandler();
    }

    public static RtmpSession getFrom(IoSession ioSession) {
        return (RtmpSession)ioSession.getAttribute(RTMP_SESSION_KEY);
    }

    public void putInto(IoSession ioSession) {
        ioSession.setAttribute(RTMP_SESSION_KEY, (Object)this);
    }

    public void send(Handshake handshake) {
        this.decoderOutput.write(handshake);
    }

    public void send(Packet packet) {
        this.decoderOutput.write(packet);
    }

    public void send(Invoke invoke) {
        this.send(invoke.encode(this));
    }

    public String resultFor(Invoke invoke) {
        return this.getInvokedMethods().get(invoke.getSequenceId());
    }

    public InvokeResultHandler getInvokeResultHandler() {
        return this.invokeResultHandler;
    }

    public void setInvokeResultHandler(InvokeResultHandler invokeResultHandler) {
        this.invokeResultHandler = invokeResultHandler;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getPlayStart() {
        return this.playStart;
    }

    public void setPlayStart(int playStart) {
        this.playStart = playStart;
    }

    public DecoderOutput getDecoderOutput() {
        return this.decoderOutput;
    }

    public void setDecoderOutput(DecoderOutput decoderOutput) {
        this.decoderOutput = decoderOutput;
    }

    public FlvWriter getFlvWriter() {
        return this.flvWriter;
    }

    public void setFlvWriter(FlvWriter flvWriter) {
        this.flvWriter = flvWriter;
    }

    public int getPlayDuration() {
        return this.playDuration;
    }

    public void setPlayDuration(int playDuration) {
        this.playDuration = playDuration;
    }

    public String getPlayName() {
        return this.playName;
    }

    public void setPlayName(String playName) {
        this.playName = playName;
    }

    public Map<String, Object> getConnectParams() {
        return this.connectParams;
    }

    public void setConnectParams(Map<String, Object> connectParams) {
        this.connectParams = connectParams;
    }

    public int incrementBytesRead(int size) {
        this.bytesRead += size;
        return this.bytesRead;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public int getBytesReadLastSent() {
        return this.bytesReadLastSent;
    }

    public void setBytesReadLastSent(int bytesReadLastSent) {
        this.bytesReadLastSent = bytesReadLastSent;
    }

    public Map<Integer, String> getInvokedMethods() {
        return this.invokedMethods;
    }

    public int getNextInvokeId() {
        return ++this.nextInvokeId;
    }

    public boolean isServerHandshakeReceived() {
        return this.serverHandshakeReceived;
    }

    public void setServerHandshakeReceived(boolean serverHandshakeReceived) {
        this.serverHandshakeReceived = serverHandshakeReceived;
    }

    public Map<Integer, Header> getPrevHeadersIn() {
        return this.prevHeadersIn;
    }

    public Map<Integer, Header> getPrevHeadersOut() {
        return this.prevHeadersOut;
    }

    public Map<Integer, Packet> getPrevPacketsIn() {
        return this.prevPacketsIn;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }
}

