/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.Handshake;
import com.flazr.Packet;
import com.flazr.RtmpSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpEncoder
implements ProtocolEncoder {
    private static final Logger logger = LoggerFactory.getLogger(RtmpEncoder.class);

    public void encode(IoSession ioSession, Object object, ProtocolEncoderOutput out) {
        RtmpSession session = RtmpSession.getFrom(ioSession);
        if (object instanceof Handshake) {
            Handshake hs = (Handshake)object;
            out.write(hs.getData());
            if (logger.isDebugEnabled()) {
                String temp = session.isServerHandshakeReceived() ? "2" : "1";
                logger.debug("sending handshake" + temp + ": " + hs.getData());
            }
            return;
        }
        Packet packet = (Packet)object;
        ByteBuffer buffer = packet.encode(session.getChunkSize());
        out.write(buffer);
        if (logger.isDebugEnabled()) {
            logger.debug("sent packet data: " + buffer);
        }
    }

    public void dispose(IoSession session) throws Exception {
    }
}

