/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.AmfObject;
import com.flazr.Handshake;
import com.flazr.Header;
import com.flazr.Invoke;
import com.flazr.Packet;
import com.flazr.RtmpSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpDecoder
extends CumulativeProtocolDecoder {
    private static final Logger logger = LoggerFactory.getLogger(RtmpDecoder.class);

    protected boolean doDecode(IoSession ioSession, ByteBuffer in, ProtocolDecoderOutput _unused) {
        return RtmpDecoder.decode(in, RtmpSession.getFrom(ioSession));
    }

    public static boolean decode(ByteBuffer in, RtmpSession session) {
        if (!session.isServerHandshakeReceived()) {
            Handshake hs = new Handshake();
            if (!hs.decodeServerResponse(in, session)) {
                return false;
            }
            session.setServerHandshakeReceived(true);
            logger.info("received server handshake, sending reply");
            session.send(hs.generateClientRequest2());
            session.send(new Invoke("connect", 3, session.getConnectParams()));
            return true;
        }
        int position = in.position();
        Packet packet = new Packet();
        if (!packet.decode(in, session)) {
            logger.debug("buffering...");
            in.position(position);
            return false;
        }
        int bytesReadNow = in.position() - position;
        int bytesReadSoFar = session.incrementBytesRead(bytesReadNow);
        if (bytesReadSoFar > session.getBytesReadLastSent() + 614400) {
            Header brHeader = new Header(Header.Type.MEDIUM, 2, Packet.Type.BYTES_READ);
            ByteBuffer brBody = ByteBuffer.allocate((int)4);
            brBody.putInt(bytesReadSoFar);
            Packet brp = new Packet(brHeader, brBody);
            logger.info("sending bytes read " + bytesReadSoFar + ": " + brp);
            session.send(brp);
            session.setBytesReadLastSent(bytesReadSoFar);
        }
        if (!packet.isComplete()) {
            return true;
        }
        ByteBuffer data = packet.getData();
        switch (packet.getHeader().getPacketType()) {
            case CHUNK_SIZE: {
                int newChunkSize = data.getInt();
                session.setChunkSize(newChunkSize);
                logger.info("new chunk size is: " + newChunkSize);
                break;
            }
            case CONTROL_MESSAGE: {
                short type;
                if (logger.isDebugEnabled()) {
                    logger.debug("received control message: " + packet);
                }
                if ((type = data.getShort()) != 6) break;
                int time = data.getInt();
                data.rewind();
                logger.info("server ping: " + packet);
                Packet pong = Packet.ping(7, time, -1);
                logger.info("client pong: " + pong);
                session.send(pong);
                break;
            }
            case AUDIO_DATA: 
            case VIDEO_DATA: {
                session.getFlvWriter().write(packet);
                break;
            }
            case FLV_DATA: {
                session.getFlvWriter().writeFlvData(data);
                break;
            }
            case NOTIFY: {
                AmfObject notify = new AmfObject();
                notify.decode(data, false);
                String notifyMethod = notify.getFirstPropertyAsString();
                logger.info("server notify: " + notify);
                if (!notifyMethod.equals("onMetaData")) break;
                logger.info("notify is 'onMetadata', writing metadata");
                data.rewind();
                session.getFlvWriter().write(packet);
                break;
            }
            case INVOKE: {
                Invoke serverInvoke = new Invoke();
                serverInvoke.decode(packet);
                String methodName = serverInvoke.getMethodName();
                if (methodName.equals("_result")) {
                    session.getInvokeResultHandler().handle(serverInvoke, session);
                    break;
                }
                if (methodName.equals("onStatus")) {
                    AmfObject temp = serverInvoke.getSecondArgAsAmfObject();
                    String code = (String)temp.getProperty("code").getValue();
                    logger.info("onStatus code: " + code);
                    if (!code.equals("NetStream.Failed") && !code.equals("NetStream.Play.Failed") && !code.equals("NetStream.Play.Stop")) break;
                    logger.info("disconnecting");
                    session.getDecoderOutput().disconnect();
                    break;
                }
                logger.warn("unhandled server invoke: " + serverInvoke);
                break;
            }
            case BYTES_READ: 
            case SERVER_BANDWIDTH: 
            case CLIENT_BANDWIDTH: {
                logger.info("ignoring received packet: " + packet.getHeader());
                break;
            }
            default: {
                throw new RuntimeException("unknown packet type: " + packet.getHeader());
            }
        }
        return true;
    }
}

