/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.DecoderOutput;
import com.flazr.Handshake;
import com.flazr.RtmpDecoder;
import com.flazr.RtmpEncoder;
import com.flazr.RtmpSession;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpClient
extends IoHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(RtmpClient.class);
    private static final int CONNECT_TIMEOUT = 3000;
    private RtmpSession session;

    public static void main(String[] args) {
        String host = "68.180.128.37";
        int port = 1935;
        String app = "StreamCache";
        String playName = "p09r19/151/__S__/lauvsf/73350301?StreamID=73350301&xdata=NDI3MzQzMzg2NDk4ZWFlZj-201634733-0&pl_auth=36697f74ed4dbf3a5ef9fd7b9a649b3a&ht=180&b=7mb3q9d4n5jq6498eaef6&s=396502118&br=110&q=La5lvngAY9OUa.Yq6R2R.q&rd=new.music.yahoo.com&so=%2FMUSIC";
        String saveFileName = "test.flv";
        RtmpSession session = new RtmpSession(host, port, app, playName, saveFileName);
        RtmpClient.connect(session);
    }

    private RtmpClient() {
    }

    public static void connect(RtmpSession session) {
        RtmpClient client = new RtmpClient();
        client.session = session;
        SocketConnector connector = new SocketConnector();
        connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new RtmpCodecFactory()));
        connector.connect((SocketAddress)new InetSocketAddress(session.getHost(), session.getPort()), (IoHandler)client);
    }

    public void sessionOpened(IoSession ioSession) {
        this.session.setDecoderOutput(new MinaIoSessionOutput(ioSession));
        this.session.putInto(ioSession);
        logger.info("session opened, starting handshake");
        ioSession.write((Object)Handshake.generateClientRequest1(this.session));
    }

    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        logger.error("exceptionCaught: ", cause);
        RtmpClient.disconnect(ioSession);
    }

    public static void disconnect(IoSession ioSession) {
        ioSession.close().join(3000L);
        RtmpSession session = RtmpSession.getFrom(ioSession);
        session.getFlvWriter().close();
        logger.info("disconnected, bytes read: " + session.getBytesRead());
        System.exit(0);
    }

    private static class MinaIoSessionOutput
    implements DecoderOutput {
        private IoSession ioSession;

        public MinaIoSessionOutput(IoSession ioSession) {
            this.ioSession = ioSession;
        }

        public void write(Object packet) {
            this.ioSession.write(packet);
        }

        public void disconnect() {
            RtmpClient.disconnect(this.ioSession);
        }
    }

    private static class RtmpCodecFactory
    implements ProtocolCodecFactory {
        private ProtocolEncoder encoder = new RtmpEncoder();
        private ProtocolDecoder decoder = new RtmpDecoder();

        private RtmpCodecFactory() {
        }

        public ProtocolDecoder getDecoder() {
            return this.decoder;
        }

        public ProtocolEncoder getEncoder() {
            return this.encoder;
        }
    }
}

