/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.ByteToEnum;
import com.flazr.Header;
import com.flazr.RtmpSession;
import com.flazr.Utils;
import org.apache.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Packet {
    private static final Logger logger = LoggerFactory.getLogger(Packet.class);
    private Header header;
    private ByteBuffer data;
    private boolean complete;

    public Packet() {
    }

    public Packet(Header header, ByteBuffer data) {
        this.header = header;
        data.flip();
        this.data = data;
        header.setSize(data.limit());
    }

    public Packet(Header header, int dataSize) {
        this.header = header;
        this.data = ByteBuffer.allocate((int)dataSize);
    }

    public static Packet serverBw(int value) {
        Header header = new Header(Header.Type.LARGE, 2, Type.SERVER_BANDWIDTH);
        ByteBuffer body = ByteBuffer.allocate((int)8);
        body.putInt(value);
        return new Packet(header, body);
    }

    public static Packet ping(int type, int target, int bufferTime) {
        Header header = new Header(Header.Type.MEDIUM, 2, Type.CONTROL_MESSAGE);
        ByteBuffer body = ByteBuffer.allocate((int)10);
        body.putShort((short)type);
        body.putInt(target);
        if (type == 3) {
            body.putInt(bufferTime);
        }
        return new Packet(header, body);
    }

    public Header getHeader() {
        return this.header;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean decode(ByteBuffer in, RtmpSession session) {
        byte[] bytes;
        int chunkSize;
        int toReadNow;
        int position = in.position();
        this.header = new Header();
        if (!this.header.decode(in, session)) {
            return false;
        }
        int channelId = this.header.getChannelId();
        Packet prevPacket = session.getPrevPacketsIn().get(channelId);
        int toReadRemaining = this.header.getSize();
        if (prevPacket != null) {
            toReadRemaining -= prevPacket.getData().position();
        }
        int n = toReadNow = toReadRemaining > (chunkSize = session.getChunkSize()) ? chunkSize : toReadRemaining;
        if (in.remaining() < toReadNow) {
            return false;
        }
        session.getPrevHeadersIn().put(channelId, this.header);
        if (prevPacket == null) {
            prevPacket = new Packet(this.header, this.header.getSize());
            session.getPrevPacketsIn().put(channelId, prevPacket);
        } else {
            logger.debug("continuing prev header: " + prevPacket.header);
            this.header.setRelative(prevPacket.header.isRelative());
        }
        if (logger.isDebugEnabled()) {
            bytes = new byte[in.position() - position];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = in.get(position + i);
            }
            logger.debug("decoded header: " + this.header + " <-- " + Utils.toHex(bytes));
        }
        this.data = prevPacket.getData();
        bytes = new byte[toReadNow];
        in.get(bytes);
        this.data.put(bytes);
        if (logger.isDebugEnabled()) {
            logger.debug("chunk bytes read {}: {}", (Object)toReadNow, (Object)Utils.toHex(bytes));
        }
        if (this.data.position() == this.header.getSize()) {
            this.complete = true;
            session.getPrevPacketsIn().remove(channelId);
            this.data.flip();
            if (logger.isDebugEnabled()) {
                logger.debug("decoded packet: " + this.toString());
            }
        }
        return true;
    }

    public ByteBuffer encode(int chunkSize) {
        ByteBuffer buffer = ByteBuffer.allocate((int)1024);
        this.header.encode(buffer);
        int remaining = this.header.getSize();
        while (true) {
            int toWrite = remaining > chunkSize ? chunkSize : remaining;
            byte[] bytes = new byte[toWrite];
            this.data.get(bytes);
            buffer.put(bytes);
            if ((remaining -= chunkSize) <= 0) break;
            Header tiny = new Header(Header.Type.TINY, this.header.getChannelId(), this.header.getPacketType());
            tiny.encode(buffer);
        }
        buffer.flip();
        return buffer;
    }

    public String toString() {
        return this.data.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements ByteToEnum.Convert
    {
        CHUNK_SIZE(1),
        BYTES_READ(3),
        CONTROL_MESSAGE(4),
        SERVER_BANDWIDTH(5),
        CLIENT_BANDWIDTH(6),
        AUDIO_DATA(8),
        VIDEO_DATA(9),
        FLEX_STREAM_SEND(15),
        FLEX_SHARED_OBJECT(16),
        FLEX_MESSAGE(17),
        NOTIFY(18),
        SHARED_OBJECT(19),
        INVOKE(20),
        FLV_DATA(22);

        private final byte value;
        private static ByteToEnum<Type> converter;

        private Type(int value) {
            this.value = (byte)value;
        }

        @Override
        public byte byteValue() {
            return this.value;
        }

        public static Type parseByte(byte b) {
            return converter.parseByte(b);
        }

        public String toString() {
            return converter.toString(this);
        }

        static {
            converter = new ByteToEnum((Enum[])Type.values());
        }
    }
}

