/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.AmfObject;
import com.flazr.AmfProperty;
import com.flazr.Header;
import com.flazr.Packet;
import com.flazr.RtmpSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invoke {
    private static final Logger logger = LoggerFactory.getLogger(Invoke.class);
    private String methodName;
    private int sequenceId;
    private int channelId;
    private int time;
    private int streamId = -1;
    private Object[] args;

    public Invoke() {
    }

    public Invoke(String methodName, int channelId, Object ... args) {
        this.methodName = methodName;
        this.channelId = channelId;
        this.args = args;
    }

    public Invoke(int streamId, String methodName, int channelId, Object ... args) {
        this(methodName, channelId, args);
        this.streamId = streamId;
    }

    public int getLastArgAsInt() {
        return new Double(this.args[this.args.length - 1].toString()).intValue();
    }

    public AmfObject getSecondArgAsAmfObject() {
        return (AmfObject)this.args[1];
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Packet encode(RtmpSession session) {
        this.sequenceId = session.getNextInvokeId();
        session.getInvokedMethods().put(this.sequenceId, this.methodName);
        Header prevHeader = session.getPrevHeadersOut().get(this.channelId);
        Header.Type headerType = prevHeader == null ? Header.Type.LARGE : Header.Type.MEDIUM;
        Header header = new Header(headerType, this.channelId, Packet.Type.INVOKE);
        if (this.streamId != -1) {
            header.setStreamId(this.streamId);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.methodName);
        list.add(this.sequenceId);
        if (this.args != null && this.args.length > 0) {
            for (Object arg : this.args) {
                if (arg instanceof Map) {
                    list.add(new AmfObject((Map)arg));
                    continue;
                }
                list.add(arg);
            }
        } else {
            list.add(null);
        }
        header.setTime(this.time);
        ByteBuffer body = AmfProperty.encode(list.toArray());
        Packet packet = new Packet(header, body);
        session.getPrevHeadersOut().put(this.channelId, header);
        logger.info("encoded invoke: " + this.toString());
        return packet;
    }

    public void decode(Packet packet) {
        this.channelId = packet.getHeader().getChannelId();
        this.streamId = packet.getHeader().getStreamId();
        AmfObject object = new AmfObject();
        object.decode(packet.getData(), false);
        List<AmfProperty> properties = object.getProperties();
        this.methodName = (String)properties.get(0).getValue();
        double temp = (Double)properties.get(1).getValue();
        this.sequenceId = (int)temp;
        if (properties.size() > 2) {
            int argsLength = properties.size() - 2;
            this.args = new Object[argsLength];
            for (int i = 0; i < argsLength; ++i) {
                this.args[i] = properties.get(i + 2).getValue();
            }
        }
        logger.info("decoded invoke: " + this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[method: ").append(this.methodName);
        sb.append(", sequenceId: ").append(this.sequenceId);
        if (this.streamId != -1) {
            sb.append(", streamId: ").append(this.streamId);
        }
        sb.append(", args: ").append(Arrays.toString(this.args)).append(']');
        return sb.toString();
    }
}

