/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.ByteToEnum;
import com.flazr.Packet;
import com.flazr.RtmpSession;
import com.flazr.Utils;
import org.apache.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Header {
    private static final Logger logger = LoggerFactory.getLogger(Header.class);
    private Type headerType;
    private int channelId;
    private int time;
    private int size;
    private Packet.Type packetType;
    private int streamId;
    private boolean relative = true;

    public Header() {
    }

    public Header(Type headerType, int channelId, Packet.Type packetType) {
        this.headerType = headerType;
        this.channelId = channelId;
        this.packetType = packetType;
    }

    public Type getHeaderType() {
        return this.headerType;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public Packet.Type getPacketType() {
        return this.packetType;
    }

    public void setPacketType(Packet.Type packetType) {
        this.packetType = packetType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    public boolean decode(ByteBuffer in, RtmpSession session) {
        int typeAndChannel;
        int markerSize;
        int remaining = in.remaining();
        if (remaining < 1) {
            return false;
        }
        byte firstByte = in.get();
        if ((firstByte & 0x3F) == 0) {
            if (remaining < 2) {
                return false;
            }
            markerSize = 2;
            typeAndChannel = (firstByte & 0xFF) << 8 | in.get() & 0xFF;
        } else if ((firstByte & 0x3F) == 1) {
            if (remaining < 3) {
                return false;
            }
            markerSize = 3;
            typeAndChannel = (firstByte & 0xFF) << 16 | (in.get() & 0xFF) << 8 | in.get() & 0xFF;
        } else {
            markerSize = 1;
            typeAndChannel = firstByte & 0xFF;
        }
        this.channelId = markerSize == 1 ? typeAndChannel & 0x3F : (markerSize == 2 ? 64 + (typeAndChannel & 0xFF) : 64 + (typeAndChannel >> 8 & 0xFF) + ((typeAndChannel & 0xFF) << 8));
        byte headerTypeByte = markerSize == 1 ? (byte)(typeAndChannel >> 6) : (markerSize == 2 ? (byte)(typeAndChannel >> 14) : (byte)(typeAndChannel >> 22));
        this.headerType = Type.parseByte(headerTypeByte);
        if (remaining < markerSize + this.headerType.size - 1) {
            return false;
        }
        Header prevHeader = session.getPrevHeadersIn().get(this.channelId);
        switch (this.headerType) {
            case LARGE: {
                this.time = Utils.readInt24(in);
                this.size = Utils.readInt24(in);
                this.packetType = Packet.Type.parseByte(in.get());
                this.streamId = Utils.readInt32Reverse(in);
                this.relative = false;
                break;
            }
            case MEDIUM: {
                this.time = Utils.readInt24(in);
                this.size = Utils.readInt24(in);
                this.packetType = Packet.Type.parseByte(in.get());
                this.streamId = prevHeader.streamId;
                break;
            }
            case SMALL: {
                this.time = Utils.readInt24(in);
                this.size = prevHeader.size;
                this.packetType = prevHeader.packetType;
                this.streamId = prevHeader.streamId;
                break;
            }
            case TINY: {
                this.time = prevHeader.time;
                this.size = prevHeader.size;
                this.packetType = prevHeader.packetType;
                this.streamId = prevHeader.streamId;
            }
        }
        return true;
    }

    public void encode(ByteBuffer out) {
        if (this.channelId <= 63) {
            out.put((byte)((this.headerType.value << 6) + this.channelId));
        } else if (this.channelId <= 320) {
            out.put((byte)(this.headerType.value << 6));
            out.put((byte)(this.channelId - 64));
        } else {
            out.put((byte)(this.headerType.value << 6 | 1));
            int tempChannelId = this.channelId - 64;
            out.put((byte)(tempChannelId & 0xFF));
            out.put((byte)(tempChannelId >> 8));
        }
        switch (this.headerType) {
            case LARGE: {
                Utils.writeInt24(out, this.time);
                Utils.writeInt24(out, this.size);
                out.put(this.packetType.byteValue());
                Utils.writeInt32Reverse(out, this.streamId);
                break;
            }
            case MEDIUM: {
                Utils.writeInt24(out, this.time);
                Utils.writeInt24(out, this.size);
                out.put(this.packetType.byteValue());
                break;
            }
            case SMALL: {
                Utils.writeInt24(out, this.time);
                break;
            }
        }
        if (logger.isDebugEnabled()) {
            byte[] bytes = new byte[out.position()];
            out.rewind();
            out.get(bytes);
            logger.debug("encoded header: " + this.toString() + " --> " + Utils.toHex(bytes));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.headerType);
        sb.append(" c").append(this.channelId);
        sb.append(" t").append(this.time);
        if (!this.relative) {
            sb.append("(a)");
        }
        sb.append(" s").append(this.size);
        sb.append(" #").append(this.streamId);
        sb.append(" ").append(this.packetType).append(']');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements ByteToEnum.Convert
    {
        LARGE(0, 12),
        MEDIUM(1, 8),
        SMALL(2, 4),
        TINY(3, 1);

        private final byte value;
        private final int size;
        private static ByteToEnum<Type> converter;

        private Type(int value, int size) {
            this.value = (byte)value;
            this.size = size;
        }

        @Override
        public byte byteValue() {
            return this.value;
        }

        public static Type parseByte(byte b) {
            return converter.parseByte(b);
        }

        public String toString() {
            return converter.toString(this);
        }

        static {
            converter = new ByteToEnum((Enum[])Type.values());
        }
    }
}

