/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.AmfProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmfObject {
    private static final Logger logger = LoggerFactory.getLogger(AmfObject.class);
    private List<AmfProperty> properties = new ArrayList<AmfProperty>();

    public AmfObject() {
    }

    public AmfObject(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public List<AmfProperty> getProperties() {
        return this.properties;
    }

    public AmfProperty getProperty(String name) {
        for (AmfProperty property : this.properties) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public String getFirstPropertyAsString() {
        return (String)this.properties.get(0).getValue();
    }

    public void put(Object value) {
        this.put(null, value);
    }

    public void put(String name, Object value) {
        this.add(new AmfProperty(name, value));
    }

    public void add(AmfProperty property) {
        this.properties.add(property);
    }

    public void decode(ByteBuffer in, boolean decodeName) {
        while (in.remaining() >= 3) {
            byte[] endMarker = new byte[3];
            in.get(endMarker);
            if (endMarker[0] == 0 && endMarker[1] == 0 && endMarker[2] == 9) {
                logger.debug("decoded end marker: [00 00 09]");
                return;
            }
            in.position(in.position() - 3);
            AmfProperty property = new AmfProperty();
            property.decode(in, decodeName);
            this.add(property);
        }
    }

    public static ByteBuffer encode(Object ... values) {
        AmfObject o = new AmfObject();
        for (Object value : values) {
            o.put(value);
        }
        ByteBuffer body = ByteBuffer.allocate((int)1024);
        o.encode(body);
        return body;
    }

    public void encode(ByteBuffer out) {
        for (AmfProperty property : this.properties) {
            property.encode(out);
        }
        logger.debug("encoding end marker: [00 00 09]");
        out.put(new byte[]{0, 0, 9});
    }

    public String toString() {
        return this.properties.toString();
    }
}

