
function MemBuffer(buffer) {
    this.queue = [];
    this.offset = 0;
    this.buffer = buffer;
}

MemBuffer.prototype.read = function (len) {
    if (this.offset + len > this.buffer.length) throw Error('MemBuffer overrun');
    // console.log('MemBuffer.read len: ' + len + ' buffer.length: ' + this.buffer.length + ' offset: ' + this.offset);
    var buffer = this.buffer.slice(this.offset, this.offset + len);
    this.offset += len;
    return buffer;
};

MemBuffer.prototype.write = function (buffer) {
    if (Buffer.isBuffer(buffer)) {
        this.queue.push(buffer);
    } else {
        throw Error('Unsupported type sent to MemBuffer.write. Accepts Buffer.');
    }
};

MemBuffer.prototype.clear = function () {
    this.queue = [];
    this.buffer = null;
    this.offset = 0;
};

MemBuffer.prototype.flush = function () {
    if (this.buffer) this.queue.unshift(this.buffer);
    this.buffer = Buffer.concat(this.queue);
    this.queue = [];
};

module.exports = MemBuffer;
