
var Service = function () {

}

Service.prototype.serverStarted = function (serverName, onsuccess) {
    console.log('serverStarted: ' + serverName);
    onsuccess();
};

Service.prototype.getLocalizedMessage = function (identifier, onsuccess) {
    console.log('getLocalizedMessage: ' + identifier);
    if (identifier) identifier = identifier.split('').reverse().join('');
    onsuccess(identifier);
};

Service.prototype.getLocalizedMessages = function (onsuccess) {
    console.log('getLocalizedMessages');
    onsuccess({ myid: 'my value'});
};

Service.prototype.getCurrentUserInfo = function (onsuccess) {
    console.log('getCurrentUserInfo');
    onsuccess({ myKey: 'value for current user'});
};

Service.prototype.getResource = function (resourceUrl, onsuccess, onerror) {
    console.log('getResource resourceUrl: ' + resourceUrl);
    onerror('getResource is not implemented in DesktopServiceStub');
};

Service.prototype.updateImage = function (resourceUrl, image, onsuccess) {
    console.log('updateImage: ' + resourceUrl);
    onsuccess();
};

Service.prototype.updateImageAsBase64 = function (resourceUrl, base64, onsuccess) {
    console.log('updateImageAsBase64: ' + resourceUrl);
    onsuccess();
};

Service.prototype.markupWindowClosed = function (resourceUrl, onsuccess) {
    console.log('markupWindowClosed: ' + resourceUrl);
    onsuccess();
};

Service.prototype.getNoteTitle = function (noteId, onsuccess) {
    console.log('getNoteTile noteId: ' + noteId);
    onsuccess('Le Title');
};

Service.prototype.getNoteAsHtml = function (noteId, onsuccess) {
    console.log('getNoteAsHtml noteId: ' + noteId);
    onsuccess('<html><head><title>Simple Note</title></head><body>Simple Note</body></html>');
};

Service.prototype.getResourceAsDataUrl = function (resourceUrl, onsuccess, onerror) {
    console.log('getResourceAsDataUrl resourceUrl: ' + resourceUrl);
    // returns a small red dot
    onsuccess('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHElEQVQI12P4//8/w38GIAXDIBKE0DHxgljNBAAO9TXL0Y4OHwAAAABJRU5ErkJggg==');
};

Service.prototype.getResources = function (noteId, onsuccess) {
    console.log('getResources noteId: ' + noteId);
    onsuccess({});
};

Service.prototype.getResourcesAsBase64 = function (noteId, onsuccess) {
    console.log('getResourcesAsBase64 noteId: ' + noteId);
    onsuccess([{
        id: '1',
        mimeType: '',
        filename: '',
        base64: '1234'
    },{
        id: '2',
        mimeType: '',
        filename: '',
        base64: '5678'
    }]);
};

Service.prototype.createNoteFromResource = function (resource, onsuccess) {
    console.log('createNoteFromResource');
    onsuccess({});
};

Service.prototype.createNoteFromResourceAsBase64 = function (resource, onsuccess) {
    console.log('createNoteFromResourceAsBase64');
    onsuccess({});
};

Service.prototype.presentationWindowClosed = function (onsuccess) {
    console.log('presentationWindowClosed');
    onsuccess();
};

module.exports = Service;