requirejs.config({
    baseUrl: '../../modules',
    paths: {
      lib: '../lib',
      app: '../app/present',
      Mac: '../lib/encpnew/Mac/Source',
      Shared: '../lib/encpnew/Shared/Source',
      SharedCSS: '../lib/encpnew/Shared/CSS',
    }
});

require(['app/ENCPPlatformNew', 'Shared/Utilities/ENCPLogger', 'Mac/ENCPPresenter', 'app/ui/Viewer'],
    function (ENCPPlatform, ENCPLogger, ENCPPresenter, Viewer) {

    window.setupLayoutEditor = function() {
        window.encpPresenter.enableLayoutEditorMode();
        var parentWindowViewPortSize = JSON.stringify({height: $(window.parent).height(),width: $(window.parent).width()});
        window.encpPlatform.setViewPortSize(parentWindowViewPortSize); //have to manually set the parent window viewport size
        window.encpPresenter.layoutEditorController.updateLayoutEditorDisplay(); //need to step through this process more carefully
        window.encpPresenter.updateUserZoomLevel(1); //hard coded because we don't support zooming
        window.encpPresenter.layoutEditorController.displaySectionBreaks(true);
        //here is where we will show messages (FTUE, convert HRs, etc.) if needed
        window.encpPresenter.layoutEditorController.setReadonly(false);
    };

    window.bootstrap = function () {
        // TODO: Remove globals
        window.encpPlatform = new ENCPPlatform();
        window.encpPlatform.host().animateScrolling = true;

        if (window.encpPresenter) {
            window.removeEventListener('wheel', onWheel);
            window.encpPresenter.removeListeners();
        }
        window.encpPresenter = new ENCPPresenter();

        window.app = {
            layoutEditor: {
                available: false
            }
        };
        window.setNightMode = Viewer.setNightMode.bind(Viewer, window.encpPresenter);
        window.encpPresenter.registerScrollListener = function () {
            window.addEventListener('wheel', onWheel);
        };
        window.encpPresenter.setup();
        window.encpPlatform.applicationDidLoad(window.encpPresenter);
    };

    function onWheel(evt) {
        var scrollOffset = $(window).scrollTop();
        var windowHeight = $(window).height();
        if (evt.deltaY < 0 && scrollOffset == 0) {
            evt.preventDefault();
        } else if (evt.deltaY > 0 && scrollOffset + windowHeight >= document.body.scrollHeight) {
            evt.preventDefault();
        }
    }
});
