/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WINDOW_H
#define WINDOW_H

#include "canvas.h"
#include "editor.h"
#include "tools.h"
#include "properties.h"
#include "colors.h"
#include "timeline.h"
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qaction.h>
#include <qurl.h>
#include <qdir.h>
#include "undo.h"
#include <qstatusbar.h>
#include <qlineedit.h>




class Window: public QMainWindow
{
 Q_OBJECT
 
public:

  QColor c; //color de fondo0
  int frames;
  int layer;
  int h,v;
  int rate;
  int maxlayer;
  int maxitems; //maxitems a layer can hold in a frame, 1000 by default
  QPtrList<Canvas> can;
  Canvas* inicial;
  Window(int argc, char **argv  );
  Editor* ed; 
  Tools* tools;
  Colors* colors;
  Properties* prop;
  TimeLine* time;
  QDockWindow* toolsWindow;
  QDockWindow* colorsWindow;
  QDockWindow* propWindow;
  QDockWindow* timeWindow;
  QDir tempDir; 

  QMenuBar *menuBar;
  QPopupMenu *fileMenu;
  QPopupMenu *editMenu;
  QPopupMenu *helpMenu;
  QAction* fileNewAction;
  QAction* fileOpenAction;
  QAction* fileSaveAction;
  QAction* fileSaveAsAction;
  QAction* fileExportAction;
  QAction* filePrintAction;
  QAction* fileExitAction;
  QAction* editUndoAction;
  QAction* editRedoAction;
  QAction* editCutAction;
  QAction* editCopyAction;
  QAction* editPasteAction;
  QAction* editPropAction;
  QAction* editLangAction;
  QAction* editPathAction;
  QAction* filePreviewAction;
  QAction* getHtmAction;
  QAction* getPhpAction;
  QAction* getPerlAction;
  QAction* helpContentsAction;
  QAction* helpIndexAction;
  QAction* helpAboutAction;
  QLineEdit* lineEdit;
  QLabel* lineLabel;

  int getTool();
  void updateFrame(int, int);
  void clearFrame(int, int);
  void copyFrame(int, int, int, int);
  QCanvasItem* copyItem(QCanvasItem*, QCanvas*);
  QString imageList;
  void saveLang();
  void savePath();
  void loadPath();
  QString xmlSave();
  QUrl fileurl;
  QString fileswf;
  QString filemp3;
  QString lang;
  
  QString BROWPATH;
  QString TARPATH;
  QString UTILSPATH;
  QString KSVGPATH;
  QString TTF2FFTPATH;

  void autoOpen( QString );
  int currentFrame;

  actionList* undoActionList;
  
  QStatusBar* statusBar;

public slots:
  virtual void fileNew(bool = 0);
  virtual void fileOpen();
  virtual bool fileSave();
  virtual bool fileSaveAs();
  virtual void filePreview();
  virtual int swf();
  virtual void filePrint();
  virtual void fileExit();
  virtual void editUndo();
  virtual void editRedo();
  virtual void editCut();
  virtual void editCopy();
  virtual void editPaste();
  virtual void getPhp();
  virtual void getHtm();
  virtual void getPerl();
  virtual void editProp();
  virtual void editLang();
  virtual void editPath();
  virtual void helpIndex();
  virtual void helpContents();
  virtual void helpAbout();
  void setFrames(int);
  void insertLayer();
  void removeLayer(int);
  void avisoParser();
  void avisoFonts();
  void changeAdjusts(int x, int y);
  void update(); //adjusts the scroll bars 
  void startButtonEdit(bool);
  QCanvasItemList copyFrameForButton(QCanvas*, QCanvas* );
  void updateStatusBar();
    
protected:

  int setSwfProp();
  void resizeEvent ( QResizeEvent * );
  void closeEvent ( QCloseEvent * );

protected slots:
  void languageChange();
 
 };
 
 
#endif


