/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "timetable.h"
#include "window.h"
#include "timetableitem.h"
#include "timeline.h"
#include <qpainter.h>
#include <qpopupmenu.h> 


#include <iostream>
using namespace std;
 

timeTable::timeTable(int numL,int numF,QWidget *parent,const char *name )
  :QTable(numL,numF,parent,name)
{
  setSelectionMode(QTable::NoSelection);
  setFocusPolicy(QWidget::StrongFocus);
  setHScrollBarMode(QScrollView::AlwaysOff);
  setVScrollBarMode(QScrollView::AlwaysOff);
  setReadOnly(true);
  QHeader *hor=horizontalHeader();
  QHeader *ver=verticalHeader();
  hor->hide();
  ver->hide();
  setLeftMargin(0);
  setTopMargin(0);
  cut = 0;
  for(int i=0;i<numCols();i++)
  {
    setColumnWidth(i,8);
    TableItem* t = new TableItem(this);
    setItem(0,i,t);
  }
  
  TableItem* t = (TableItem*) item(0,0); 
  t->ready = 1;
  t->end = 1;
  t->start = 1;
    
  setRowHeight(0,20);
  setDragEnabled(false);
  setMouseTracking(true);
   
  bufferedCol = -1;
  setStaticBackground ( 0 );
}





void timeTable::contentsMouseMoveEvent(QMouseEvent *e)
{
  QTable::contentsMouseMoveEvent(e);
  TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  int i,j;
  i = e->pos().x();
  j = e->pos().y() + contentsY();
  QMouseEvent *a=new QMouseEvent(QEvent::MouseButtonPress, QPoint(i,j), LeftButton,0);
  t->ruler->mousePressEvent(a);
}


void timeTable::contentsMousePressEvent( QMouseEvent *e )
{
  QTable::contentsMouseMoveEvent(e);
  TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  int i,j;
  i = e->pos().x();
  j = e->pos().y() + contentsY();
  QMouseEvent *a=new QMouseEvent(QEvent::MouseButtonPress, QPoint(i,j), LeftButton,0);
  t->ruler->mousePressEvent(a);
  int x = (mapToGlobal (e->pos())).x()-contentsX();
  int y = (mapToGlobal (e->pos())).y()-contentsY();
  
  if (e->button()  == RightButton)
  {
    QPopupMenu* frame = new QPopupMenu (this);

    frame->insertItem (tr("Insert frame"),this,SLOT(slotInsertFrame()));

    TableItem* ti;
    ti = (TableItem*) item(t->ruler->currentY,t->ruler->currentX);
    if(!ti->ready || ( ti->end && !ti->start) )
       frame->insertItem (tr("Insert editable frame"),this,SLOT(slotForceInsertFrame()));

    frame->insertItem (tr("Remove frame"),this,SLOT(slotRemoveFrame()));
    frame->insertItem (tr("Clear frame"), this, SLOT(slotClearFrame()));
    frame->insertSeparator();
    frame->insertItem (tr("Cut"), this, SLOT(slotCutFrame()));
    frame->insertItem (tr("Copy"), this, SLOT(slotCopyFrame()));
    frame->insertItem (tr("Paste"), this, SLOT(slotPasteFrame()));
    frame->insertSeparator();
    frame->insertItem (trUtf8("ActionScript"), this , SLOT(addAS()));
    //frame->insertItem (tr("Properties"));
    frame->popup (QPoint(x,y));
    frame->exec ();
    frame->~QPopupMenu() ;
  }

}


void timeTable::slotForceInsertFrame(int layer, int frame)
{
  slotInsertFrame(layer, frame);

  int i =currentColumn();
  int j =currentRow();
  TableItem* ti;
  if(frame != -1) i = frame;
  if(layer != -1) j = layer;
  ti = (TableItem*) item(j,i);
  ti->start = 1;

  TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  Window* q = (Window*) t->parentWidget()->topLevelWidget();
  q->updateFrame(j,i);
}

void timeTable::slotInsertFrame(int layer, int frame)
{

  int i =currentColumn();
  int j =currentRow();
  TableItem* ti;
  if(frame != -1) i = frame;
  if(layer != -1) j = layer;
  ti = (TableItem*) item(j,i);
  if (ti->start || ti->end) return;

  if (ti->ready)  //a new frame between other frames
  {
    ti->start = 1;  
    ti->end = 1;
    updateCell(j,i);
 
    
  }
  else
  {
    ti->ready = 1;
    
    if (hasAnyFrameBefore(j, i) && !hasAnyFrameAfter(j, i) )
    {
      ti->end = 1;
      for (int a = i-1; a > 0 ; a--)
      {
        TableItem* ti = (TableItem*) item(j,a); 
        ti->ready = 1;
        updateCell(j,a);
        if (ti->end == 1)
        {
          ti->start = 1;
          updateCell(j,a);
          break;
        }
      }
    }
    
    if (hasAnyFrameAfter(j, i)  && !hasAnyFrameBefore(j, i) )
    {

      ti->start=1;
      for (int a = i+1; a < numCols() ; a++)
      {
        TableItem* ti = (TableItem*) item(j,a); 
        ti->ready = 1;
        updateCell(j,a);
        if (ti->start == 1)
        {
          ti->end = 1;
          updateCell(j,a);
          break;
        }
      }
    }
    
    if(!hasAnyFrameAfter(j, i)  && !hasAnyFrameBefore(j, i) )
    {

        TableItem* ti = (TableItem*) item(j,i); 
        ti->ready = 1;
        ti->start = 1;
        ti->end = 1;

    }
      
   
   }
      
  updateEffects();
  TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  Window* q = (Window*) t->parentWidget()->topLevelWidget();
  q->updateFrame(j,i);

}


void timeTable::slotRemoveFrame(int layer, int frame)
{
  int i =currentColumn();
  int j =currentRow();
  TableItem* ti;
  if(frame != -1) i = frame;
  if(layer != -1) j = layer;
  ti = (TableItem*) item(j,i);
  
  if ( !ti->start && !ti->end) return;
  
  ti->end = 0;
  ti->start = 0;
  ti->ready=0;
  updateCell(frame,layer);

   if (hasAnyFrameBefore(j, i)  && !hasAnyFrameAfter(j, i) )
    {       
     
      for (int a = i; a > 0 ; a--)
      {
        TableItem* ti = (TableItem*) item(j,a); 
        if (ti->start == 1)
        {
          ti->start = 0;
          ti->end = 1;
          updateCell(j,a);
          break;
        }
        ti->ready = 0;
        updateCell(j,a);
      }
    }
    
    if (hasAnyFrameAfter(j, i) && !hasAnyFrameBefore(j, i) )
    {
    
      for (int a = frame+1; a < numCols() ; a++)
      {
        TableItem* ti = (TableItem*) item(j,a);
        if (ti->end == 1)
        {
          ti->start = 1;
          updateCell(j,a);
          break;
        }
        ti->ready = 0;
        updateCell(j,a);

      }
    }
    
    if(hasAnyFrameAfter(j, i)  && hasAnyFrameBefore(j, i) )
    {
      

        TableItem* ti = (TableItem*) item(j,i); 
        ti->ready = 1;
        ti->start = 0;
        ti->end = 0;

    }
      


   updateEffects();
   TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
   Window* q = (Window*) t->parentWidget()->topLevelWidget();
   q->updateFrame(0,1);
}
  
void timeTable::slotClearFrame(int f, int l)
{
  TimeLine* ti = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  Window* q = (Window*) ti->parentWidget()->topLevelWidget();
  int i =currentColumn();
  int j =currentRow();
  if(f != -1) i = f;
  if(l != -1) j = l;
  q->clearFrame(j,i);
  q->ed->canvas()->setAllChanged();
  q->ed->canvas()->update();
}
  
  
void timeTable::slotPasteFrame()
{
  
  if (bufferedCol != -1)
  {  
    slotInsertFrame(currentRow(), currentColumn());
    slotClearFrame();
    TimeLine* ti = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
    Window* q = (Window*) ti->parentWidget()->topLevelWidget();
    q->copyFrame(bufferedRow, bufferedCol ,currentRow(), currentColumn() );
  }
  if (cut)
  {
    slotClearFrame(bufferedCol, bufferedRow);
    bufferedRow = -1;
    bufferedCol = -1;
  }
  cut = 0;

}
  
void timeTable::slotCutFrame()
{
  bufferedCol = currentColumn();
  bufferedRow = currentRow();
  cut = 1;
}
  
  
void timeTable::slotCopyFrame()
{
  bufferedCol = currentColumn();
  bufferedRow = currentRow();
  cut = 0;
}
  
  
int timeTable::frameCount()
{
  int t=0;

  for (int a=numRows()-1;a>=0;a--)
  {

    for (int i=numCols()-1; i>=0; i--)
    {
      TableItem* ti = (TableItem*) item(a,i); 
      if (ti->end )
       {
         if (i+1>t) t = i + 1;
         i = -1;
      }
    } 

  }
  return t;
}
 
void timeTable::insertLayer(int initialPosition) //pos ) <-- add insert layer in different positions
{
  setNumRows(numRows() +1);
  for(int i=0;i<numCols();i++)
  {
    TableItem* t = new TableItem(this);
    setItem(numRows()-1,i,t);
  }
  if(initialPosition != -1 )
  {
    TableItem* t = (TableItem*) item(numRows()-1,initialPosition); 
    t->ready = 1;
    t->end = 1;
    t->start = 1;
  }
  
  for (int a=numRows()-1;a>0;a--)
  swapRows(a,a-1);
  
  
  
  for (int x=numRows()-1;x>=0;x--)
  {
    for (int y=numCols()-1; y>=0; y--)
    {
       updateCell(x,y); 
    }
  }

}
  
void timeTable::viewportPaintEvent (  QPaintEvent * pe  )
{
  QScrollView::viewportPaintEvent ( pe );
  TimeLine* tl = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  tl->tvs->somethingChanged(contentsY(), contentsHeight());
}


void timeTable::removeLayer(int l)
{
  removeRow(l);
}
  
void timeTable::clearLayer()
{
}

bool timeTable::hasAnyFrameBefore(int layer, int frame)
{
  for (int i=frame;i>0;i--)
  {
    TableItem* t = (TableItem*) item(layer, i-1); 
    if (t->ready) return 1;
  }
  return 0;
}

bool timeTable::hasAnyFrameAfter(int layer, int frame)
{ 
  for (int i=frame;i<numCols()-1;i++)
  {
    TableItem* t = (TableItem*) item(layer, i+1); 
    if (t->ready) return 1;
  }
  return 0;
}

void timeTable::updateEffects()
{
}

void timeTable::addAS()
{
  TimeLine* ti = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  Window* q = (Window*) ti->parentWidget()->topLevelWidget();
  q->ed->addAS( currentColumn() );
}

