/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef REG
#define REG

#include <qcanvas.h>
#include <items.h>

class NodeItem;
class itemGroup;

class Regular: public QCanvasPolygonalItem
{

public:
  Regular(QCanvas* canvas);
  Regular(Regular*, QCanvas* canvas);
  ~Regular();
  int p; // vertices
  int ri; //radio interior
  int re; //radio exterior
  int di; //inner deplacement / desplazamiento interior
  int de; //outer deplacement /desplazamiento exterior
  bool star; //poligono o estrella / polygon or star
  bool view;
  int rtti() const {return 89;}
  QPointArray areaPoints() const;
  QPointArray tempPoints(int, int) const;
  QString xml();
  void showNodes();
  void moveBy(double dx, double dy);
  bool effect;
  QString effectName;
  bool grouped;
  itemGroup* group;
  bool button;
  QString name;

protected:
 void drawShape ( QPainter & p );

}; 

#endif
