/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "propDialog.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcolordialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>


Dialog::Dialog(QColor tmp, int /*f*/, int h, int v )
    : QDialog()
{

    setSizeGripEnabled( TRUE );

    QWidget* privateLayoutWidget = new QWidget( this, "Layout1" );
    privateLayoutWidget->setGeometry( QRect( 170, 230, 190, 33 ) );
    Layout1 = new QHBoxLayout( privateLayoutWidget, 0, 6, "Layout1"); 

    buttonOk = new QPushButton( privateLayoutWidget, "buttonOk" );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    Layout1->addWidget( buttonOk );

    buttonCancel = new QPushButton( privateLayoutWidget, "buttonCancel" );
    buttonCancel->setAutoDefault( TRUE );
    Layout1->addWidget( buttonCancel );

    pushButton1 = new QPushButton( this, "pushButton1" );
    pushButton1->setGeometry( QRect( 270, 45, 40, 40 ) );
    pushButton1->setPaletteBackgroundColor( tmp );
    c = tmp;
       
    spinBox2 = new QSpinBox( this, "spinBox2" );
    spinBox2->setGeometry( QRect( 270, 120, 50, 31 ) );
    spinBox2->setMaxValue( 9999 );
    spinBox2->setValue( h );

    textLabel4 = new QLabel( this, "textLabel4" );
    textLabel4->setGeometry( QRect( 185, 130, 80, 21 ) );

    textLabel3 = new QLabel( this, "textLabel3" );
    textLabel3->setGeometry( QRect( 50, 130, 120, 21 ) );

    textLabel2 = new QLabel( this, "textLabel2" );
    textLabel2->setGeometry( QRect( 50, 60, 120, 21 ) );

    //textLabel1 = new QLabel( this, "textLabel1" );
    //textLabel1->setGeometry( QRect( 50, 30, 120, 30 ) );

    textLabel5 = new QLabel( this, "textLabel5" );
    textLabel5->setGeometry( QRect( 185, 170, 80, 21 ) );

    spinBox3 = new QSpinBox( this, "spinBox3" );
    spinBox3->setGeometry( QRect( 270, 160, 50, 31 ) );
    spinBox3->setMaxValue( 9999 );
    spinBox3->setValue( v );

    /*spinBox1 = new QSpinBox( this, "spinBox1" );
    spinBox1->setGeometry( QRect( 270, 30, 50, 30 ) );
    spinBox1->setWrapping( FALSE );
    spinBox1->setMaxValue( 9999 );
    spinBox1->setValue( f );
    spinBox1->setEnabled(false);*/
    languageChange();
    resize( QSize(367, 282).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( pushButton1, SIGNAL( clicked() ), this, SLOT( elige_c() ) );
}
    
    
Dialog::~Dialog()
{
}

void Dialog::languageChange()
{
    setCaption( tr( "Properties" ) );
    buttonOk->setText( tr( "Save" ) );
    buttonOk->setAccel( QKeySequence( QString::null ) );
    buttonCancel->setText( tr( "Cancel" ) );
    buttonCancel->setAccel( QKeySequence( QString::null ) );
    textLabel4->setText( tr( "Horizontal" ) );
    textLabel3->setText( tr( "Picture size" ) );
    textLabel2->setText( tr( "Background color" ) );
    //textLabel1->setText( tr( "Number of frames" ) );
    textLabel5->setText( tr( "Vertical" ) );
}

void Dialog::elige_c()
{
QColor end = QColorDialog::getColor ( c );
this->pushButton1->setPaletteBackgroundColor( end );
c = end;
}
