/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "pathDialog.h"

#include <qvariant.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qpushbutton.h>
#include <qfiledialog.h>

#include "menuimages/open.xpm"

pathDialog::pathDialog( QString prog1, QString prog2, QString prog3, QString prog4, QString prog5 )
    : QDialog( )
{

    textLabel1 = new QLabel( this, "textLabel1" );
    textLabel1->setGeometry( QRect( 40, 20, 290, 21 ) );

    textLabel2 = new QLabel( this, "textLabel2" );
    textLabel2->setGeometry( QRect( 40, 110, 261, 21 ) );

    textLabel3 = new QLabel( this, "textLabel3" );
    textLabel3->setGeometry( QRect( 40, 200, 271, 30 ) );

    textLabel4 = new QLabel( this, "textLabel4" );
    textLabel4->setGeometry( QRect( 40, 290, 271, 21 ) );

    textLabel5 = new QLabel( this, "textLabel5" );
    textLabel5->setGeometry( QRect( 40, 380, 271, 21 ) );


    lineEdit1 = new QLineEdit( this, "lineEdit1" );
    lineEdit1->setGeometry( QRect( 80, 50, 330, 25 ) );

    lineEdit2 = new QLineEdit( this, "lineEdit2" );
    lineEdit2->setGeometry( QRect( 80, 140, 330, 25 ) );

    lineEdit3 = new QLineEdit( this, "lineEdit3" );
    lineEdit3->setGeometry( QRect( 80, 230, 330, 25 ) );

    lineEdit4 = new QLineEdit( this, "lineEdit4" );
    lineEdit4->setGeometry( QRect( 80, 320, 330, 25 ) );

    lineEdit5 = new QLineEdit( this, "lineEdit5" );
    lineEdit5->setGeometry( QRect( 80, 410, 330, 25 ) );

    choose1 = new QPushButton( this, "choose1" );
    choose1->setGeometry ( 411, 50, 25, 25 );
    choose2 = new QPushButton( this, "choose2" );
    choose2->setGeometry ( 411, 140, 25, 25 );
    choose3 = new QPushButton( this, "choose3" );
    choose3->setGeometry ( 411, 230, 25, 25 );
    choose4 = new QPushButton( this, "choose4" );
    choose4->setGeometry ( 411, 320, 25, 25 );
    choose5 = new QPushButton( this, "choose5" );
    choose5->setGeometry ( 411, 410, 25, 25 );

    choose1->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));
    choose2->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));
    choose3->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));
    choose4->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));
    choose5->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));

    lineEdit1->setText( prog1 );
    lineEdit2->setText( prog2 );
    lineEdit3->setText( prog3 );
    lineEdit4->setText( prog4 );
    lineEdit5->setText( prog5 );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setGeometry( QRect( 110, 465, 140, 30 ) );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setGeometry( QRect( 260, 465, 131, 30 ) );
       
    languageChange();
    resize( QSize(500, 540).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( choose1,  SIGNAL( clicked() ), this, SLOT( searchFile1() ) );
    connect( choose2,  SIGNAL( clicked() ), this, SLOT( searchFile2() ) );
    connect( choose3,  SIGNAL( clicked() ), this, SLOT( searchFile3() ) );
    connect( choose4,  SIGNAL( clicked() ), this, SLOT( searchFile4() ) );
    connect( choose4,  SIGNAL( clicked() ), this, SLOT( searchFile5() ) );

}

pathDialog::~pathDialog()
{
}


void pathDialog::languageChange()
{
    setCaption( tr( "Configure the locations" ) );
    textLabel1->setText( tr( "Browser path" ) );
    textLabel2->setText( tr( "Path to tar" ) );
    textLabel3->setText( tr( "Path to ming-utils" ) );
    textLabel4->setText( tr( "Path to ksvgtopng" ) );
    textLabel5->setText( tr( "Path to ttf2fft" ) );

    buttonOk->setText( tr( "Ok" ) );
    buttonCancel->setText( tr( "Cancel" ) );
}

void pathDialog::searchFile1( )
{
  QString file;
  file = QFileDialog::getOpenFileName(
                    "",
                    "All files ( * )",
                    this,
                    "open file dialog",
                    tr("Choose a file") );
  if (file != "") lineEdit1->setText(file);

}

void pathDialog::searchFile2( )
{
  QString file;
  file = QFileDialog::getOpenFileName(
                    "",
                    "All files ( * )",
                    this,
                    "open file dialog",
                    tr("Choose a file") );

  if (file != "") lineEdit2->setText(file);
}

void pathDialog::searchFile3( )
{
  QString file;
  file = QFileDialog::getExistingDirectory("",
                    this,
                    "get existing directory",
                    tr("Choose a directory"),
                    TRUE );

  if (file != "") lineEdit3->setText(file);
}

void pathDialog::searchFile4( )
{
   QString file;
   file = QFileDialog::getOpenFileName(
                    "",
                    "All files ( * )",
                    this,
                    "open file dialog",
                    tr("Choose a file") );

   if (file != "") lineEdit4->setText(file);
}

void pathDialog::searchFile5( )
{
  QString file;
  file = QFileDialog::getOpenFileName(
                    "",
                    "All files ( * )",
                    this,
                    "open file dialog",
                    tr("Choose a file") );

  if (file != "") lineEdit5->setText(file);
}

