/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef LOADER_H
#define LOADER_H   

#include <qxml.h>

#include "window.h"
#include "mingpp.h"
#include "qptrlist.h"


class xml2canvas : public QXmlDefaultHandler
{
public:
    xml2canvas(Window*);
    bool startDocument();
    bool startElement( const QString&, const QString&, const QString&,const QXmlAttributes& );
    bool endElement( const QString&, const QString&, const QString& );
    Window* parent;
    QCanvas* canvas;

    bool fontWarning;
    int frame;
    int layer;
    int maxlayer;
    ButtonItem* tmpButton;
    QCanvasItemList groupItems;
    int inGroup;
    int inButton;

private:

};



class xml2swf  : public QXmlDefaultHandler
{

public: 
    xml2swf(Window*);
    bool startDocument();
    bool startElement( const QString&, const QString&, const QString&,const QXmlAttributes& );
    bool endElement( const QString&, const QString&, const QString&  );
    int layers;
    int fnumber;
    int frames; 
    QString movieurl;
    QString moviemp3;
    Window* parent;
    SWFMovie *movie;
    int inButton;
    SWFButton* button;
    int buttonCanvas;
    int buttonLayer;
    QPtrList< QPtrList<SWFDisplayItem> > disp;
    QString name;
    QPointArray regTmpPoints(int, int , int);
    QPointArray regPoints(int re, int ri, int de, int di, int p, int star);
   
private:

};


#endif 
