/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "parser.h"
#include "qmessagebox.h"
#include "qobject.h"
#include "items.h"
#include <math.h>

#include <stdio.h>
#include <qstring.h>
#include <canvas.h>
#include <stdio.h>
#include <qimage.h>
#include <qurl.h>
#include <qdir.h>

#include <iostream>
using namespace std;


xml2canvas::xml2canvas(Window* tmp): QXmlDefaultHandler()
{
  parent = tmp;

}



bool xml2canvas::startDocument()
{
  fontWarning = 0;
  inGroup = 0;
  inButton = 0;
  return TRUE;
}

bool xml2canvas::startElement( const QString&, const QString&, 
                                    const QString& qName, 
                                    const QXmlAttributes& att )
{
    if (qName == "frame")
    {
      frame = att.value("number").toInt();
      layer = maxlayer - att.value("layer").toInt();
      if (att.value("end").toInt() == 1)
      {
        parent->time->table->slotInsertFrame(layer,frame-1);
        TableItem* ti =(TableItem*) parent->time->table->item(layer,frame-1);
        ti->end = 1;
      }
      else
        parent->time->table->slotInsertFrame(layer,frame);

      if (att.value("code") != "")
      {
        QString* code = new QString(att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" ));
        parent->ed->animAction.actions.replace((unsigned int) att.value("number").toInt(), code );
      }
    }
    
    if (qName == "animation")
    {
      parent->rate = att.value("rate").toInt();
      parent->fileswf = att.value("movie");
      parent->filemp3 = att.value("mp3");
      parent->c = QColor(att.value("color"));
      parent->h = att.value("width").toInt();
      parent->v = att.value("height").toInt();
      parent->ed->updateAll();
      
      maxlayer = att.value("layers").toInt();
      for (int t = 1; t <= maxlayer; t++) 
        parent->time->list->insertLayer(-1); 
    }
    
    
    if(qName == "item")
    {
      if (!inButton)
       canvas = parent->can.at(frame);
      
     // if(parent->ed->z() <  att.value("z").toInt()  )
      //  parent->ed->zUp( att.value("z").toInt()- 50000 + att.value("layer").toInt()*10000 );

   
      if( att.value("class") == "LineItem")
      {
        LineItem* line = new LineItem( canvas );
        line->setPen (QPen(att.value("border")));
        line->setPoints(att.value("x").toInt(), att.value("y").toInt(), att.value("x2").toInt(), att.value("y2").toInt());
        line->setZ( att.value("z").toInt() );
        line->name = att.value("name");
        if (inGroup)
         groupItems.append(line);
      }
    
      if( att.value("class") == "RectItem")
     {
       RectItem* rect = new RectItem(att.value("x").toInt(), att.value("y").toInt(), att.value("width").toInt(), att.value("height").toInt(), canvas );
       rect->setPen (QPen(att.value("border")));
       rect->setBrush (QBrush(att.value("color")));
       rect->setZ( att.value("z").toInt() );
       rect->name = att.value("name");
        if (inGroup)
         groupItems.append(rect);

     }
    
    if( att.value("class") == "OvalItem")
    {
      OvalItem* oval = new OvalItem(att.value("width").toInt(), att.value("height").toInt(), canvas );
      oval->setPen (QPen(att.value("border")));
      oval->setBrush (QBrush(att.value("color")));
      oval->setX( att.value("x").toInt() );
      oval->setY( att.value("y").toInt() );
      oval->setZ( att.value("z").toInt() );
      oval->name = att.value("name");
        if (inGroup)
         groupItems.append(oval);
    }
    
    if( att.value("class") == "Polygon")
    {
      Polygon* poly = new Polygon( canvas );
      poly->setPen (QPen(att.value("border")));
      poly->setBrush (QBrush(att.value("color")));
      int a = 0;
      poly->setZ( att.value("z").toInt() );
      poly->setX( att.value("x").toInt() );
      poly->setY( att.value("y").toInt() );
      for (int i = 0; i < 1000; i++)
      {
        if (att.value("x"+QString::number(i)).toInt() == 0 && att.value("y"+QString::number(i)).toInt() == 0) 
        {
          a = i;
         break;
        }
      }
      QPointArray pa(a);
      for (int i = 0; i < a; i++)
      {
        pa[i] = QPoint( att.value("x"+QString::number(i)).toInt(), att.value("y"+QString::number(i)).toInt());
      }
      poly->setPoints( pa );
      poly->polyline = pa ;
      poly->show();
      poly->name = att.value("name");

      if (inGroup)
         groupItems.append(poly);

   }
    
   if( att.value("class") == "BrushItem")
   {
     BrushItem* brush = new BrushItem( canvas );
     brush->setPen ( QPen(att.value("border"), att.value("width").toInt() ,Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin  ));
     int a = 0;
     for (int i = 0; i < 100000; i++)
     {
       if (att.value("x"+QString::number(i)).toInt() == 0 && att.value("y"+QString::number(i)).toInt() == 0) 
       {
         a = i;
         break;
       }
     }
     QPointArray pa(a);
     for (int i = 0; i < a; i++)
     {
        pa[i] = QPoint( att.value("x"+QString::number(i)).toInt(), att.value("y"+QString::number(i)).toInt());
     }
     brush->width = att.value("width").toInt();
     brush->polyline =  pa ;
     brush->setZ( att.value("z").toInt() );
     brush->show();
     brush->name = att.value("name");

     if (inGroup)
         groupItems.append(brush);
   }
    
   if( att.value("class") == "PencilItem")
   {
  
   }
        
   if( att.value("class") == "TextItem")
   {
      QDir qf;
      qf = qf.home().absPath() + "/.qflash";

      CanvasTextItem* t = new CanvasTextItem( att.value("text") , canvas );
      t->setColor( att.value("color")  );
      QString font = att.value("font");
      if ( (access ( "/usr/share/libming/fonts/"+font+".fdb", F_OK )) && (access ( qf.absPath()+"/fonts/"+font+".fdb", F_OK )) && fontWarning == 0 )
      {
        fontWarning = 1;
        font = "default";
      }
      QFont f = QFont(font, att.value("size").toInt());
      t->setFont(f);
      t->selectable = att.value("select").toInt();
      t->move( att.value("x").toInt(), att.value("y").toInt() );
      t->setZ( att.value("z").toInt() );
      t->show();
      t->name = att.value("name");
      if (inGroup)
         groupItems.append(t);
   }
    
   if( att.value("class") == "ImageItem")
   {
      QDir qf;
      qf = qf.home().absPath() + "/.qflash";
     
     QImage image;
     image.load(qf.absPath()+"/"+att.value("url"));
     ImageItem* i = new ImageItem(image , canvas);
     i->fileName = att.value("url");
     i->move( att.value("x").toInt(), att.value("y").toInt());
     i->setZ(att.value("z").toInt());
     i->sw = att.value("sw").toDouble();
     i->sh = att.value("sh").toDouble();
     i->mirrorV = att.value("mirrorV").toInt();
     i->mirrorH = att.value("mirrorH").toInt();
     i->setSize( att.value("width").toInt(), att.value("height").toInt() );
     i->show();
     i->name = att.value("name");
     if (inGroup)
         groupItems.append(i);
   }
    
   if( att.value("class") == "Regular")
   {
     Regular* regu = new Regular( canvas );
     regu->setPen ( QPen(att.value("border")) );
     regu->setBrush ( QBrush(att.value("color")) );  
     regu->p = att.value("p").toInt() ;
     regu->ri = att.value("ri").toInt() ;
     regu->re = att.value("re").toInt() ; 
     regu->di =  att.value("di").toInt() ; 
     regu->de =  att.value("de").toInt() ;
     regu->star =  att.value("star").toInt() ;
     regu->setX( att.value("x").toInt() );
     regu->setY( att.value("y").toInt() );
     regu->setZ( att.value("z").toInt() );
     regu->show();
     regu->name = att.value("name");
     if (inGroup)
         groupItems.append(regu);
   }

   if( att.value("class") == "TextBox")
   {

      QDir qf;
      qf = qf.home().absPath() + "/.qflash";
      QString font = att.value("font");

      if ( (access ( "/usr/share/libming/fonts/"+font+".fdb", F_OK )) && (access ( qf.absPath()+"/fonts/"+font+".fdb", F_OK )) && fontWarning == 0 )
      {
        fontWarning = 1;
        font = "default";
      }
     QFont f = QFont( font, att.value("size").toInt());
     TextBox* tbox = new TextBox(canvas, att.value("text"), f);
     tbox->editable = att.value("edit").toInt();
     tbox->selectable = att.value("select").toInt();
     tbox->password = att.value("pass").toInt();
     tbox->multiline = att.value("multi").toInt();
     tbox->setX( att.value("x").toInt() );
     tbox->setY( att.value("y").toInt() );
     tbox->setZ( att.value("z").toInt() );
     QCanvasRectangle* tmpR = (QCanvasRectangle*)   tbox->boxBack;
     tmpR->setBrush( QColor ( att.value("backcolor")  ));
     tmpR->setSize( att.value("width").toInt(), att.value("height").toInt() );

     QCanvasText* tempTextItem = (QCanvasText*) tbox->boxText;
     tempTextItem->setColor( att.value("textcolor")  );

     tbox->name = att.value("name");
   }

  canvas->setAllChanged();
  canvas->update();
  }


    if(qName == "button")
    {
      inButton = 1;
      groupItems.clear();
      tmpButton = new ButtonItem();
      tmpButton->canvasButton = parent->can.at(frame);
      tmpButton->name = att.value("name");
    }

    if(qName == "group")
    {
      inGroup = 1;
      groupItems.clear();
    }

    if(qName == "canvas")
    {
       if(att.value("id").toInt() == 0)
         canvas = (QCanvas*) tmpButton->canvasUp;
       if(att.value("id").toInt() == 1)
         canvas = (QCanvas*) tmpButton->canvasOver;
       if(att.value("id").toInt() == 2)
         canvas = (QCanvas*) tmpButton->canvasDown;

    }

    if (qName == "action")
    {
       if(att.value("id") == "down")
         tmpButton->actions.actionDown =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );;
       if(att.value("id") == "over")
         tmpButton->actions.actionOver =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );;
       if(att.value("id") == "out")
         tmpButton->actions.actionOut =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );;
       if(att.value("id") == "up")
         tmpButton->actions.actionUp =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );;
       if(att.value("id") == "upoutside")
         tmpButton->actions.actionUpOutside =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );;
       if(att.value("id") == "dragout")
         tmpButton->actions.actionDragOut =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );;
       if(att.value("id") == "dragover")
         tmpButton->actions.actionDragOver =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );;

    }

return TRUE;
}



bool xml2canvas::endElement( const QString&, const QString&, const QString& qName)
{


   if (qName == "animation")  
   {
     if (fontWarning)
       parent->avisoFonts(); //warning about fonts stored in window class due to tr() needs a QOBJECT class
   }

   if(qName == "button")
   {
     QCanvasItemList newList = parent->copyFrameForButton(tmpButton->canvasUp ,  parent->can.at(frame) );
     parent->ed->multiSelect = newList;
     itemGroup* tmpGroup = parent->ed->group( tmpButton );
     tmpGroup->isButton = 1;
     tmpGroup->buttonGroup = tmpButton;
     inButton = 0;
   }

   if(qName == "group")
   {
     parent->ed->multiSelect = groupItems;
     itemGroup* tmpG = parent->ed->group();
     tmpG->canvas = ((QCanvasItem*) *groupItems.at(0))->canvas();
     tmpG->hideNodes();
     inGroup = 0;
   }

   return TRUE;
}


//--------------------------------------------------------









//xml2swf  parser starts here!!!








//--------------------------------------------------------


xml2swf::xml2swf(Window* tmp): QXmlDefaultHandler()
{
  parent = tmp;
}

bool xml2swf::startDocument()
{
  Ming_init();
  movie = new SWFMovie();
  inButton = 0;
  return TRUE;
}

bool xml2swf::startElement( const QString&, const QString&, 
                                    const QString& qName, 
                                    const QXmlAttributes& att )
  
{
  cout << qName << endl;
  if (qName == "animation")
  {
    movie->setDimension(  att.value("width").toInt() , att.value("height").toInt()   );
    frames = att.value("frames").toInt();
    if (att.value("rate").toInt() != 0)
       movie->setRate(att.value("rate").toInt() );
    else
       movie->setRate( 4 );   
    movieurl = att.value("movie");
    moviemp3 = att.value("mp3");

    if (!access ( moviemp3, F_OK ))
    {
       FILE* file;
       file=fopen(moviemp3, "rb");
       SWFSoundStream* sound;
       sound = new SWFSoundStream(file);
       movie->setSoundStream(sound);
    }
    QColor c = QColor(att.value("color"));
    movie->setBackground(c.red(), c.green(), c.blue() );
    movie->setDimension(att.value("width").toInt(), att.value("height").toInt());
    
    layers = att.value("layers").toInt();
    
    for (int t = 0; t <= layers; t++) 
      {
         QPtrList<SWFDisplayItem>* tmp = new QPtrList<SWFDisplayItem>;
         disp.append(tmp);
      }
    fnumber = 0;
  }
  
  if (qName == "frame")
  {
   for (int i=fnumber; i< att.value("number").toInt(); i++) //it makes all the blank frames before the frame that will be parsed
       {

        if (  (att.value("end").toInt() != 1 ) || (i <= frames-1) )
        {
            movie->nextFrame();
        }
       }


    if (att.value("asOnly").toInt() != 1 )
    {
      for (int i=0; i< (int) disp.at(  att.value("layer").toInt() )->count(); i++) // it clears the movie before parse another frame
        movie->remove(disp.at( att.value("layer").toInt() )->at(i));
      disp.at(att.value("layer").toInt())->clear();
    }
    fnumber = att.value("number").toInt();

    if (att.value("code") != "" )
    {

      QString action = att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "" ).replace( "\t", "");
      SWFAction* a = new SWFAction(action);
      movie->add(a);
    }


  }



    if(qName == "button")
    {
      inButton = 1;
      buttonLayer = att.value("layer").toInt();
      button = new SWFButton();
      name = att.value("name");
    }

    if(qName == "canvas")
    {
       if(att.value("id").toInt() == 0)
         buttonCanvas = 0;
       if(att.value("id").toInt() == 1)
         buttonCanvas = 1;
       if(att.value("id").toInt() == 2)
         buttonCanvas = 2;

    }

    if (qName == "action")
    {
       if(att.value("id") == "down")
       {
         QString action =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );
         SWFAction *a = new SWFAction(action);
         button->addAction(a,SWFBUTTON_MOUSEDOWN);
       }
       if(att.value("id") == "over")
       {
         QString action =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );
         SWFAction *a = new SWFAction(action);
         button->addAction(a,SWFBUTTON_MOUSEOVER);
       }
       if(att.value("id") == "out")
       {
         QString action =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );
         SWFAction *a = new SWFAction(action);
         button->addAction(a,SWFBUTTON_MOUSEOUT);
       }
       if(att.value("id") == "up")
       {
         QString action =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );
         SWFAction *a = new SWFAction(action);
         button->addAction(a,SWFBUTTON_MOUSEUP);
       }
       if(att.value("id") == "upoutside")
       {
         QString action =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );
         SWFAction *a = new SWFAction(action);
         button->addAction(a,SWFBUTTON_MOUSEUPOUTSIDE);
       }
       if(att.value("id") == "dragout")
       {
         QString action =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );
         SWFAction *a = new SWFAction(action);
         button->addAction(a,SWFBUTTON_DRAGOUT);
       }
       if(att.value("id") == "dragover")
       {
         QString action =  att.value("code").replace( "&quot;",  "\"" ).replace( "&new;", "\n" );
         SWFAction *a = new SWFAction(action);
         button->addAction(a,SWFBUTTON_DRAGOVER );
       }

    }






  if(qName == "item")
  {
     int sepx = 150;
     int sepy = 150;
     //int scale = 1;



    if( att.value("class") == "LineItem")
    {
      SWFShape* shape = new SWFShape();
      QColor c = QColor(att.value("border"));
      shape->setLine(1, c.red(), c.green(), c.blue() );
      shape->movePenTo(att.value("x").toInt(),att.value("y").toInt());
      shape-> drawLineTo(att.value("x2").toInt(),att.value("y2").toInt());

      if (inButton)
      {
        int flags = 0;
        if (buttonCanvas == 0)
          flags = SWFBUTTON_UP | SWFBUTTON_HIT;
        if (buttonCanvas == 1)
          flags = SWFBUTTON_OVER;
        if (buttonCanvas == 2)
          flags = SWFBUTTON_DOWN;
        button->addShape( shape, flags );
      }
      else
      {
        SWFSprite* sprite= new SWFSprite();
        sprite->add( shape );
        sprite->nextFrame();
        SWFDisplayItem* frame = movie->add( sprite );
        frame->move(-sepx,-sepy);
        frame->setDepth( att.value("layer").toInt() );
        disp.at( att.value("layer").toInt()  )->append(frame);
        frame->setName (att.value("name"));
      }
    }
    
    if( att.value("class") == "RectItem")
    {
      SWFShape* shape = new SWFShape();
      QColor a = QColor(att.value("border"));
      shape->setLine(1, a.red(), a.green(), a.blue() );
      QColor c = QColor(att.value("color"));
      SWFFill *fill = shape->addSolidFill( c.red(), c.green(), c.blue() );
      shape->setRightFill(fill);
      shape->movePenTo(att.value("x").toInt(), att.value("y").toInt());
      shape->drawLine( att.value("width").toInt(), 0 );
      shape->drawLine( 0, att.value("height").toInt() );
      shape->drawLine( -1*att.value("width").toInt(), 0 );
      shape->drawLine( 0, -1*att.value("height").toInt() );

      if (inButton)
      {
        int flags = 0;
        if (buttonCanvas == 0)
          flags = SWFBUTTON_UP | SWFBUTTON_HIT;
        if (buttonCanvas == 1)
          flags = SWFBUTTON_OVER;
        if (buttonCanvas == 2)
          flags = SWFBUTTON_DOWN;
        button->addShape( shape, flags );
      }
      else
      {
        SWFSprite* sprite= new SWFSprite();
        sprite->add( shape );
        sprite->nextFrame();
        SWFDisplayItem* frame = movie->add( sprite );
        frame->move(-sepx,-sepy);
        frame->setDepth( att.value("layer").toInt() );
        disp.at(   att.value("layer").toInt()  )->append(frame);
        frame->setName (att.value("name"));
      }
    }

    if( att.value("class") == "OvalItem")
    {
      int x = att.value("x").toInt();
      int y = att.value("y").toInt();
      int radius = att.value("width").toInt()/2;
      int yRadius = att.value("height").toInt()/2;
      SWFShape* shape = new SWFShape();
      QColor a = QColor(att.value("border"));
      shape->setLine(1, a.red(), a.green(), a.blue() );
      QColor c = QColor(att.value("color"));
      SWFFill *fill = shape->addSolidFill( c.red(), c.green(), c.blue() );
      shape->setRightFill(fill);
      
      double theta = M_PI_4;
      double xrCtrl = radius/cos((double)theta/2);
      double yrCtrl = yRadius/cos((double)theta/2);
      double angle = 0;
      shape->movePenTo(x+radius, y);
      for ( int i = 0; i<8; i++) 
      {
          angle += theta;
          double angleMid = angle-(theta/2);
          double cx = x+cos((double)angleMid)*xrCtrl;
          double cy = y+sin((double)angleMid)*yrCtrl;
          double px = x+cos((double)angle)*radius;
          double py = y+sin((double)angle)*yRadius;
          shape->drawCurveTo(cx, cy, px, py);
      }


      if (inButton)
      {
        int flags = 0;
        if (buttonCanvas == 0)
          flags = SWFBUTTON_UP | SWFBUTTON_HIT;
        if (buttonCanvas == 1)
          flags = SWFBUTTON_OVER;
        if (buttonCanvas == 2)
          flags = SWFBUTTON_DOWN;
        button->addShape( shape, flags );
      }
      else
      {
        SWFSprite* sprite= new SWFSprite();
        sprite->add( shape );
        sprite->nextFrame();
        SWFDisplayItem* frame = movie->add( sprite );
        frame->move(-sepx,-sepy);
        frame->setDepth( att.value("layer").toInt() );
        disp.at(   att.value("layer").toInt()  )->append(frame);
        frame->setName (att.value("name"));
      }
    }
    
    if( att.value("class") == "Polygon")
    {
      SWFShape* shape = new SWFShape();
      QColor a = QColor(att.value("border"));
      shape->setLine(att.value("width").toInt() , a.red(), a.green(), a.blue() );
      shape->movePenTo(att.value("x0").toInt(),att.value("y0").toInt());
      QColor c = QColor(att.value("color"));
      SWFFill *fill = shape->addSolidFill( c.red(), c.green(), c.blue() );
      shape->setRightFill(fill);
      for (int i = 0; i < 10000; i++)
      {
        if (att.value("x"+QString::number(i)).toInt() == 0 && att.value("y"+QString::number(i)).toInt() == 0) 
          break;
        else
          shape-> drawLineTo(att.value("x"+QString::number(i)).toInt() , att.value("y"+QString::number(i)).toInt());
      }
      shape-> drawLineTo(att.value("x0").toInt() , att.value("y0").toInt());

      if (inButton)
      {
        int flags = 0;
        if (buttonCanvas == 0)
          flags = SWFBUTTON_UP | SWFBUTTON_HIT;
        if (buttonCanvas == 1)
          flags = SWFBUTTON_OVER;
        if (buttonCanvas == 2)
          flags = SWFBUTTON_DOWN;
        button->addShape( shape, flags );
      }
      else
      {
        SWFSprite* sprite= new SWFSprite();
        sprite->add( shape );
        sprite->nextFrame();
        SWFDisplayItem* frame = movie->add( sprite );
        frame->move(-sepx,-sepy);
        frame->setDepth( att.value("layer").toInt() );
        disp.at(   att.value("layer").toInt()  )->append(frame);
        frame->setName (att.value("name"));
      }
    }
    
    if( att.value("class") == "BrushItem")
    {
      SWFShape* shape = new SWFShape();
      QColor c = QColor(att.value("border"));
      shape->setLine(att.value("width").toInt() , c.red(), c.green(), c.blue() );
      shape->movePenTo(att.value("x0").toInt(),att.value("y0").toInt());
      for (int i = 0; i < 10000; i++)
      {
         if (att.value("x"+QString::number(i)).toInt() == 0 && att.value("y"+QString::number(i)).toInt() == 0) 
           break;
         else
           shape-> drawLineTo(att.value("x"+QString::number(i)).toInt() , att.value("y"+QString::number(i)).toInt());
      }

      if (inButton)
      {
        int flags = 0;
        if (buttonCanvas == 0)
          flags = SWFBUTTON_UP | SWFBUTTON_HIT;
        if (buttonCanvas == 1)
          flags = SWFBUTTON_OVER;
        if (buttonCanvas == 2)
          flags = SWFBUTTON_DOWN;
        button->addShape( shape, flags );
      }
      else
      {
        SWFSprite* sprite= new SWFSprite();
        sprite->add( shape );
        sprite->nextFrame();
        SWFDisplayItem* frame = movie->add( sprite );
        frame->move(-sepx,-sepy);
        frame->setDepth( att.value("layer").toInt() );
        disp.at(   att.value("layer").toInt()  )->append(frame);
        frame->setName (att.value("name"));
      }
    }


    
    if( att.value("class") == "ImageItem")
    {
      QDir qf;
      qf = qf.home().absPath() + "/.qflash";

      SWFBitmap *bitmap;
      QImage image;
      image.load( qf.absPath()+"/"+att.value("url"));
      QPixmap exp = QPixmap(  image  );
      remove(qf.absPath()+"/qflashtmp/tmp.png");
      remove(qf.absPath()+"/qflashtmp/tmp.dbl");
      remove(qf.absPath()+"/qflashtmp/tmp.jpg");
      if (image.hasAlphaBuffer()) //if has transparencies
      {
         if (access(parent->UTILSPATH + "png2dbl", F_OK))
         {
           parent->avisoParser(); //warning about ming-utils stored in window class due to tr() needs a QOBJECT class
         }
         else
         {
           exp.save(qf.absPath()+"/qflashtmp/tmp.png", "PNG" );
           system ( parent->UTILSPATH +"png2dbl "+qf.absPath()+"/qflashtmp/tmp.png");
           qf =  qf.absPath()+"/qflashtmp/tmp.dbl";
           bitmap = new SWFBitmap( (char*) qf.absPath().latin1() );

         }
      }
      else  // if doesn't have transparencies
      {
        exp.save( qf.absPath()+"/qflashtmp/tmp.jpg", "JPEG" );
        qf =  qf.absPath()+"/qflashtmp/tmp.jpg";

        bitmap = new SWFBitmap( (char*) qf.absPath().latin1() );

      }
      
      if (!access(parent->UTILSPATH +"png2dbl", F_OK) || !image.hasAlphaBuffer())
      {
        SWFShape* shape = new SWFShape();
        shape->setLine(0, 0, 0, 0, 0 );
        SWFFill *fill = shape -> addBitmapFill( bitmap );
        shape->setRightFill(fill);
        shape->drawLine( att.value("width").toInt()/att.value("sw").toDouble(), 0 );
        shape->drawLine( 0, att.value("height").toInt()/att.value("sh").toDouble() );
        shape->drawLine( -1*att.value("width").toInt()/att.value("sw").toDouble(), 0 );
        shape->drawLine( 0, -1*att.value("height").toInt()/att.value("sh").toDouble());

        if (inButton)
        {
          int flags = 0;
          if (buttonCanvas == 0)
            flags = SWFBUTTON_UP | SWFBUTTON_HIT;
          if (buttonCanvas == 1)
            flags = SWFBUTTON_OVER;
          if (buttonCanvas == 2)
            flags = SWFBUTTON_DOWN;
          button->addShape( shape, flags );
//           int a = att.value("x").toInt()-sepx;
//           int b = att.value("y").toInt()-sepy;
//           frame->moveTo( a, b );
//           frame->scale( att.value("sw").toDouble(), att.value("sh").toDouble());

        }
        else
        {
          SWFSprite* sprite= new SWFSprite();
          sprite->add( shape );
          sprite->nextFrame();
          SWFDisplayItem* frame = movie->add( sprite );
          int a = att.value("x").toInt()-sepx;
          int b = att.value("y").toInt()-sepy;
          frame->moveTo( a, b );
          frame->scale( att.value("sw").toDouble(), att.value("sh").toDouble());
          frame->setDepth( att.value("layer").toInt() );
          disp.at(   att.value("layer").toInt()  )->append(frame);
          frame->setName (att.value("name"));
        }
       }
    }
    if( att.value("class") == "Regular")
    {
      SWFShape* shape = new SWFShape();
      QColor a = QColor(att.value("border"));
      shape->setLine(1, a.red(), a.green(), a.blue() );
      QColor c = QColor(att.value("color"));
      SWFFill *fill = shape->addSolidFill( c.red(), c.green(), c.blue() );
      shape->setRightFill(fill);
      QPointArray tempa = regPoints(att.value("re").toInt(), att.value("ri").toInt(), att.value("de").toInt(), att.value("di").toInt(), att.value("p").toInt(), att.value("star").toInt());
      shape->movePenTo(tempa.at(0).x() , tempa.at(0).y());
      for (int i = 1; i <(int) tempa.count(); i++)
      {
         shape->drawLineTo(tempa.at(i).x() , tempa.at(i).y());
      }
      shape-> drawLineTo(tempa.at(0).x() , tempa.at(0).y());


      if (inButton)
      {
        int flags = 0;
        if (buttonCanvas == 0)
          flags = SWFBUTTON_UP | SWFBUTTON_HIT;
        if (buttonCanvas == 1)
          flags = SWFBUTTON_OVER;
        if (buttonCanvas == 2)
          flags = SWFBUTTON_DOWN;
        button->addShape( shape, flags );

      }
      else
      {
        SWFSprite* sprite= new SWFSprite();
        sprite->add( shape );
        sprite->nextFrame();
        SWFDisplayItem* frame = movie->add( sprite );
        frame->moveTo( att.value("x").toInt()-sepx, att.value("y").toInt()-sepy );
        frame->setDepth( att.value("layer").toInt() );
        disp.at(   att.value("layer").toInt()  )->append(frame);
      }

//       frame->moveTo(att.value("x").toInt()-sepx,att.value("y").toInt()-sepy);

    }

    if( att.value("class") == "TextItem")
    {
      QDir qf;
      qf = qf.home().absPath() + "/.qflash";
      
      QString fontpath;
      if (!access(qf.absPath()+"/fonts/"+att.value("font")+".fdb", F_OK))
        fontpath = qf.absPath()+"/fonts/"+att.value("font")+".fdb";
      else
        fontpath = "/usr/share/libming/fonts/"+att.value("font")+".fdb";

      if (!access(fontpath, F_OK))
      {
//         cout << fontpath << endl;
        SWFFont* f = new SWFFont( (char*)  fontpath.ascii() ); //styleHint ()
 
        int flags = SWFTEXTFIELD_NOEDIT | SWFTEXTFIELD_MULTILINE;
        if ( !att.value("select").toInt() )
          flags = flags | SWFTEXTFIELD_NOSELECT;


        SWFTextField* t = new SWFTextField();
        QColor c = QColor(att.value("color"));
        t->setColor( c.red(), c.green(), c.blue() );
        t->setHeight(att.value("size").toInt());

        t->addString(att.value("text"));
        t->setFont(f);

        t->setBounds(att.value("width").toInt(),att.value("height").toInt()+ att.value("size").toInt());

        t->setFlags( flags );

        if (inButton)
        {
          int flags = 0;
          if (buttonCanvas == 0)
            flags = SWFBUTTON_UP | SWFBUTTON_HIT;
          if (buttonCanvas == 1)
            flags = SWFBUTTON_OVER;
          if (buttonCanvas == 2)
            flags = SWFBUTTON_DOWN;
          button->addShape( t, flags );
//         frame->moveTo(att.value("x").toInt() -sepx ,att.value("y").toInt()-sepy + att.value("size").toInt() + 8 );
        }
        else
        {
          SWFSprite* sprite= new SWFSprite();
          sprite->add( t );
          sprite->nextFrame();
          SWFDisplayItem* frame = movie->add( sprite );
          frame->moveTo(att.value("x").toInt() -sepx ,att.value("y").toInt()-sepy +2 );
          frame->setDepth( att.value("layer").toInt() );
          disp.at(   att.value("layer").toInt()  )->append(frame);
//           t->setName(att.value("name"));
          frame->setName (att.value("name"));
        }
      }
    }
    if( att.value("class") == "TextBox")
    {

      QDir qf;
      qf = qf.home().absPath() + "/.qflash";

      QString fontpath;
      if (!access(qf.absPath()+"/fonts/"+att.value("font")+".fdb", F_OK))
        fontpath = qf.absPath()+"/fonts/"+att.value("font")+".fdb";
      else
        fontpath = "/usr/share/libming/fonts/"+att.value("font")+".fdb";
      if (!access(fontpath, F_OK))
      {
        SWFFont* font = new SWFFont( (char*)  fontpath.ascii() ); //styleHint ()

        int flags = SWFTEXTFIELD_DRAWBOX;

        if ( !att.value("edit").toInt() )
          flags = flags | SWFTEXTFIELD_NOEDIT;

        if ( att.value("pass").toInt() )
          flags = flags | SWFTEXTFIELD_PASSWORD;

        if ( !att.value("select").toInt() )
          flags = flags | SWFTEXTFIELD_NOSELECT;

        if ( att.value("multi").toInt() )
          flags = flags | SWFTEXTFIELD_MULTILINE | SWFTEXTFIELD_WORDWRAP;

        SWFTextField *t = new SWFTextField( );
        t->setBounds(att.value("width").toInt(),att.value("height").toInt() + att.value("size").toInt()*0.3);
        t->setHeight(att.value("size").toInt());
        t->setFlags( flags );
        t->addString(att.value("text"));
        t->setFont(font);
        t->setLeftMargin( 5 );
        QColor c = QColor(att.value("color"));
        t->setColor( c.red(), c.green(), c.blue() );
        t->setVariableName (att.value("name"));

//      tbox->setZ( att.value("z").toInt() );
//      tmpR->setBrush( QColor ( att.value("backcolor")  ));


        SWFSprite* sprite= new SWFSprite();
        sprite->add( t );
        sprite->nextFrame();
        SWFDisplayItem* frame = movie->add( sprite );
        frame->setName( att.value("name"));
        frame->moveTo(att.value("x").toInt() -sepx ,att.value("y").toInt()-sepy  +2 );
        frame->setDepth( att.value("layer").toInt() );
        disp.at(   att.value("layer").toInt()  )->append(frame);

     }


    }

  }

 return TRUE;
}

bool xml2swf::endElement( const QString&, const QString&, const QString& qName )
{

    if(qName == "button")
    {
      int sepx = 150;
      int sepy = 150;
      inButton = 0;
      SWFSprite* sprite= new SWFSprite();
      sprite->add( button );
      sprite->nextFrame();
      SWFDisplayItem* frame = movie->add(sprite);
      frame->setName( name );

      disp.at(  buttonLayer  )->append(frame);

      frame->move(-sepx,-sepy);
//       frame->moveTo(att.value("x").toInt()-sepx,att.value("y").toInt()-sepy);
//       frame->setDepth( att.value("layer").toInt() );

//       $i = $m->add($b);
//       $i->moveTo(20, 40);
    }



    if (qName == "animation")
    {
      movie->save (movieurl);
    }


    return TRUE;
}





//this classes are needed to get the points in the regular shapes

QPointArray xml2swf::regPoints(int re, int ri, int de, int di, int p, int star)
{
  QPointArray tempa;
  if(star)
  {
    tempa = QPointArray( p*2 );
    QPointArray tempInt = regTmpPoints(ri, di+(180/p), p);
    QPointArray tempExt = regTmpPoints(re, de, p);
    for (int i=0; i<(int)tempInt.count(); i++)
      tempa.setPoint(i*2+1, tempInt.at(i).x(), tempInt.at(i).y()  ); 
    
    for (int i=0; i<(int)tempExt.count(); i++)
      tempa.setPoint(i*2,tempExt.at(i).x(), tempExt.at(i).y()  ); 
  }
  else
  {
    tempa = QPointArray( p );
    tempa = regTmpPoints(re, de, p);
  }
  return tempa;
}


QPointArray xml2swf::regTmpPoints(int radio, int desp, int p)
{
  QPointArray tempa = QPointArray( p );
  double angle;
  for (int i=0; i<p; i++)
  {
    angle = (double) (i+1)*360/p + desp;
    angle = angle/360*2*3.1416;
    tempa.setPoint(i, (int)(radio*cos(angle)),(int)(radio*sin(angle) )  );  
  }
  return tempa;
}


